// This class works with text in memory

#ifndef __SCROLL_VIEW_H_
#define __SCROLL_VIEW_H_

#include "simple.h"
#include "showtext.h"
#include "nret.h"

extern char* firstString(int first, char* string);


class ScrollView : public ShowText
    {
    protected:
	loc start;               // from top and left of text in memory, pseudotxt
	loc pos;                 // from top and left of text on screen

	char* string;            // the string to view
	loc scale;
	int interval;
	int direction;
	rect bnd;              // visible area, screen coords
	loc curs;              // cursor, pixels
	char* findString;      // string to find;
	int number_of_nl;      // nl's in the string
    public:
	ScrollView(loc start_pos, char* str,
		  rect b, loc sc = loc(1, 1), int interv = 15,
		  int dir = HORIZ_DIR);
	void show(int first, int last = 0, int mode = COPY_PUT,
		  int shift = 0);
	char* showString(char* str, loc scale, int mode);
	int lineLen(int num);

	void showCursor();

	void hideCursor() { showCursor(); }
	char* getLine(int n); // returns 0-terminated heap allocated string
	int find(char* word);
	int up(int jmp = 1);
	int dn(int jmp = 1);
	int left(int jmp = 1);
	int right(int jmp = 1);
	void home();
	void end();
	int pgUp();
	int pgDn();
	void toTop();
	void toBottom();


	void setStart(loc s) { start = s; }
	void setPos(loc p) { pos = p; }
	void setString(char* s) { string = s; }
	void setScale(loc s) { scale = s; }
	void setInterval(int interv) { interval = interv; }
	void setDirection(int dir) { direction = dir; }
    };

#endif __SCROLL_VIEW_H_