#ifndef __SCREEN_H_
#define __SCREEN_H_

#include "graphpp.h"
#include "simple.h"

enum { MEDIUM_ICON = 1, SMALL_ICON, LARGE_ICON };  // Icon types

struct ScreenSet
    {
    uchar cell_height;        // Height of cells of the screen (25 x 80)
    uchar log2cell_width;
    uchar cell_width;         // Width of cells of the screen (25 x 80)

    uchar standart_width;         // Char dimentions, not connected with
    uchar standart_height;        // cells. Used as default for screen output.
    uchar sub_interval;

    loc ICON_PIXELS_1;     // Type 1 icon size in pixels
    loc ICON_PIXELS_2;     // Type 2 icon size in pixels
    loc ICON_PIXELS_3;     // Type 3 icon size in pixels

    loc icon_types[4];     // Array of loc(0, 0), ICON_TEXT_1, 2, 3.

    int g_driver;           // BGI driver and mode
    int g_mode;

    ScreenSet(int gdriver, int gmode);
    int* get_cells(rect cur_rect);
    };
extern ScreenSet* pScreenSet;
///////////////////////////////////////


#endif __SCREEN_H_