#ifndef __REPORT_MAKER_H_
#define __REPORT_MAKER_H_

#include <stdio.h>

/*   ReportMaker class reads report format file, producing PAGE_LAYOUT object.
______________________________________________________________________________
PAGETOP
Page top information
PAGETOP

TABLETOP
Table top information
TABLETOP

RECORDTOP
...
RECORDTOP

RECORD
RECORD

RECORDBOTTOM
RECORDBOTTOM

TABLEBOTTOM
TABLEBOTTOM

PAGEBOTTOM
PAGEBOTTOM

______________________________________________________________________________

    Inside the band all non-@-started information mean TEXT_INFO.
    Non-text addinfo should be put in header - between band specifier
    and string, containing only @. For example:

    @PCX filename name size_x size_y
    mean that every time we type name, ReportMaker will process it as
    PCX picture of given size (cells). (Not supported in 1.0)

    Another way - specify addinfo in text. For example:

    Hello, friend!
    Today is @date     . Happy New Year!

    This text will be splitted to:
    1. Hello, friend!
    2. Today is
    3. DATE_TYPE_INFO
    4. . Happy New Year!

    There are:
        @date, @DD, @MM, @YY, @no, @page.

    Fields in RECORD BAND. Lets suppose that table have 3 fields:
    Name (A28, wrap 10, 2), Date (D) and Number (N).
    Example:

RECORD
    Name of worker:
    @<1>                   @<2>    <--- Date
                           @<3>    <--- Record number

RECORD

*/

#include "prn_page.h"

class ReportMaker
    {
    protected:
        FILE* f;
        int line;        // From page top
        int bline;       // from band top

    public:
        ReportMaker() { line = 0; bline = 0; }
        ~ReportMaker() {}

        PAGE_LAYOUT* getPageLayout(char* fileName);
        int get_command(char* buf, int i, ADD_LIST* info,
	    FIELD_LIST* flist = NULL);
        int get_band(ADD_LIST* info, FIELD_LIST* flist = NULL);
    };


#endif __REPORT_MAKER_H_