/* CARCASE.H   Carcase is a set of borders of different types
   0 - no border, 1 - first type and so on. Width of every side of
   border (in pixels) showed in area[border_type].
   Some files CARCASE?.* may be used to realize different sets of
   carcases.
*/

#ifndef __CARCASE_H_
#define __CARCASE_H_

#include "graphpp.h"
#include "colors.h"

enum BORDERS { NO_BORDER, STANDART_BORDER, BUTTON_BORDER, HILITE_BORDER,
	       PRESS_BORDER, SHOW_BORDER }; // types of borders - may be
			       // expanded
#define NONE rect(0, 0, 0, 0)
#define STANDART rect(6, 6, 6, 6)
#define BUTTON rect(2, 2, 2, 2)
#define HILITE rect(2, 2, 2, 2)
#define PRESS rect(2, 2, 2, 2)
#define SHOW  rect(6, 6, 6, 6)

// Keeps width of borders of all types.
// From program you will call area[border_type].
static rect area[] = { NONE, STANDART, BUTTON, HILITE, PRESS, SHOW };


struct Carcase
    {
    void show(BORDERS b_type, rect coordinates, int s = 0);
		 //    Coordinates are given in pixels - not in text cells
    };

#endif __CARCASE_H_