/*   PCX.H - tools for pcx file <--> screen swapping.
	     VGA, EGA 16 color modes are recomended.
	     Palette info could be (for perfomance) ignored, producing
	     incompatible files, of loaded from *.SYS file. In the last case
	     Borland standart palette is used. COLOR.SYS and BW.SYS are
	     the little PCX files, which are used as standart for palette
	     setting.
*/

#ifndef __PCX_H_
#define __PCX_H_

#include <stdio.h>
#include "graphpp.h"
#include "pcxstrm.h"
#include "image_p.h"
#include "ic_part.h"
#include "image.h"
#include <io.h>
#include <mem.h>
#include <alloc.h>

struct pcxheader {
     char       manuf;           /* Always = 10 for Paintbrush     */
     char       hard;            /* Version info                   */
     char       encod;           /* Coding ( = 1)                  */
     char       bitpx;           /* bit per pixel                  */
     int        x1;              /* Picture size (inclusive)       */
     int        y1;
     int        x2;
     int        y2;
     int        hres;            /* horiz. resolution of display   */
     int        vres;            /* vert. resolution of display    */
     char       clrma[48];       /* Palette                        */
     char       vmode;           /* Ignored                        */
     char       nplanes;         /* Num. of planes (rel. 2.5 = 0)  */
     int        bplin;           /* Bytes per line                 */
     int        palinfo;         /* Palette info (1=col.,2 = grey) */
     int        shres;           /* Scanner resolution             */
     int        svres;           /*                                */
     char       xtra[54];        /* Filter                         */
 };

void put_pcx_header(FILE* f, pcxheader* p, loc pos, int pal = 1,
    int planes = N_PLANES);

int get_pcx_header(pcxstream* s, pcxheader* p_h);
int get_pcx_header(FILE* file, pcxheader* p_h);
int get_pcx_header(char* name, pcxheader* p_h);

// pal flag could be set to 0 for speed, but resulting files will be
// compatible only with KNOW-HOW functions.
// Always 1 bit / pixel and 4 planes 16-color images
void pcx_scr_file(rect coord, char* name, int pal = 0);

int pcx_file_scr(char* name, loc pos, int* cells = NULL, int mode = COPY_PUT);


#endif __PCX_H_