#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "ljfonts.h"


#define LJCHDSCFORMAT 4
#define LJCHDSCCLASS  1
#define LJCHDSCSIZE  14
#define LJMINFDSC    26

#define MAXFL  64000  // maximum acceptable f 
#define MAXSCALE 16

#define SWAPB(w)  (((w & 0x00ff)<<8 ) + (w>>8))

 class far ljchardsc // class is used only through pointers
 {
  char Format; char Continuation;
  char DescriptorSize; char Class;
  char Orientation;/* 0 - portrait */ char Reserved;
  unsigned _leftoffset;
  unsigned _topoffset;
  unsigned _charwidth;
  unsigned _charheight;
  unsigned _deltax;
  char BitMap[4096];

  int LeftOffset()     {return SWAPB(_leftoffset );}
  int TopOffset()      {return SWAPB(_topoffset  );}
  int CharacterWidth() {return SWAPB(_charwidth  );}
  int CharacterHeight(){return SWAPB( _charheight);}
  int DeltaX()         {return SWAPB(_deltax     );}


  int scaleDX(int xscale) // in dots !
      { int deltax;
	    deltax=(DeltaX()>>2)/xscale;
      if(deltax <= ( CharacterWidth() / xscale)) deltax++;
      return deltax;}

  friend class ljfont;
friend void drawscaledstr (const ljfont& font,uchar * s,int xscale,int yscale,int write_mode, int dir);
friend void drawscaledchar(const ljfont& font,uchar c,int xscale,int yscale,int threshold,int write_mode, int dir);
friend void drawstr(const ljfont& font,char * s,int transparent);
friend void drawchar(const ljfont& font,char c,int transparent);

};



class ljfontdsc
 {
  unsigned _descriptorsize;
  char Reserved2; char FontType;
  unsigned _reserved4;
  unsigned _baselinedist;
  unsigned _cellwidth;
  unsigned _cellheight;
  char Orientation; /* 0 - portrait */ char  Spacing; /* 0 - fixed */
  unsigned _symbolset;
  unsigned _pitch;
  unsigned  _height;
  unsigned  _xheight;
  char WidthType; char Style; /* 1 - italics */
  signed char StrokeWeight;/*-7...7*/ char Typeface;
  char Reserved26; char SerifStyle;
  unsigned _reserved28;
  signed char UnderlineDistance; char UnderlineHeight;
  unsigned _textheight;
  unsigned _textwidth;
  unsigned _reserved36;
  unsigned _reserved38;
  char PitchExtended; char HeightExtended;
  unsigned _reserved42;
  unsigned _reserved44;
  unsigned _reserved46;
  char FontName[16]; // Not 0 - terminated !

  int DescriptorSize()  {return SWAPB( _descriptorsize );}
  int BaselineDistance(){return SWAPB( _baselinedist   );}
  int CellWidth()       {return SWAPB(_cellwidth       );}
  int CellHeight()      {return SWAPB( _cellheight     );}
  int Pitch()           {return SWAPB(_pitch           );}
  int Height()		{return SWAPB( _height         );}
  int xHeight()		{return SWAPB(_xheight         );}
  int TextHeight()	{return SWAPB( _textheight     );}
  int TextWidth() 	{return SWAPB( _textwidth      );}

       friend class ljfont;
};



int gethpparm(const char * s,char Expected_delimiter, char *& result)
 // s points to start of digits
 // get ascii parameter of PCL command
 // returns -1 on error
 // result points after the delimeter
  { char  a[10]; int i,n;

     for (i=0;i<8 && s[i]!=Expected_delimiter;i++)a[i]=s[i];
     if( s[i]!=Expected_delimiter) return -1;
     a[i]='\0';
     if (! isdigit(a[0])) return -1;
     n = atoi(a);
     result=(char*)s+i+1;
     return n;
  }

 int fits(const char * s,const char * pattern)
  // returns  1 - ok
  //          0 - does not fit
  {
      while (*pattern) if(*pattern++ != *s ++) return 0;
      return 1;
 }


inline ljchardsc far * ljfont::operator[](uchar n) const
   {
    void _seg * datas = (void _seg*) (void far*)data;
    return letters[n]? datas +letters[n] : 0;
  }


 ljfont::ljfont(const char * name) :ok(0)
  { int i,f,n,c; long l; char * buf; char * s,* s_end;
    for (i=0;i<256;i++)
     {
      letters[i]=0;
      }
    f=_open(name,O_RDONLY);
    if (f<0) return;
    l=filelength(f);
    if(l<0) return;
    if (l>MAXFL) return;
    data=buf=new char[l];
	 s_end=buf+l;
    if (! buf) return;
    n=_read(f,buf,l);
    if((n==-1) || (unsigned(n)<l)) return;
    _close(f);


    if (! fits(buf,"\x1b)s") ) return; // font header
    if ( (i=gethpparm(buf+3,'W',s)) <= 0 ) return;
    descriptor=(ljfontdsc *) s;
    if (descriptor->DescriptorSize() <LJMINFDSC) return;
    if (descriptor->Orientation!=0) return;
	  s+=i;      //skip_header


  while(s<s_end)
   {
    if (! fits(s,"\x1b*c")) break; //char #
	c=gethpparm(s+3,'E',s); if(c<0 || c >255) break;
    if (! fits(s,"\x1b(s"))break; //char data
    if ( (i=gethpparm(s+3,'W',s)) <= 0 ) break;
	letters[c]= (ljchardsc near *) s;
	s+=i;
  }

    ljchardsc far * dsc;

  //now check char descriptors
    for (i=0;i<256;i++)
    {
     if (letters[i]==0) continue;
      dsc=  operator[](i);
      if( dsc->Format !=   LJCHDSCFORMAT) return;
      if( dsc->Class!= LJCHDSCCLASS) return;
      if( dsc->DescriptorSize!=LJCHDSCSIZE)return;
      if( dsc->Orientation !=0) return; // landscape not supported
					// for now


    }

    ok=1;
 }



   ljfont:: ~ljfont()
   {
    delete ((char*) data);
//    delete data;
 }



void putpixel(int x,int y,int color,int write_mode) // overloaded putpixel
{ int screen;
  if (write_mode & 3) screen=getpixel(x,y);
  switch(write_mode)
  {
    case COPY_PUT:putpixel(x,y,color);  break;
    case XOR_PUT: putpixel(x,y, color ^ screen);  break;
    case OR_PUT:  putpixel(x,y, color | screen);  break;
    case AND_PUT: putpixel(x,y, color & screen);  break;
    case NOT_PUT: putpixel(x,y, ~color);  break;

  }
}



/*

  㭪樨  ॠ樨 ⥬ न, ⮩  90

*/
inline int getx(int dir)
{
 if(dir) return gety();
 return getx();
}

inline int gety(int dir)
{
 if(dir) return getmaxx() - getx();
 return gety();
}

inline int getmaxx(int dir)
{
if(dir) return getmaxy();
return getmaxx();
}
inline int getmaxy(int dir)
{
if(dir) return getmaxx();
return getmaxy();
}

inline void putpixel(int x, int y,int color, int write_mode, int dir)
{
if(dir) putpixel(y, getmaxx() - x, color, write_mode);
else putpixel(x, y, color, write_mode);
}

inline void moveto(loc xy, int dir)
    {
    if(dir) moveto(xy.Y, getmaxx() - xy.X);
    else moveto(xy);
    }

inline void moverel(int x, int y, int dir)
{
 if (dir) moverel(y, x);
 else moverel(x,y);
}
/*
inline int getx(int dir)
{
 if(dir) return getmaxy()-gety();
 return getx();
}

inline int gety(int dir)
{
 if(dir) return getx();
 return gety();
}

inline int getmaxx(int dir)
{
if(dir) return getmaxy();
return getmaxx();
}
inline int getmaxy(int dir)
{
if(dir) return getmaxx();
return getmaxy();
}

inline void putpixel(int x, int y,int color, int write_mode, int dir)
{
if(dir) putpixel(getmaxy()-y,x, color, write_mode);
else putpixel(x, y, color, write_mode);
}

inline void moverel(int x, int y, int dir)
{
 if (dir) moverel(y,-x);
 else moverel(x,y);
}
*/

 void drawchar(const ljfont& font,char c,int transparent)
   {  int x,y,x0,y0,x1,y1; ljchardsc far * symbol;
      int bytesperrow,nrows,ncols;  int color,bkcolor;
      int i,bi,by;char B;

       symbol=font [c];
       if (symbol==0) return;
       color=getcolor();
       if(! transparent )
	{ fillsettingstype fs;
	  getfillsettings (&fs);
	  bkcolor=fs.color;
	}
       x0=getx(); y0=gety();
       y0-=symbol->TopOffset();
       x0+=symbol->LeftOffset();
  //      getviewsettings(&vp); - not necessary
       ncols=symbol->CharacterWidth();
       bytesperrow=(ncols+7) >>3;
       nrows=symbol->CharacterHeight();
	y1=y0+nrows-1;
	x1=x0+ncols-1;
	if(x0<0 || y0 <0) return;
	if(x0+ncols>getmaxx() || y0+nrows >getmaxy())return;

	for (y=y0,by=0;y<=y1;y++)
	 {

	  for (x=x0,i=1;i<=bytesperrow;i++)
	    {
	       B=symbol->BitMap[by];
	       for(bi=0;bi<=7 && x<=x1;bi++,x++)
		  {
		      asm shl B,1
		      asm jc black
		      asm jmp white
		     black:
		       putpixel(x,y,color);
		       continue;
		     white:
		     if(! transparent)
		       putpixel(x,y,bkcolor);

		  }
		by++;
	    }
	 }

    moverel(symbol->DeltaX()>>2,  0);

   }




   void drawstr(const ljfont& font,char * s,int transparent)
     {
       while(*s) drawchar(font,*s++,transparent);

     }









#ifndef __MIN_AND_MAX_H

 inline int min(int x,int y)
  {
   return x<y ? x :y;

}
#endif
/*



  㭪  ᨬ ୮  , 㬥襭  楫 ᫮ ࠧ
 ਧ⠫/⨪.

  窠 㬥襭 ᨬ ᮮ⢥ xscale * yscale 窠
室 . ࠬ threshold । ᪮쪮 "" 祪
   室 ⪥, ⮡  ࠦ ⠫ "".

 ⨬쭮 祭 ⮣ ࠬ,  ࠢ = xscale * yscale /2


ਬ

       xscale   yscale Ŀ
                                          
                                          
    <>.    .    .     .     .  nd .    
    .............................. ns      
   .Ѹ˸ѸѸ     
   .Ŵ״ŴŴ      
   .Ŵ״ŴŴ   
   .Ŵ״ŴŴ   
.  .صεصص  
   .Ŵ״ŴŴ
   .Ŵ״ŴŴ
   .Ŵ״ŴŴ
.  .صεصص
  ms


.
md


  Vertical scale 4:1, horizontal 5:1, original image size 28 x 9,
  scaled image size would be 6 x 3





*/

 void drawscaledchar(const ljfont& font,uchar c,int xscale,int yscale,int threshold,int write_mode, int dir)
   {  int x,y,x0,y0; ljchardsc far * symbol;
      int bw,bwd,ms,ns,md;  int color;
      int j,bi,by,byj;char B[MAXSCALE]; int DeltaX;int  is,jd,doti;
      // is - 稪 ⮢  室 ⮢ ࠧ (ਧ.)
      // bi - ६ 稪 ⮢  
      // doti  - ६ 稪 ⮢  ਧ⠫쭮 ஥樨 窨
      // jd - ⨪ 稪 ப, 뤠  ࠭

      int bitmapsize; int dotheight;  int sum;
		      /*last dots are not necessary xscale x yscale*/
       _SI=0;
       symbol=font [c];
       if (symbol==0) return;
       if (xscale <=0 || yscale <= 0 || yscale >MAXSCALE) return;
       color=getcolor();
       x0=getx(dir); y0=gety(dir);
       y0-=symbol->TopOffset()/yscale;
       x0+=symbol->LeftOffset()/xscale;
       ns=symbol->CharacterWidth(); // number of cols
       bw=(ns+7) >>3;               // bytes per row
       bwd=bw*(yscale-1)+1;
					  // delta for the next dest row
       ms=symbol->CharacterHeight();// # of rows
       bitmapsize= bw*ms;

//       nd= (ns+xscale-1) /xscale;   // # of dest cols
       md= (ms+yscale-1) /yscale;   // # of dest rows
//	y1=y0+md-1;
//	x1=x0+nd-1;
//	if(x0<0 || y0 <0) return;
//	if(x1>getmaxx(dir) || y1>getmaxy(dir))return;
	DeltaX= symbol->scaleDX(xscale);         //


	x=x0;y=y0;
	by=0; //current  byte in bitmap array




for ( jd=0;jd<md;jd++,y++)
{
	is=0;
	sum=0; doti=min(xscale,ns-is);

next_byte:
	for (byj=by,j=0;j<yscale && byj<bitmapsize;byj+=bw,j++)
	     B[j]=symbol->BitMap[byj]; dotheight=j; bi=8;


	   // load B[]


      /* count the sum of bits in one column */
next_col:
	     asm {
		   mov cx,dotheight
		   jcxz counted
		   mov ax,sum
		   lea si,B[0]
		 }
do_count:
	    asm{

		   shl byte ptr ss:[si],1
		   adc ax,0
		   inc si
		   loop  do_count
		   mov sum,ax
		 }

counted:   is++;bi--;doti--;

       if(!doti) {  // dot is exhausted

	       if (sum >= threshold)
		  putpixel(x,y,color,write_mode,dir);
	       sum=0; doti=min(xscale,ns-is);
	       x++;


	       }


       if ( is==ns )  { by+=bwd; x=x0; continue;}
       if (!bi) {by++; goto next_byte;} // byte is exhausted
       else  goto next_col;
}



      moverel(DeltaX,0,dir);
}



rect ljfont::textsize( const char * s) const
  { int h=0,d=0,w=0; ljchardsc far * chard;
    int up,down;
    while(*s)
    {
     chard =(*this) [*s++];
     if (chard)
	 {   up= chard-> TopOffset();
	     down= chard->CharacterHeight()-up-1;
	      h=max(h,up);
	      d=max(d,down);
	      w+=chard->DeltaX() >> 2;
	  }
    }
   return rect(0,-h, w-1,d);
  }


rect ljfont::scaledtextsize(const char * s,int xscale,int yscale) const
  {
     int h=0,d=0,w=0; ljchardsc far * chard;
     int up,down;
	 while(*s)
	   {
	    chard =(*this) [*s++];
	    if (chard)
		{   up= chard-> TopOffset() /yscale;
		    down= (chard->CharacterHeight()+yscale-1)/yscale - up-1;
		     h=max(h,up);
		     d=max(d,down);
		     w+=chard->scaleDX(xscale);
		 }
	   }

	return rect(0,-h, w-1,d);
  }

 void drawscaledstr (const ljfont& font,uchar * s,int xscale,int yscale,int write_mode, int dir)

  {  int threshold= xscale* yscale /2;
     if(threshold<1) threshold=1;

     while(*s)
      drawscaledchar(font,*s++,xscale,yscale,threshold,write_mode,dir);

 }

