#ifndef __GRAPHPP
#ifndef __GRAPHICS_H
#include <graphics.h>
#endif
#ifndef __GEOM
#include "geom.h"
#endif
#define __GRAPHPP

/*struct palettetype {
    unsigned char size;
    signed char colors[MAXCOLORS+1];
};

struct linesettingstype {
    int linestyle;
    unsigned upattern;
    int thickness;
};  */

/***************** OOP - versions of graphics.h structures : ************/

struct Linesettingstype :linesettingstype {
       Linesettingstype(int style=SOLID_LINE, int width=NORM_WIDTH)
	  {linestyle=style;thickness= width;upattern=0;}
       Linesettingstype(const linesettingstype& l) : linesettingstype(l)
	  { }


};
/*

struct textsettingstype {
    int font;
    int direction;
    int charsize;
    int horiz;
    int vert;
};
*/
struct Textsettingstype: textsettingstype{
     Textsettingstype(int Font,int Size=1,int Direction = HORIZ_DIR,
					  int Horiz=-1,int Vert=-1)
    {
       if(Horiz <0 || Vert <0) gettextsettings(this) ;
       if(Horiz >=0) horiz=Horiz;
       if(Vert >=0) vert=Vert;
       font=Font; charsize=Size; direction=Direction;
   }
    Textsettingstype(const textsettingstype& tset) : textsettingstype(tset)
     {}
};


/*
struct fillsettingstype {
    int pattern;
    int color;
};

struct pointtype {
    int x, y;
};
 */

/*
struct viewporttype {
    int left, top, right, bottom;
    int clip;
};
*/

 struct Viewporttype: viewporttype {
	Viewporttype(int Left,int Top)
	    {
	    left=Left;top=Top;
	    right=getmaxx();
	    bottom=getmaxy();
	    clip=0;
	     }
	Viewporttype(int Left,int Top,int Right,int Bottom,int Clip=0)
	  {left=Left;top=Top;right=Right; bottom=Bottom; clip=Clip;}
	Viewporttype(const rect& r,int Clip=0)
	 {left=r.left();top=r.top();right=r.right();bottom=r.bottom();
	  clip=Clip; }
	Viewporttype(const viewporttype& vp) : viewporttype(vp)
	  { }
	operator rect() {return rect(left,top,right,bottom);}
};

/*
struct arccoordstype {
    int x, y;
    int xstart, ystart, xend, yend;
};

  */

/**************** Overloaded functions from graphics.h : ************/

inline linesettingstype getlinesettings()
  {linesettingstype lset;getlinesettings(&lset); return lset; }

inline void setlinestyle(Linesettingstype lset)
  { setlinestyle(lset.linestyle,lset.upattern,lset.thickness); }


inline void settextstyle(const Textsettingstype& tset)
   {
	 settextstyle(tset.font,tset.direction,tset.charsize);
     }

inline textsettingstype gettextsettings()
    {  textsettingstype tset;
	gettextsettings(&tset); return tset;
    }

inline void rectangle(const rect& r)
  {rectangle(r.left(),r.top(),r.right(),r.bottom()); }

inline void bar(const rect& r)
  {bar(r.left(),r.top(),r.right(),r.bottom()); }

inline void bar3d(const rect& r,int depth=0,int topflag=0)
  {bar3d(r.left(),r.top(),r.right(),r.bottom(),depth,topflag); }

inline unsigned imagesize(const rect& box)
  {return imagesize(box.left(),box.top(),box.right(),box.bottom()); }

inline void getimage(const rect& box,void far * bitmap)
  { getimage(box.left(),box.top(),box.right(),box.bottom(),bitmap); }

inline void putimage(loc where,void far * bitmap,int op=COPY_PUT)
  { putimage(where.X,where.Y,bitmap,op); }

inline void moveto(loc where)
 { moveto(where.X,where.Y);}
inline void moverel(loc by)
 { moverel(by.X,by.Y);}

inline void  line( loc from,loc to)
  { line(from.X,from.Y,to.X,to.Y);}
inline void  linerel(loc by)
   {linerel(by.X,by.Y);}
inline void  lineto(loc to)
   {lineto(to.X,to.Y);}

inline void putpixel(loc at,int color)
  {putpixel(at.X,at.Y,color);}

inline int getpixel(loc at)
  {return getpixel(at.X,at.Y);}

inline void setviewport(const Viewporttype& vp)
	 {setviewport(vp.left,vp.top,vp.right,vp.bottom,vp.clip); }
inline void setviewport(const rect& vpr,int clip)
	 {setviewport(vpr.left(),vpr.top(),vpr.right(),vpr.bottom(),clip); }

inline viewporttype getviewsettings()
     { viewporttype vp; getviewsettings(&vp); return vp;}

/*************  Functions with new names: **********************/

 inline loc getCP()
  {return loc(getx(),gety());}

 inline loc screensize()
  {return loc(getmaxx(),getmaxy());}

 inline void outtextat(loc at,char far * textstring)
  {outtextxy(at.X,at.Y,textstring);}

 inline loc textdimensions(char far * textstring)
  {return loc(textwidth(textstring),textheight(textstring));}

inline void restoretextsettings(const Textsettingstype& tset)
   {
	 settextstyle(tset.font,tset.direction,tset.charsize);
	 settextjustify(tset.horiz,tset.vert);
    }


#endif

