#include "blk_ask.h"

BlockAsk::BlockAsk(rect coordinates,              // Screen cells
	       char* tabName,                     // Table name
	       KH_STRTABLE* fields,               // Field names
	       char* fName,                       // File for swapping
	       BORDERS b_type,                    // Border type
	       int res,                           // Resize status
	       int elem_pat)                      // Buttons
	: Block(coordinates, fName, "", 0, res, b_type, NO_BORDER,
		0, 0, elem_pat)
    {
    table = new Ask(rect(coordinates.origin.X, coordinates.origin.Y,
	     coordinates.corner.X, coordinates.corner.Y - 1),
	     tabName, fields, "", 0, b_type, NO_BORDER, FIXED, 0);

    table->set_ret(1);
    insert(table, 1);

    delete remove(get(pg_up_element));
    delete remove(get(pg_dn_element));
    delete remove(get(up_element));
    delete remove(get(dn_element));

    int xw = 2 * pScreenSet->cell_width;
    int xl = screenXL(coordinates.origin.X);
    int xr = screenXR(coordinates.origin.X) + xw;
    int yt = screenYT(coordinates.corner.Y) - pScreenSet->cell_height;
    int yb = screenYB(coordinates.corner.Y);

    home_element = new Element(rect(xl + 2 * xw, yt, xr + 2 * xw, yb),
			 HOME_ELEMENT, BUTTON_BORDER, elem_pat, 1);
    end_element = new Element(rect(xl + 3 * xw, yt, xr + 3 * xw, yb),
			 END_ELEMENT, BUTTON_BORDER, elem_pat, 1);
    ok_element = new Element(rect(xl + 4 * xw, yt, xr + 4 * xw, yb),
			 OK_ELEMENT, BUTTON_BORDER, elem_pat, 1);

    add(ok_element);
    add(home_element);
    add(end_element);

    assign(table, left_element, AC_LEFT);
    assign(table, right_element, AC_RIGHT);
    assign(table, cancel_element, AC_CANCEL);
    assign(table, home_element, AC_HOME);
    assign(table, end_element, AC_END);
    assign(table, ok_element, AC_OK);

    left_element->repose(rect(xl, yt, xr, yb));
    right_element->repose(rect(xl + xw, yt, xr + xw, yb));
    move_element->repose(rect(xl + 6 * xw, yt, xr + 6 * xw, yb));
    resize_element->repose(rect(xl + 7 * xw, yt, xr + 7 * xw, yb));
    cancel_element->repose(rect(xl + 5 * xw, yt, xr + 5 * xw, yb));
    }
/////////////////////////////////
void BlockAsk::rearrange()
    {
    rect sz = textRect(w1->bound());
    if(sz.width() < 32)
	sz.corner.X = sz.origin.X + 20;
    if(sz.height() < 6)
	sz.corner.Y = sz.origin.Y + 6;
    w1->repose(sz);
    Block::rearrange();
    rect r;
    rect coord = textRect(r = w1->bound());

    int xw = 2 * pScreenSet->cell_width;
    int xl = screenXL(r.origin.X);
    int xr = screenXR(r.origin.X) + xw;
    int yt = screenYT(r.corner.Y) - pScreenSet->cell_height;
    int yb = screenYB(r.corner.Y);

    left_element->repose(rect(xl, yt, xr, yb));
    right_element->repose(rect(xl + xw, yt, xr + xw, yb));
    home_element->repose(rect(xl + 2 * xw, yt, xr + 2 * xw, yb));
    end_element->repose(rect(xl + 3 * xw, yt, xr + 3 * xw, yb));
    move_element->repose(rect(xl + 6 * xw, yt, xr + 6 * xw, yb));
    resize_element->repose(rect(xl + 7 * xw, yt, xr + 7 * xw, yb));
    cancel_element->repose(rect(xl + 5 * xw, yt, xr + 5 * xw, yb));
    ok_element->repose(rect(xl + 4 * xw, yt, xr + 4 * xw, yb));

    table->repose(rect(coord.origin.X + 1 + textX(w1->get_shadow()),
		      coord.origin.Y + textY(w1->get_shadow()),
		      coord.corner.X - 1 - textX(w1->get_shadow()),
		      coord.corner.Y - 2 - textY(w1->get_shadow())));
    }
/////////////////////////
void BlockAsk::hide()
    {
    table->hide();
    w1->hide();
    }
//////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
	return;

    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    char* s[] = { "One", "Two", "Three", "Four", "Five" };
    KH_STRTABLE* fields = new KH_STRTABLE(5, s);

    BlockAsk w(rect(10, 10, 60, 15), "demo.db", fields, "window.pcy",
	SHOW_BORDER, MOVE | RESIZE, 19);

    w.show_window();
    w.exe();
    w.hide();

    close_KNOW_HOW();
    closegraph();
    }
*/