/***********************************************************************

                                      CSDB Library, Version 1.6.b 
                                         Released: March 2nd 1995 

       BASE class from which many database classes are
       derived.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSBASE_H
#define __CSBASE_H

#include "stdio.h"

#ifndef __CSTOOLS_H
#include "cstools.h"
#endif

#ifndef __CSEDSTR_H
#include "csedstr.h"
#endif


#define CS_CLID_VRAM		1
#define CS_CLID_BTREE		2
#define CS_CLID_VBASE		3
#define CS_CLID_VBAXE		4
#define CS_CLID_OLAY		5
#define CS_CLID_DLAY		6
#define CS_CLID_OLAYd		CS_CLID_DLAY
#define CS_CLID_TBASE		7
#define CS_CLID_RBASE		8
#define CS_CLID_PAGE	       11
#define CS_CLID_BTREEb	       12
#define CS_CLID_BTREEi	       13
#define CS_CLID_BTREEc	       14
#define CS_CLID_BTREEl	       15
#define CS_CLID_BTREEf	       16
#define CS_CLID_BTREEd	       17
#define CS_CLID_BTREEa	       18
#define CS_CLID_VBASEi	       19
#define CS_CLID_VBASEd	       20


int cs_db_type(CSCHAR *name,U32 &fi_ID, U16 &cl_ID);
U32 cs_fi_type(CSCHAR *name);
U16 cs_cl_type(CSCHAR *name);



class VBAXE;


/**************************************************************************/
class BASE
{

friend VBAXE;

protected:

   typedef struct
   {
     U32  CSLIB;
     U32  ID;		       // ID of file layout.
     S16  class_id;	       // Class name identifier.
     U32  version;	       // Version of the class.
     S16  locked;	       // Database file locked.
     S8   date[14];	       // Date of compilation.
     S8   time[10];	       // Time of compilation.
     S16  compiler;	       // Compiler name.
     S32  creat_d;	       // Date of creation
     S32  creat_t;	       // Time of creation
     S32  updat_d;	       // Date of last update
     S32  updat_t;	       // Time of last update
     S32  user_data;	       // Amount of user-data appended.
     U16  headpagesize;        // Size of header page.
     U32  numpage;	       // PAGE number of pages.
     U32  pc_empty;	       // PAGE first empty page
     U32  pn_empty;	       // PAGE number of empty pages.
     U16  page_foot;	       // PAGE size of page-footer.
     U16  lenpage;	       // PAGE size of page.
     U32  numrec;	       // TBASE number of records
     U16  rec_foot;	       // TBASE size of record-footer.
     U16  lenrec;	       // TBASE size of record.
     U16  recpage;	       // TBASE number of records on a page.
     union
     {
       struct
       {
	  U16  vb_maxlen;      // VBASE naximum record length.
	  U32  vb_numrec;      // VBASE number of records.
	  U32  vb_nip;	       // VBASE number of index pages.
	  U32  vb_edc_page;    // VBASE page number of empty data chains.
	  S16  vb_rel_shrink;  // VBASE relocate record when shrunk?
       } VBASE;
       struct
       {
	  U32  avl_emp_pag;    // AVLd first empty page.
	  U32  avl_emp_off;    // AVLd first empty offset.
	  U16  avl_emp_amo;    // AVLd first empty amount.
	  U16  avl_emp_las;    // AVLd empty last in chain.
	  U32  avl_anc_pag;    // AVLd anchor page.
	  U32  avl_anc_off;    // AVLd anchor offset.
	  U32  ola_page;       // OLAY last page.
	  U32  ola_nr_empty;   // OLAY number of empty pages.
	  S32  ola_pos;        // OLAY pos of last byte.
	  S32  ola_empty;      // OLAY chain of empty ola-pages.
	  S32  ola_first_page; // OLAY first page-number.
       } OLAY;
       struct
       {
	  U16  btr_datalen;    // BTREE data length
	  U16  btr_keylen;     // BTREE key length
	  S32  btr_empty;      // BTREE empty block chain
	  U16  btr_imnk;       // BTREE index degree
	  U16  btr_dmnk;       // BTREE data degree
	  S32  btr_nrkey;      // BTREE number of keys
	  S32  btr_root;       // BTREE root node
	  U16  btr_levels;     // BTREE number of layers
	  U16  btr_mulkey;     // BTREE multiple keys allowed
	  U32  btr_mk_emp;     // BTREE multiple keys empty data chain.
       } BTREE;
       struct
       {
	  U16  vr_maxlen;      // VRAM maximum length of allocation.
	  U32  vr_number;      // VRAM number of allocations.
	  U32  vr_nedc;        // VRAM number of empty data chains.
	  U32  vr_edc_page;    // VRAM page Number of empty data chains.
	  U32  vr_root;        // VRAM root VPOI.
	  S16  vr_relocate;    // VRAM relocate when possible.
       } VRAM;
     } cl;
   } db_header;


   db_header *head;

   U16 is_open;
   U32 numpage;
   U16 lenpage;
   U16 page_foot;
   STR db_name;

protected:

   void set_page_size(U16 t);
   void init_vars(void);
   void init_defaults(void);

public:

   CSCHAR *e_name(void) 	  { return (CSCHAR *)db_name; }
   void name(CSCHAR *s) 	  { db_name=s; }
   void define(void);
   void save(int updated);
   void close(int updated)	  { save(updated); }

   int	set_open(int FT)	  { return is_open=FT; }

public:
   BASE(void);
   ~BASE(void);

//////////////////////// Definition //////////////////////////////////////////
   void page_size(U16 t)	  { set_page_size(t); }
   U16	page_size(void) 	  { return lenpage;   }
   U16	foot_size(void) 	  { return page_foot; }
   void foot_size(int size)	  { page_foot=size;   }

//////////////////////// Number of Pages /////////////////////////////////////
   long num_page(void)		  { return numpage; }
   void set_num_page(long n)	  { numpage=n; }


////////////////////////// Miscellaneous ///////////////////////////////////////
   U16	page_free(void) 	  { return page_size()-foot_size(); }
   void empty(void);
   void zap(void);
   int	already_open(void)	  { return is_open; }
   virtual int class_ID(void)=0;


// Made public to support the program generator.
   long sj_updated(void)	  { return head->updat_d; }
   long sj_created(void)	  { return head->creat_d; }


};


#endif
