/***********************************************************************

                                      CSDB Library, Version 1.6.b 
                                         Released: March 2nd 1995 

       Header file of the VBAXE class.
       Just like the VBASE class but for very large
       databases.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSVBAXE_H
#define __CSVBAXE_H

#include "cstypes.h"
#include "cstbase.h"
#include "csvram.h"

////////////////////////////////////////////////////////////////////////

class VBASEi:public TBASE
{
   virtual int class_ID(void)  { return CS_CLID_VBASEi; }
};

////////////////////////////////////////////////////////////////////////

class VBASEd:public VRAM
{
   virtual int class_ID(void)  { return CS_CLID_VBASEd; }
};


////////////////////////////////////////////////////////////////////////



class VBAXE
{

    typedef struct
    {
      VPOI p;
      U16 len;
    }vbi;

    VBASEi  in;
    VBASEd  da;



////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////
 public:


//////////////////////// Definition//////////////////////////////////////////
   int	define(CSCHAR *name,U16 struclen);
   int	relocate_when_shrunk(void)    { return da.relocate_when_shrunk();}
   void relocate_when_shrunk(int ToF) { da.relocate_when_shrunk(ToF);	 }

//////////////////////// Open & Close////////////////////////////////////////
   int	open(CSCHAR *name,S16 kb_buf);
   int	close(void);
   int	save(void);

//////////////////////// Read & Writes records///////////////////////////////
   void read_rec(U32 pos,void *ptr,U16	&length);
   void read_rec(U32 pos,U16  maxlen,void *ptr,U16  &length);
   void write_rec(U32 i,void *d,U16 len);

//////////////////////// Add Records/////////////////////////////////////////
   U32	append_rec(void *p,U16 len);

//////////////////////// Number of Records///////////////////////////////////
   U32	numvrec(void)	     { return in.numrec(); }

//////////////////////// Data in Header Page/////////////////////////////////
   int	data_2_header(void * ptr,U16 length)
	{ return in.data_2_header(ptr,length); }
   int	header_2_data(void * ptr,U16 length)
	{ return in.header_2_data(ptr,length); }
   U16	max_data_in_header(void)
	{ return in.max_data_in_header(); }

////////////////////////// Deleting////////////////////////////////////////////
   int	is_delet(U32 k)      { return in.is_delet(k); }
   void delet(U32 k)	     { in.delet(k);	}
   void undelet(U32 k )      { in.undelet(k);	}

////////////////////////// Record Length///////////////////////////////////////
   U16	rec_len(U32 k)	     { return ((vbi *)in.locate_rec(k))->len; }
   U16	max_len(void)	     { return da.max_len(); }

//////////////////////// Report Writing//////////////////////////////////////
   U16	report(CSCHAR *name,S16 sub=1);
   void report(FILE *fipo,S16 sub);

////////////////////////// Miscellaneous///////////////////////////////////////

   int	background(void);
   int	pack(void);
   int	zap(void)	       { return (da.zap() && in.zap()); }
   int	empty(void)	       { return (da.empty() && in.empty()); }
   int	already_open(void)     { return in.already_open(); }
   void info(void);

   virtual int class_ID(void)  { return CS_CLID_VBAXE; }
   void  echo_IO(int TF)       { in.echo_IO(TF); da.echo_IO(TF); }


};

#endif
