(*---------------------------------------------------------------------------*)
(*LDRepl.pas Ⓚ               (C) OؘaF NIFTY SDR SDI00147 1989/7/1 *)
(*$B-,F-,I-,N-                                                               *)
(*---------------------------------------------------------------------------*)
UNIT LDRepl;


INTERFACE


USES
   Dos,
   MyType,
   MyTool,
   LDVari,
   LDProc;


PROCEDURE ReplaceJob;


IMPLEMENTATION


{$L LDE16 }
FUNCTION EnCode16(inf,ouf:WORD;dsize,size:LONGINT):BOOLEAN;EXTERNAL;
{$L LDE18 }
FUNCTION EnCode18(inf,ouf:WORD;dsize,size:LONGINT):BOOLEAN;EXTERNAL;


VAR
  lh1size,lh2size,lh3size : WORD;


PROCEDURE MakHdr;
VAR
   i : WORD;
   d : DirStr;
   n : NameStr;
   e : ExtStr;
   s : STRING;
BEGIN
   WITH lh1,lh2,lh3,LzdFN  DO BEGIN
      FSplit(OldFName,d,n,e);
      s:=n+e;
      FSplit(NewFName,d,n,e);
      LSize  :=NewSize;
      LFSize :=NewFSize;
      LTime  :=NewTime;
      LAttr  :=NewAttr;
      LFName :=n+e;
      LHdrID :='-L';
      LHdrSID:='D6-';
      Lh1Size:=SizeOf(LHdr)-255+Length(LFName);
      Lh2Size:=SizeOf(L2Hdr)-255+Length(s)+2;
      Lh3Size:=SizeOf(L3Hdr);
      LNum   :=Lh1Size+Lh2Size-2;
      LCRC   :=CRC;
      LOldCrc:=OldCRC;
      LOldFSize:=OldFSize;
      LOldName:=s;
      LCTYPE:='N';
      LEI:=EI;
      LEJ:=EJ;
      LOSType:='M';
      LCSum:=0;
      buf2[Lh2Size-2]:=3;
      buf2[Lh2Size-1]:=0;
      FOR i:=2 TO Lh1Size-1 DO Inc(LCSum,buf1[i]);
      FOR i:=0 TO Lh2Size-1 DO Inc(LCSum,buf2[i]);
      IF MaxLTime<LTime THEN MaxLTime:=LTime;
   END;
END;


PROCEDURE ReplaceJob;
VAR
   s6 : STR6;
   fs : LONGINT;
CONST
   EndOfLzs : BYTE = 0;
BEGIN
   MaxLTime:=0;
   WITH LzdFN DO BEGIN
      IF FExist(LzdFName)<>0 THEN BEGIN
	 IF NOT YesNo(LzdFName+' '+MEG(OverWriteMsg)) THEN Halt(1);END;
      ReadDic(fs);
      OldFSize:=fs;
      OldCrc  :=CRC;
      IF NOT BlkOpen(NewFVar,'I',NewFName) THEN Error(NewFName,CantOpenErMsg);
      IF NOT BlkOpen(WrkFVar,'O',TName1) THEN Error(LzdFName,CantCreateErMsg);
      NewFSize:=BlkFileSize(NewFVar);
      GetBTime(NewFVar,NewTime);
      GetBAttr(NewFVar,NewAttr);
      WriteLn(OUTF,MEG(CreatingMsg)+' '+LzdFName+' '+MEG(FromMsg)+' '+
		   NewFName+' '+MEG(WithMsg)+' '+OldFName);
      IF (OldFSize<$10000) AND (NewFSize<$10000) THEN BEGIN
         EI:=16;EJ:=16;END
      ELSE BEGIN
         EI:=18;EJ:=14;END;
      CRC:=0;
      IF EI=16 THEN BEGIN
         IF NOT EnCode16(NewFVar.Handle,WrkFVar.Handle,OldFSize,NewFSize) THEN
	    Error('',EncodeErMsg);END
      ELSE BEGIN
         IF NOT EnCode18(NewFVar.Handle,WrkFVar.Handle,OldFSize,NewFSize) THEN
	    Error('',EncodeErMsg);END;
      BlkClose(NewFVar);
      NewSize:=BlkFileSize(WrkFVar);
      Str((NewSize/NewFSize)*100:6:2,s6);
      WriteLn('  '+MEG(RatioMsg)+'('+s6+'%)');
      MakHdr;
      IF NOT BlkOpen(LzdFVar,'O',LzdFName) THEN Error(LzdFName,CantOpenErMsg);
      BlkSeek(WrkFVar,0);
      BlkWrite(LzdFVar,lh1,Lh1Size);
      BlkWrite(LzdFVar,lh2,Lh2Size);
      BlkWrite(LzdFVar,lh3,Lh3Size);
      BlkCopy(WrkFVar,LzdFVar,NewSize);
      BlkClose(WrkFVar);
      BlkErase(WrkFVar);
      BlkWrite(LzdFVar,EndOfLzs,1);
      SetBTime(LzdFVar,MaxLTime);
      BlkClose(LzdFVar);
   END;
END;


END.
