* ͻ
*  Program.: UDFS                                                    
*                                                                    
*  Author..: Phil Steele - President Phillipps Computer Systems Inc. 
*                                                                    
*  Address.: 52 Hook Mountain Road,  Montville NJ 07045              
*                                                                    
*  Phone...: (201) 575-8575                                          
*                                                                    
*  Date....: 03/22/88                                                
*                                                                    
*  Notice..: Copyright 1988  Philip Steele, All Rights Reserved      
*                                                                    
*  Version.: CLIPPER AUTUMN 1986 and CLIPPER SUMMER 1987             
*                                                                    
*  Notes...: A Collection of User Defined Functions                  
*                                                                    
*                                                                    
*     These functions are from the book: 64 Clipper User Defined     
*                                                                    
*     Functions - TAB Books  written by Phil Steele.                 
*                                                                    
*     This collection normally sells for $49.95 or about $0.75 per   
*                                                                    
*     function.                                                      
*                                                                    
*                                                                    
*     I am making these UDFs available to you on a shareware basis.  
*                                                                    
*                                                                    
*     If you find any of these functions useful and wish to change   
*                                                                    
*     them or incorporate tham as-is into your code - feel free to   
*                                                                    
*     do so.  Please give me (Phil Steele) credit somewhere in your  
*                                                                    
*     code.                                                          
*                                                                    
*                                                                    
*     Remember these functions are NOT free - however only pay for   
*                                                                    
*     those that you use.  If you only like and use ONE function     
*                                                                    
*     send me $0.75,  if you like and use two of the 64 functions    
*                                                                    
*     send $1.50, I feel that this is a very fair method of payment. 
*                                                                    
*                                                                    
*     For amounts of $5.00 or more I accept Master card or Visa.     
*                                                                    
*                                                                    
*     If you wish an explanation of how or why the UDFs work as      
*                                                                    
*     they do you can purchase the book.  If you can't find the      
*                                                                    
*     book you can order it directly from either TAB books or me.    
*                                                                    
*                                                                    
*     Enjoy these UDFs and good luck.                                
*                                                 Phil Steele        
*                                                                    
* ͼ
*
*  Calling code:
*  SAMPLE1
*  ...
   CLEAR
   STORE DATE() TO Birthday, StartDay
   NDays = 7671  && 21 Years
   @ 10,12 GET Birthday
   @ 12,12 GET StartDay VALID DifDate(StartDay, BirthDay, NDays)
   READ
*  ...

FUNCTION DIFDATE
*ͻ
* Program...: DIFDATE                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function insures that DATE1 is    
*             X days greater than DATE2              
* Parameters: DATE1, DATE2 - Dates to be compared    
*             NUMOFDAYS    - The number of days      
*                            DATE1 must be greater   
*                            than DATE2 for a .T.    
*                            result.                 
*ͼ
PARAMETERS Date1, Date2, NumOfDays
PRIVATE    Date1, Date2, NumOfDays
IF Date1 >= Date2 + NumOfDays
   RETURN(.T.)
ELSE
   RETURN(.F.)
ENDIF
*END:DIFDATE
************************************************************************
*  Calling code:
*  SAMPLE2
*  ...
   Job = "     "
   ValidJobs = "DRV,HLP,LDR,GUARD,SPVSR,MNGR"
   @ 10,12 GET Job VALID MatchStr(Job, ValidJobs)
   READ
*  ...

FUNCTION MATCHSTR
*ͻ
* Program...: MATCHSTR                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function insures that VAR1 is     
*             contained in STR1                      
* Parameters: VAR1 - The variable to be compared     
*             STR1 - A group of string variables     
*                    separated by ","                
*ͼ
PARAMETERS Var1, Str1
PRIVATE    Var1, Str1
Str1 = Str1 + ",,"
DO WHILE .T.
   Comma = AT(",", Str1)
   IF Comma = 0 .OR. LEN(Str1) < 2
      RETURN(.F.)
   ENDIF
   SStr = SUBSTR(Str1, 1, Comma - 1)
   Str1 = SUBSTR(Str1, Comma + 1)
   IF Var1 = SStr
      RETURN(.T.)
   ENDIF
ENDDO
*END:MATCHSTR
************************************************************************
*  Calling code:
*  SAMPLE3
*  ...
*  GET ...
*  GET ...
   BDate = DATE()
   @ 10,12 GET BDate VALID BirthAge(BDate, 10, 3)
*  GET ...
*  GET ...
   READ
*  ...

FUNCTION BIRTHAGE
*ͻ
* Program...: BIRTHAGE                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function checks for a valid date  
*             and displays the elapsed years.        
* Parameters: BDATE - The date checked for validity, 
*             and used to compute elapsed years.     
*             X and Y - The coordinated used to      
*             display the elapsed years.             
*ͼ
PARAMETERS BDate, X, Y
PRIVATE    BDate, X, Y
IF MONTH(BDate) < 1
   RETURN(.T.)
ENDIF
EYears = (DATE() - BDate) / 365.25
@ X,Y SAY STR(EYears,2,0)
RETURN(.T.)
*END:BIRTHAGE
************************************************************************
*  Calling code:
*  SAMPLE4
*  ...
   CLEAR
   STORE 0 TO Number, Total
   DO WHILE Number > -1
      @ 12,12 GET Number VALID NumSum(Number,22,10)
      READ
   ENDDO
*  ...

FUNCTION NUMSUM
*ͻ
* Program...: NUMSUM                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes a sum of numbers
*             and displays the total while the data  
*             is being entered.                      
* Parameters: Number - Entered number.               
*             X and Y - The coordinates for the      
*             computed total.                        
* Note......: Total must be defined in the calling   
*             procedure.                             
*ͼ
PARAMETERS Number, X, Y
PRIVATE    Number, X, Y
Total = Number + Total
@ X,Y SAY Total PICTURE "99,999.99"
RETURN(.T.)
************************************************************************
*  Calling code:
*  SAMPLE2
*  ...
   N = 1
   USE EMPLOYEE
   INDEX ON NoZero(Ord) TO TEMPORD
   DO WHILE .NOT. EOF()
      @ N, 1 SAY EmpName
      @ N,31 SAY EmpAddress
      SKIP
      IF N = 23
         WAIT
         CLEAR
         N = 1
      ENDIF
   ENDDO
*  ...

FUNCTION NOZERO
*ͻ
* Program...: NOZERO                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function indexes a database in    
*             ascending order based on the numeric   
*             field Zip. However a zero value will   
*             come after 99999 in the index.         
* Parameters: Zip - A five position numeric field in 
*             the database.                          
*ͼ
PARAMETERS Zip
IF Zip = 0
   RETURN(99999)
ELSE
   RETURN(Zip)
ENDIF
*END:NOZERO
************************************************************************
* Calling code:
* SAMPLE2
* ...
  SET COLOR TO W+/B,R+/B,B,B
  CLEAR
  @ 12,38 SAY "I N D E X I N G"
  @ 18,10 TO 23,69 DOUBLE
  @ 21,11 TO 21,68 DOUBLE
  @ 21,10 SAY ""
  @ 21,69 SAY ""
  @ 19,24 SAY "P E R C E N T   C O M P L E T E"
  @ 20,14 SAY "0    10   20   30   40   50"
  @ 20,44 SAY "60   70   80   90   100"
  USE TEST
  PUBLIC Tot
  Tot = RECCOUNT()
  SET COLOR TO R+/B,W+/B,B,B
  INDEX ON Bar(AA1+AA2+AA3) TO TEMP1
* ...

FUNCTION BAR
*ͻ
* Program...: BAR                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function displays a bar graph     
*             depicting the progress of an index     
*             operation.                             
* Parameters: IFIELD - The field(s) to index on.     
*                                                    
* Note1: The function "BAR" must be present every    
*        time you use the index - even if you are    
*        not reindexing the file.                    
*                                                    
* Note2: The index is increased in size due to the   
*        UDF BAR - take note.                        
*ͼ
PARAMETERS IField
PRIVATE    IField
Pct = IIF(RECNO()<Tot+1, RECNO()*100/Tot, 100)
@ 22,14 SAY REPLICATE("",(Pct/2)+1)     && CHR(219)
RETURN(IField)
*END:BAR
************************************************************************
*  Calling code:
*  SAMPLE2
*  ...
   @ 12,38 SAY "I N D E X I N G"
   USE TEST
   INDEX ON Inverse(Empname) TO TEMP1
*  ...

FUNCTION INVERSE
*ͻ
* Program...: INVERSE                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function generates an inverse     
*             alphabetic index.                      
* Parameters: INFIELD - The field(s) to index on.    
*ͼ
PARAMETERS InField
PRIVATE InField, NLoop
NewString = " "
FOR NLoop = 1 TO 30
   NewChar = UPPER(SUBSTR(InField,NLoop,1))
   Num = ASC(NewChar) - 78
   Num = IIF(Num>=0, Num+1, Num)
   Num = 77 - Num
   Num = IIF(Num<=78, Num+1, Num)
   NewString = NewString + CHR(Num)
NEXT
NewString = LTRIM(NewString) +;
            SPACE(LEN(InField) - LEN(LTRIM(NewString)))
RETURN(NewString)
*END:INVERSE
************************************************************************
*  Calling code:
*  SAMPLE2
*  ...
   @ 12,38 SAY "I N D E X I N G"
   USE TEST
   INDEX ON FastInv(Empname) TO TEMP1
*  ...

FUNCTION FASTINV
*ͻ
* Program...: FASTINV                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function generates an inverse     
*             alphabetic index of the first 4        
*             characters of a string.                
* Parameters: INFIELD - The field(s) to index on.    
*ͼ
PARAMETERS InField
PRIVATE    InField, NLoop
NewString = " "
MaxLook = IIF(LEN(TRIM(InField))>4, 4, LEN(TRIM(InField)))
FOR NLoop = 1 TO MaxLook
   NewChar = UPPER(SUBSTR(InField,NLoop,1))
   Num = ASC(NewChar) - 78
   Num = IIF(Num>=0, Num+1, Num)
   Num = -Num + 77
   Num = IIF(Num<=78, Num+1, Num)
   NewString = NewString + CHR(Num)
NEXT
NewString = LTRIM(NewString) + SPACE(LEN(InField) - LEN(LTRIM(NewString)))
RETURN(NewString)
*END:FASTINV
************************************************************************
*  Calling code:
*  SAMPLE2
*  ...
   @ 12,38 SAY "I N D E X I N G"
   USE TEST
   INDEX ON RevNumb(ZIP, 5) TO TEMP1
*  ...

FUNCTION REVNUMB
*ͻ
* Program...: REVNUMB                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function indexes numberic fields  
*             decending.                             
* Parameters: INFIELD - The field(s) to index on.    
*             LENNUM  - The length of InField.       
*ͼ
PARAMETERS InField, LenNum
PRIVATE    InField, LenNum
SNines = REPLICATE("9", LenNum)
Nines  = VAL(SNines)
RETURN(Nines - InField)
*END:REVNUMB

*  Calling code:
*  SAMPLE2
*  ...
   @ 12,38 SAY "I N D E X I N G"
   USE TEST
   INDEX ON RevDate(EmpDate) TO TEMP1
*  ...
************************************************************************
FUNCTION REVDATE
*ͻ
* Program...: REVDATE                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function indexes dates decending. 
* Parameters: INDATE - The Date to index on.         
*ͼ
PARAMETERS InDate
PRIVATE    InDate
NewDate = 99999999 - VAL(DTOS(InDate))
RETURN(NewDate)
* For the Autumn 1986 release of Clipper
* Use the following
* NewDate = YEAR(InDate)* 10000 + MONTH(InDate) * 100 + DAY(InDate)
* NewDate = 99999999 - NewDate
* RETURN(NewDate)
*END:REVDATE
************************************************************************
* Calling code:
* SAMPLE2
* ...
  Mess1 = "DO YOU WISH TO"
  Mess2 = "DELETE THIS RECORD?"
  YNE   = " "
  SET COLOR TO W+/B,B/W,B,B
  CLEAR
  YNE = YESORN(Mess1, Mess2)
* ...

FUNCTION YESORN
*ͻ
* Program...: YESORN                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns a box where the  
*             a user can answer the question in the  
*             box with a Y or N - the Y or N is then 
*             returned.                              
* Parameters: Mess1 - The first message line to be   
*                     displayed.                     
*             Mess2 - The second message line to be  
*                     displayed.                     
*ͼ
PARAMETERS Mess1, Mess2
PRIVATE Special,B1,B2,NewColor
NewColor =  "W+/R,N/W,B,B,N/W"
Special  =  CHR(218)+CHR(196)+CHR(183)+CHR(186)+;
            CHR(188)+CHR(205)+CHR(212)+CHR(179)+CHR(32)
            *  ķ
            *     
            *  ͼ
DoubleBox = CHR(201)+CHR(205)+CHR(187)+CHR(186)+;
            CHR(188)+CHR(205)+CHR(200)+CHR(186)+CHR(32)
            *  ͻ
            *     
            *  ͼ
YorN = 0
B2   = 21
SAVE SCREEN
SET CURSOR OFF
* Autumn 1986 Release Use    CALL _setctyp WITH word(0)
SET MESSAGE TO
IF LEN(TRIM(Mess2)) = 0
   B1 = LEN(TRIM(Mess1))
   B2 = 20 + (41-B1)/2
ENDIF
SET COLOR TO "N/N"
@  8,62 CLEAR TO 15,63
@ 15,21 CLEAR TO 15,63
SET COLOR TO &NewColor
@  7,19,14,61 BOX DoubleBox
@  8,B2 SAY TRIM(Mess1)
@  9,21 SAY TRIM(Mess2)
@ 11,27,13,33 BOX Special
@ 11,48,13,53 BOX Special
@ 12,28 PROMPT " Yes "
@ 12,49 PROMPT " No "
MENU TO YorN
IF YorN = 1
   YNE = "Y"
ELSE
   YNE = "N"
ENDIF
RESTORE SCREEN
SET CURSOR ON
* Autumn 1986 Release Use    CALL _setctyp WITH word(1)
RETURN(YNE)
*END:YESORN
************************************************************************
* Calling code:
* SAMPLE2
* ...
  SET COLOR TO W+/B,N/W,B,B
  CLEAR
  Ret    = .F.
  Shadow = .T.
  Top    = 10
  Left   = 20
  Bot    = 14
  Right  = 60
  SD     = "D"
  BColor = "W+/R"
  Ret    = BOXES(Top, Left, Bot, Right, Shadow, SD, BColor)
  SET COLOR TO W+/B,N/W,B,B
* ...

FUNCTION BOXES
*ͻ
* Program...: BOXES                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns a box with a     
*             drop shadow.                           
* Parameters: Top    - The top of the box.           
*             Left   - The left corner of the box.   
*             Bot    - The bottom of the box.        
*             Right  - The right corner of the box.  
*             Shadow - Should a shadow be drawn?     
*             SD     - Draw a single "S", or double  
*                      "D" box.                      
*             BColor - Color of the box.             
*ͼ
PARAMETER T, L, B, R, S, SD, BC
PRIVATE   T, L, B, R, S, SD, BC, Kind
DoubleBox = CHR(201)+CHR(205)+CHR(187)+CHR(186)+;
            CHR(188)+CHR(205)+CHR(200)+CHR(186)+CHR(32)
          *  ͻ
          *     
          *  ͼ
SingleBox = CHR(218)+CHR(196)+CHR(191)+CHR(179)+;
            CHR(217)+CHR(196)+CHR(192)+CHR(179)+CHR(32)
          * Ŀ
          *    
          * 
Kind = IIF(SD="S", SingleBox, DoubleBox)
IF S
   SET COLOR TO N/N
   @ T+1, R+1 CLEAR TO B+1, R+2
   @ B+1, L+2 CLEAR TO B+1, R+2
ENDIF
SET COLOR TO &BC
@ T, L, B, R BOX Kind
RETURN(.T.)
*END:BOXES
************************************************************************
* Calling code:
* SAMPLE2
* ...
  SET COLOR TO W+/B,N/W,B,B
  CLEAR
  Message   = "This is the message to center"
  @ 12,  0 SAY MessCent(Message, 80)
  @ 14, 45 SAY MessCent(Message, 30)
* ...

FUNCTION MESSCENT
*ͻ
* Program...: MESSCENT                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns a centered       
*             message.                               
* Parameters: Mess   - The message to center.        
*             MaxLen - The maximum length of the     
*                      message.                      
*ͼ
PARAMETER Mess, MaxLen
PRIVATE   Mess, MaxLen
Mess = LTRIM(TRIM(Mess))
RETURN (REPLICATE(" ", (MaxLen-LEN(Mess))/2) + Mess)
RETURN(.T.)
*END:MESSCENT
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   SET DECIMALS TO 6
   DECLARE ArrayN[10]
   ArrayN[1]  = 87
   ArrayN[2]  = 79
   ArrayN[3]  = 97
   ArrayN[4]  = 83
   ArrayN[5]  = 90
   ArrayN[6]  = 85
   ArrayN[7]  = 51
   ArrayN[8]  = 98
   ArrayN[9]  = 99
   ArrayN[10] = 88
   TheSum     = ASum(ArrayN)
   ? TheSum
*  The Sum of the array = 857.0
*  ...

FUNCTION ASUM
*ͻ
* Program...: ASUM                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function sums the elements of an  
*             array.                                 
* Parameters: ArrayN - The array containing numeric  
*                      elements to sum.              
*ͼ
PARAMETERS ArrayN
PRIVATE J, N, Tot
STORE 0 TO J, Tot
J = LEN(ArrayN)
FOR N = 1 TO J
   Tot = Tot + ArrayN[N]
Next
RETURN(Tot)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   SET DECIMALS TO 6
   DECLARE ArrayN[10]
   ArrayN[1]  = 87
   ArrayN[2]  = 79
   ArrayN[3]  = 97
   ArrayN[4]  = 83
   ArrayN[5]  = 90
   ArrayN[6]  = 85
   ArrayN[7]  = 51
   ArrayN[8]  = 98
   ArrayN[9]  = 99
   ArrayN[10] = 88
   TheAvg     = AAvg(ArrayN)
   ? TheAvg
*  The Avg of the array = 85.7
*  ...

FUNCTION AAVG
*ͻ
* Program...: AAVG                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the average of  
*             the elements in the array.             
* Parameters: ArrayN - The array containing numeric  
*                      elements to average.          
*ͼ
PARAMETERS ArrayN
PRIVATE J, N, Tot, Avg
STORE 0 TO J, Tot, Avg
J = LEN(ArrayN)
FOR N = 1 TO J
   Tot = Tot + ArrayN[N]
Next
Avg = Tot / J
RETURN(Avg)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   SET DECIMALS TO 6
   DECLARE ArrayN[10]
   ArrayN[1]  = 87
   ArrayN[2]  = 79
   ArrayN[3]  = 97
   ArrayN[4]  = 83
   ArrayN[5]  = 90
   ArrayN[6]  = 85
   ArrayN[7]  = 51
   ArrayN[8]  = 98
   ArrayN[9]  = 99
   ArrayN[10] = 88
   TheVar     = AVar(ArrayN)
   ? TheVar
*  The Variance of the array = 193.122222
*  ...

FUNCTION AVAR
*ͻ
* Program...: AVAR                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the variance of 
*             the elements of an array               
* Parameters: ArrayN - The array containing numeric  
*                      elements to compute the       
*                      variance of.                  
*ͼ
PARAMETERS ArrayN
PRIVATE J, N, Tot, SSq, Avg, Var
STORE 0 TO J, Tot, SSq, Avg, Var
J = LEN(ArrayN)
FOR N = 1 TO J
   Tot = Tot + ArrayN[N]
   SSq = SSq + (ArrayN[N] * ArrayN[N])
Next
Var = (SSq - (Tot * Tot) / J) / (J - 1)
RETURN(Var)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   SET DECIMALS TO 6
   DECLARE ArrayN[10]
   ArrayN[1]  = 87
   ArrayN[2]  = 79
   ArrayN[3]  = 97
   ArrayN[4]  = 83
   ArrayN[5]  = 90
   ArrayN[6]  = 85
   ArrayN[7]  = 51
   ArrayN[8]  = 98
   ArrayN[9]  = 99
   ArrayN[10] = 88
   TheSD      = ASD(ArrayN)
   ? TheSD

*  The Std Dev of the array = 13.896842
*  ...

FUNCTION ASD
*ͻ
* Program...: ASD                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the standard    
*             deviation of the elements of an array  
* Parameters: ArrayN - The array containing numeric  
*                      elements to compute the       
*                      standard deviation of.        
*ͼ
PARAMETERS ArrayN
PRIVATE J, N, Tot, SSq, Avg, Var, Std
* Note: If you already have a variance function
* just use the next line without the comment.
* RETURN(AVar(ArrayN)^0.5)
STORE 0 TO J, Tot, SSq, Avg, Var, Std
J = LEN(ArrayN)
FOR N = 1 TO J
   Tot = Tot + ArrayN[N]
   SSq = SSq + (ArrayN[N] * ArrayN[N])
Next
Var = (SSq - (Tot * Tot) / J) / (J - 1)
Std = Var ^ 0.5
RETURN(Std)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   DECLARE ArrayN[9]
   ArrayN[1] = "ABC"
   ArrayN[2] = "AVD"
   ArrayN[3] = "VEF"
   ArrayN[4] = "BER"
   ArrayN[5] = "AAA"
   ArrayN[6] = "XEW"
   ArrayN[7] = "EWW"
   ArrayN[8] = "A"
   ArrayN[9] = "BBG"
   First     = AMin(ArrayN)
   ? First

*  The minimum value in the array is "A"
*  ...

FUNCTION AMIN
*ͻ
* Program...: AMIN                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function finds the element of the 
*             array containing the lowest value, and 
*             returns its value.                     
* Parameters: Array - The array containing elements  
*                     which this function will use   
*                     to find the lowest.            
*ͼ
PARAMETERS Array
PRIVATE N, X, J
N = LEN(Array)
X = Array[1]
FOR J = 2 TO N
   X = IIF(Array[J]<X, Array[J], X)
NEXT
RETURN(X)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   DECLARE ArrayN[9]
   ArrayN[1] = "ABC"
   ArrayN[2] = "AVD"
   ArrayN[3] = "VEF"
   ArrayN[4] = "BER"
   ArrayN[5] = "AAA"
   ArrayN[6] = "XEW"
   ArrayN[7] = "EWW"
   ArrayN[8] = "A"
   ArrayN[9] = "BBG"
   Last      = AMax(ArrayN)
   ? Last

*  The maximum value in the array is "XEW"
*  ...

FUNCTION AMAX
*ͻ
* Program...: AMAX                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function finds the element of the 
*             array containing the highest value,    
*             and returns its value.                 
* Parameters: Array - The array containing elements  
*                     which this function will use   
*                     to find the highest.           
*ͼ
PARAMETERS Array
PRIVATE N, X, J
N = LEN(Array)
X = Array[1]
FOR J = 2 TO N
   X = IIF(Array[J]>X, Array[J], X)
NEXT
RETURN(X)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   HexNum = "AAAA"
   Dec    = DecEquiv(HexNum)
   ? Dec
*  The Decimal equivalent is 43690
*  ...

FUNCTION DECEQUIV
*ͻ
* Program...: DECEQUIV                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts a hexadecimal   
*             number (0-FFFF) to a decimal number.   
* Parameters: HexNum - The hexadecimal number to be  
*                      converted into a decimal      
*                      number.                       
*ͼ
PARAMETERS HexN
PRIVATE Ans, AllHex, N1, N2, N3, N4
AllHex = "123456789ABCDEF"
N1 = AT(SUBSTR(HexN,1,1), AllHex)
N2 = AT(SUBSTR(HexN,2,1), AllHex)
N3 = AT(SUBSTR(HexN,3,1), AllHex)
N4 = AT(SUBSTR(HexN,4,1), AllHex)
Ans = (N1 * 4096) + (N2 * 256) + (N3 * 16) + N4
RETURN(Ans)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   DecNum = 43690
   Hex    = HexEquiv(DecNum)
   ? Hex
*  The Hexadecimal equivalent is AAAA
*  ...

FUNCTION HEXEQUIV
*ͻ
* Program...: HEXEQUIV                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts a decimal       
*             number (0-65535) to a hexadecimal      
*             number.                                
* Parameters: DecNum - The decimal number to be      
*                      converted into a hexadecimal  
*                      number.                       
*ͼ
PARAMETERS DecN
PRIVATE Ans, N1, N2, N3, N4, M1, M2, M3
N1 = INT(DecN / 4096)
M1 = N1 * 4096
N2 = INT((DecN - M1) / 256)
M2 = N2 * 256
N3 = INT((DecN - M1 - M2) / 16)
M3 = N3 * 16
N4 = INT(DecN - M1 - M2 - M3)
Ans = Let(N1) + Let(N2) + Let(N3) + Let(N4)
RETURN(Ans)


FUNCTION LET
PARAMETER Num
IF Num < 10 .AND. Num > 0
   RETURN(STR(Num,1,0))
ENDIF
DO CASE
   CASE Num = 0
      RETURN("0")
   CASE Num = 10
      RETURN("A")
   CASE Num = 11
      RETURN("B")
   CASE Num = 12
      RETURN("C")
   CASE Num = 13
      RETURN("D")
   CASE Num = 14
      RETURN("E")
   CASE Num = 15
      RETURN("F")
ENDCASE
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Mat = 27000
   Now = 10000
   Yrs = 12
   NRate = Rate(Mat, Now, Yrs)
   ? NRate
*  NRate Should be .0831 or 8.31%
*  ...

FUNCTION RATE
*ͻ
* Program...: RATE                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the interest    
*             rate an investments earns.             
* Parameters: Mat - The dollar amount the investment 
*                   is worth at maturity.            
*             Now - The dollar amount the investment 
*                   is worth at the start.           
*             Yrs - The number of years required for 
*                   the investment to go from a      
*                   starting value of Now to a final 
*                   value of Mat.                    
*ͼ
PARAMETERS Mat, Now, Yrs
PRIVATE N, D, M , R
M = Yrs * 12
N = Mat
D = Now
R = ((N / D) ^ (1 / M)) - 1
RETURN(R*12)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Int = 10
   Mat = 20000
   Now = 10000
   NMonth = Term(Int, Mat, Now)
   ? NMonth
*  NMonth Should be 83.52
*  ...

FUNCTION TERM
*ͻ
* Program...: TERM                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the time        
*             required for an investment to grow     
*             from a value of Now to a value of Mat  
*             at a compound interest rate of Int.    
* Parameters: Mat - The dollar amount the investment 
*                   is worth at maturity.            
*             Now - The dollar amount the investment 
*                   is worth at the start.           
*             Int - The compound interest rate which 
*                   the investment in invested at.   
*ͼ
PARAMETERS Int, Mat, Now
PRIVATE N, D, I
I = Int * 0.01 / 12
N = LOG(Mat / Now)
D = LOG(1 + I)
RETURN(N/D)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Int = 9.5
   Mat = 200000
   Dep = 2000
   NYears = Term2(Dep, Int, Mat)
   ? NYrs
*  NYrs Should be 25.91
*  ...

FUNCTION TERM2
*ͻ
* Program...: TERM2                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the time        
*             required for a periodic investment     
*             to grow to a value of Mat at a         
*             compound interest rate of Int.         
* Parameters: Mat - The dollar amount the investment 
*                   is worth at maturity.            
*             Dep - The dollar amount of the         
*                   periodic investment.             
*             Int - The compound interest rate which 
*                   the investment in invested at.   
*ͼ
PARAMETERS Dep, Int, Mat
PRIVATE N, D
IR = Int * 0.01
N  = LOG(1 + (Mat * IR / Dep))
D  = LOG(1 + IR)
RETURN(N/D)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Int  = 11.5
   Prin = 250000
   Yrs  = 30
   MPay = Pmts(Int, Prin, Yrs)
   ? MPay
*  MPay Should be $2,475.73
*  ...

FUNCTION PMTS
*ͻ
* Program...: PMTS                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the monthly     
*             payment due on a straight interest     
*             loan such as a mortgage.               
* Parameters: Int  - The loan interest rate.         
*             Prin - The total amount of the loan.   
*             Yrs  - The number of years the loan    
*                    is for.                         
*ͼ
PARAMETERS Int, Prin, Yrs
PRIVATE N, D, I, Y
Y = Yrs * 12
I = Int * 0.01 / 12
D = 1-(I + 1) ^ -Y
RETURN(Prin*I/D)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Int = 10
   Dep = 2000
   Yrs = 20
   NFV = FV(Dep, Int, Yrs)
   ? NFV
*  NFV Should be $114,550
*  ...

FUNCTION FV
*ͻ
* Program...: FV                                     
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the future      
*             value of a periodic investment at a    
*             constant interest rate.                
* Parameters: Int - The interest rate.               
*             Dep - The periodic investment amount.  
*             Yrs - The number of years the Dep is   
*                   made over.                       
*ͼ
PARAMETERS Dep, Int, Yrs
PRIVATE N, D
D = Int * 0.01
N = ((1 + D) ^ Yrs) - 1
RETURN(N*Dep/D)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Int = 9.5
   Pay = 50000
   Yrs = 20
   NPV = PV(Int, Pay, Yrs)
   ? NPV
*  NPV Should be $440,619.11
*  ...

FUNCTION PV
*ͻ
* Program...: PV                                     
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the present     
*             value of a periodic payment invested   
*             at a constant interest rate.           
* Parameters: Int - The interest rate.               
*             Pay - The periodic payment amount.     
*             Yrs - The number of years the Pay is   
*                   made over.                       
*ͼ
PARAMETERS Int, Pay, Yrs
PRIVATE N, D, I
D = Int * 0.01
N = 1 - ((1 + D) ^ -Yrs)
RETURN(Pay*N/D)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Cost = 10000
   Sal  = 2000
   Life = 5
   Yr   = 2
   SDep = SL (Cost, Sal, Life)
   ? SDep
*  SDep Should be 1600
*  ...

FUNCTION SL
*ͻ
* Program...: SL                                     
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the annual      
*             depreciation of an asset with salvage  
*             value of Sal over a useful life of     
*             Life.                                  
* Parameters: Cost - Cost of the asset.              
*             Sal  - Salvage value of the asset.     
*             Life - Useful life of the asset.       
*ͼ
PARAMETERS C, S, L
PRIVATE    C, S
N = (C - S)
RETURN(N/L)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Cost = 10000
   Sal  = 2000
   Life = 5
   Yr   = 2
   YDep = SYD(Cost, Sal, Life, Yr)
   ? YDep
*  YDep Should be 2133
*  ...

FUNCTION SYD
*ͻ
* Program...: SYD                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the yearly (Yr) 
*             depreciation of an asset with salvage  
*             value of Sal over a useful life of     
*             Life.                                  
* Parameters: Cost - Cost of the asset.              
*             Sal  - Salvage value of the asset.     
*             Life - Useful life of the asset.       
*             Yr   - The year you wish to compute    
*                    the depreciation for.           
*ͼ
PARAMETERS C, S, L, Y
PRIVATE    C, S, L, Y
N = (C - S) * (L - Y + 1)
D = (L * (L + 1) / 2)
RETURN(N/D)
************************************************************************
*Calling code:
*  SAMPLE2
*  ...
   CLEAR
   Cost = 10000
   Sal  = 2000
   Life = 5
   Yr   = 2
   DDep = DDL(Cost, Sal, Life, Yr)
   ? DDep
*  DDep Should be 2400
*  ...

FUNCTION DDL
*ͻ
* Program...: DDL                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the yearly (Yr) 
*             depreciation of an asset with salvage  
*             value of Sal over a useful life of     
*             Life.                                  
* Parameters: Cost - Cost of the asset.              
*             Sal  - Salvage value of the asset.     
*             Life - Useful life of the asset.       
*             Yr   - The year you wish to compute    
*                    the depreciation for.           
*ͼ
PARAMETERS C, S, L, Y
PRIVATE    C, S, L, Y, N, NewTotal, TotDep
CLEAR
DECLARE YrDep[L]
NewTotal = C
TotDep   = 0
FOR N = 1 TO Y
   YrDep[N] = NewTotal * 2 / L
   NewTotal = NewTotal - YrDep[N]
   TotDep   = IIF(N<=Y, TotDep+YrDep[N], TotDep)
NEXT
RETURN(YrDep[Y])
************************************************************************
*Calling code:
*SAMPLE2
* ...
DECLARE AllFiles[ADIR("*.DBF")]
NumOfFiles = ADIR("*.DBF", ALLFILES)
? NumOfFiles
FOR J = 1 TO NumOfFiles
   ? AllFiles[J]
   NEXT
WAIT
ASORT(AllFiles)
FOR J = 1 TO NumOfFiles
   ? AllFiles[J]
NEXT
*...

FUNCTION ASORT
*ͻ
* Program...: ASORT                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns an array sorted  
*             in ascending order.                    
* Parameters: AName - The array to sort.             
*ͼ
PARAMETERS AName
PRIVATE J, K, C, ALen
ALen = LEN(AName)
FOR J = 1 TO ALen - 1
   FOR K = J+1 TO ALen
      IF AName[K] < AName[J]
         C        = AName[K]
         AName[K] = AName[J]
         AName[J] = C
      ENDIF
   NEXT
NEXT
RETURN(.T.)
************************************************************************
Calling code:
*SAMPLE2
*...
SELECT A
Rank = ALLTRIM(A->EmpRank)
@ 12, 12 SAY Rank  PICTURE "@!"
*...

FUNCTION ALLTRIM
*ͻ
* Program...: ALLTRIM                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns a string with    
*             leading and trialing blanks revoved.   
* Parameters: Str - The string to trim.              
*ͼ
PARAMETER Str
RETURN (LTRIM(TRIM(Str)))
*END:ALLTRIM
************************************************************************
*  SAMPLE2
*  ...
CLEAR
X = " 1 "
Y = " 22"
@ 12,12 SAY X PICTURE "!!!"
@ 12,15 SAY "/"
@ 12,16 SAY Y PICTURE "!!!"

@ 14,12 SAY  NTRIM(X,3) PICTURE "!!!"
@ 14,15 SAY "/"
@ 14,16 SAY LTRIM(Y) PICTURE "!!!"
* ...

FUNCTION NTRIM
*ͻ
* Program...: NTRIM                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns a right          
*             justified pseudo-numeric field         
* Parameters: PNum - The pseudo-numeric variable     
*             PLen - The field length.               
*ͼ
PARAMETERS PNum, PLen
RETURN(STR(VAL(PNum),PLen,0))
************************************************************************
*  SAMPLE2
*  ...
CLEAR
X = 1
Y = 22
@ 12,12 SAY X PICTURE "9999"
@ 12,16 SAY "/"
@ 12,17 SAY Y PICTURE "9999"

SX = ZFILL(X,4)
SY = ZFILL(Y,4)
@ 14,12 SAY SX PICTURE "!!!!"
@ 14,16 SAY "/"
@ 14,17 SAY SY PICTURE "!!!!"
*  ...

FUNCTION ZFILL
*ͻ
* Program...: ZFILL                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function display a numeric field  
*             justified with leading zeros.          
* Parameters: Num  - The numeric field.              
*             Size - The total field length.         
*ͼ
PARAMETERS Num, Size
PRIVATE NewNum, N
NewNum = LTRIM(STR(Num,19,0))
N      = LEN(NewNum)
NewNum = REPLICATE("0", Size - N) + NewNum
RETURN(NewNum)
************************************************************************
* SAMPLE2
* ...
FName = "    PHIL"
LName = "    STEELE"
Name  = LJust(FName) + LJust(LName)
? Name
? Len(Name)
* Len(Name) SHOULD = 18
* ...

FUNCTION LJUST
*ͻ
* Program...: LJUST                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function left justifies a string. 
* Parameters: InStr - The string to left justify.    
*ͼ
PARAMETERS InStr
PRIVATE N, OutStr
N      = LEN(InStr)
OutStr = LTRIM(InStr)
OutStr = OutStr + REPLICATE(" ", N-LEN(OutStr))
RETURN(OutStr)
************************************************************************
* SAMPLE2
* ...
Str    = "ABCDEFGH"
NewStr = Left(STR,5)
? NewStr
* ...

FUNCTION LEFT
*ͻ
* Program...: LEFT                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns the left Num of  
*             characters.                            
* Parameters: Str - The string to return the left    
*                   Num of characters from.          
*             Num - The number of chacters to return 
*                   from the left of the string.     
*ͼ
PARAMETERS Str, Size
PRIVATE NewStr
NewStr = SUBSTR(Str,1,Size)
RETURN(NewStr)
************************************************************************
* SAMPLE2
* ...
Str    = "ABCDEFGH"
NewStr = Right(STR,5)
? NewStr
* ...

FUNCTION RIGHT
*ͻ
* Program...: RIGHT                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns the right Num of 
*             characters.                            
* Parameters: Str - The string to return the right   
*                   Num of characters from.          
*             Num - The number of chacters to return 
*                   from the right of the string.    
*ͼ
PARAMETERS Str, Size
PRIVATE Start, NewStr
Start  = LEN(Str) - Size + 1
NewStr = SUBSTR(Str,Start)
RETURN(NewStr)
************************************************************************
* SAMPLE2
* ...
SET DEVICE TO PRINT
N = 0
Esc = CHR(27)
Start = Esc + "*p0x0Y"
@ N,0 SAY "&Start"
HLine(1,2,6,2,N)
EJECT
SET DEVICE TO SCREEN
* ...

FUNCTION HLINE
*ͻ
* Program...: HLINE                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function draws a horizontal line  
*             on a laser printer.                    
* Parameters: StartD - The starting position of the  
*                      line down from the top of the 
*                      page in inches.               
*             StartL - The starting position of the  
*                      line in from the left of the  
*                      page in inches.               
*             HLen   - The length of the horizontal  
*                      line in inches.               
*             LWidth - The width of the horizontal   
*                      line in 1/300's of an inch.   
*             J      - The line current line number  
*                      where printing is occurring.  
*ͼ
PARAMETERS StartD, StartL, HLen, LWidth, J
PRIVATE    CompD,  CompL,  CLen, J, Esc
Esc     = CHR(27)
CompD   = 300 * StartD - 150
CompD   = IIF(CompD<0, 0, CompD)
CompL   = 300 * StartL - 75
CompL   = IIF(CompL<0, 0, CompL)
CLen    = 300 * HLen
HorLine = Esc + "*p" + STR(CompD,5,0)  + "y" + STR(CompL,5,0) + "X" + ;
          Esc + "*c" + STR(LWidth,2,0) + "b" + STR(CLen, 5,0) + "a0P"
@ J,0 SAY "&HorLine"
RETURN(.T.)
************************************************************************
* SAMPLE2
* ...
SET DEVICE TO PRINT
N = 0
Esc = CHR(27)
Start = Esc + "*p0x0Y"
@ N,0 SAY "&Start"
VLine(1,2,6,2,N)
EJECT
SET DEVICE TO SCREEN
* ...

FUNCTION VLINE
*ͻ
* Program...: VLINE                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function draws a horizontal line  
*             on a laser printer.                    
* Parameters: StartD - The starting position of the  
*                      line down from the top of the 
*                      page in inches.               
*             StartL - The starting position of the  
*                      line in from the left of the  
*                      page in inches.               
*             HLen   - The length of the vertical    
*                      line in inches.               
*             LWidth - The width of the vertical     
*                      line in 1/300's of an inch.   
*             J      - The line current line number  
*                      where printing is occurring.  
*ͼ
PARAMETERS StartD, StartL, HLen, LWidth, J
PRIVATE    CompD,  CompL,  CLen, J, Esc
Esc     = CHR(27)
CompD   = 300 * StartD - 150
CompD   = IIF(CompD<0, 0, CompD)
CompL   = 300 * StartL - 75
CompL   = IIF(CompL<0, 0, CompL)
CLen    = 300 * VLen
VerLine = Esc + "*p" + STR(CompD,5,0)  + "y" + STR(CompL,5,0) + "X" + ;
          Esc + "*c" + STR(LWidth,2,0) + "a" + STR(CLen, 5,0) + "b0P"
@ J,0 SAY "&VerLine"
RETURN(.T.)
************************************************************************
* SAMPLE2
* ...
SET DEVICE TO PRINT
N = 0
Esc = CHR(27)
Start = Esc + "*p0x0Y"
@ N,0 SAY "&Start"
HPBox(1,2,5,3,2,N)
EJECT
SET DEVICE TO SCREEN
* ...

FUNCTION HPBOX
*ͻ
* Program...: HPBOX                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function draws a horizontal line  
*             on a laser printer.                    
* Parameters: StartD - The starting position of the  
*                      box down from the top of the  
*                      top of the page in inches.    
*             StartL - The starting position of the  
*                      box in from the left of the   
*                      page in inches.               
*             EndD   - The ending position of the    
*                      box down from the top of the  
*                      top of the page in inches.    
*             EndR   - The ending position of the    
*                      box in from the left of the   
*                      page in inches.               
*             LWidth - The width of the vertical     
*                      line in 1/300's of an inch.   
*             J      - The line current line number  
*                      where printing is occurring.  
*ͼ
PARAMETERS StartD, StartL, EndD, EndR, LWidth, J
PRIVATE    HStart, HLen, VStart, VLen, HStart2, VStart2, Esc
Esc     = CHR(27)
HStart  = StartD
HLen    = EndD - StartD
VStart  = StartL
VLen    = EndR - StartL
HStart2 = EndD
VStart2 = EndR
HLine(HStart,  VStart,  VLen, LWidth, J)
VLine(HStart,  VStart,  HLen, LWidth, J)
HLine(HStart2, VStart,  VLen, LWidth, J)
VLine(HStart,  VStart2, HLen, LWidth, J)
RETURN(.T.)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 3
Y = 6
Z = DIV(Y,X)
?Z
X = 0
Z = DIV(Y,X)
?Z
X = 3
Y = 0
Z = DIV(Y,X)
?Z
X = 0
Y = 0
Z = DIV(Y,X)
?Z
* ...

FUNCTION DIV
*ͻ
* Program...: DIV                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function checks for division by   
*             zero.                                  
* Parameters: X - The numerator.                     
*             Y - The denominator.                   
*ͼ
PARAMETERS X, Y
PRIVATE    X, Y
IF X = 0 .OR. Y = 0
   RETURN(0)
ELSE
   RETURN (X/Y)
ENDIF
*END:DIV
************************************************************************
* SAMPLE2
* ...
CLEAR
Str    = "THIS IS A LONG STRING"
NewStr = REMOVE(Str,11,5)
? NewStr
* ...

FUNCTION REMOVE
*ͻ
* Program...: REMOVE                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function removes a group of       
*             characters from a string.              
* Parameters: Str   - The string to operate on.      
*             Start - The starting position of the   
*                     area to be removed.            
*             RLen  - The length of the area to      
*                     remove.                        
*ͼ
PARAMETERS Str, Start, RLen
PRIVATE    Str, Start, RLen, NewStr
NewStr = SUBSTR(Str,1,Start-1) + SUBSTR(Str,Start+RLen)
RETURN (NewStr)
************************************************************************
* SAMPLE2
* ...
CLEAR
Str1   = "THIS IS A STRING"
Str2   = "LONGER "
NewStr = STUFF(Str1,11,7,Str2)
? NewStr
* ...

FUNCTION STUFF
*ͻ
* Program...: STUFF                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function inserts characters into  
*             a string.                              
* Parameters: Str   - The primary string to operate  
*                       on.                          
*                     new string to be inserted      
*             RLen  - The length of the area to      
*                     added to the primary string.   
*             Rep   - The secondary string  -  the   
*                     string to be inserted.         
*ͼ
PARAMETERS Str, Start, RLen, Rep
RETURN SUBSTR(Str,1,Start-1)+Rep+SUBSTR(Str,Start+RLen)
************************************************************************
* SAMPLE2
* ...
CLEAR
A = "phil"
B = "PHIL"
X = PROPER(A)
? X
X = PROPER(B)
? X
* ...

FUNCTION PROPER
*ͻ
* Program...: PROPER                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts a string to     
*             lower case and then converts the first 
*             character of the string to upper case. 
* Parameters: X - The words to convert into "proper" 
*                 format.                            
*ͼ
PARAMETERS X
X = UPPER(SUBSTR(X,1,1)) + LOWER(SUBSTR(X,2))
RETURN(X)
************************************************************************
* SAMPLE2
* ...
CLEAR
A = "Phil"
B = "PHIL"
C = "PHILL"
D = "Bill"
X = COMPARE(A,B)
? X
X = COMPARE(A,C)
? X
X = COMPARE(A,D)
? X
* ...

FUNCTION COMPARE
*ͻ
* Program...: COMPARE                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function draws a horizontal line  
*             on a laser printer.                    
* Parameters: X - The first variable to compare.     
*             Y - The second variable to compare.    
*ͼ
PARAMETERS X, Y
PRIVATE    X, Y
IF UPPER(X) == UPPER(Y)
   RETURN(.T.)
ELSE
   RETURN(.F.)
ENDIF
************************************************************************
* SAMPLE2
* ...
SET COLOR TO W+/B,W/N,B
CLEAR
Test = .F.
IF .NOT. Test
   ERR(1)
   @ 12,1 SAY ""
ENDIF
* ...

FUNCTION ERR
*ͻ
* Program...: ERR                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function displays an error on line
*             24 in white on red.                    
* Parameters: N - The number of the error to display.
*ͼ
PARAMETERS N
PRIVATE    N, Key, OldColor
OldColor = SETCOLOR()
Key       = 0
SAVESCREEN(24,0,24,79)
SET COLOR TO W+/R
@ 24,0 CLEAR TO 24,79
SET CURSOR OFF
DO CASE
   CASE N = 1
      @ 24,12 SAY CENT("Error Message one")
   CASE N = 2
      @ 24,12 SAY CENT("Error Message two")
   CASE N = 3
      @ 24,12 SAY CENT("Error Message three")
   CASE N = 4
      @ 24,12 SAY CENT("Error Message four")
   CASE N = 5
      @ 24,12 SAY CENT("Error Message five")
ENDCASE
Key = INKEY(5)
SET COLOR TO (OldColor)
RESTSCREEN(24,0,24,79)
SET CURSOR ON
CLEAR TYPEAHEAD
RETURN(.T.)
************************************************************************
* SAMPLE2
* ...
CLEAR
N = 5
Z = FACT(N)
? Z
* ...

FUNCTION FACT
*ͻ
* Program...: FACT                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the factorial   
*             of a number.                           
* Parameters: N - The number you need the factorial  
*                 of.                                
*ͼ
PARAMETERS N
PRIVATE    N, J, K
K = 1
FOR J = 2 TO N
   K = K * J
NEXT
RETURN (K)
************************************************************************
* SAMPLE2
* ...
CLEAR
N = 5
Z = 4
? N, Z
DO SWAP WITH N, Z
? N, Z
* ...

PROCEDURE SWAP
*ͻ
* Program...: SWAP                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function swaps the values of two  
*             variables.                             
* Parameters: A - A variable to be swapped.          
*             B - Another variable to be swapped.    
*ͼ
PARAMETERS A, B
PRIVATE    C
C = A
A = B
B = C
RETURN
************************************************************************
* SAMPLE2
* ...
CLEAR
Choice = 0
@ 10,30 CLEAR TO 20,50
@ 10,30       TO 20,50 DOUBLE
@ 13,31       TO 13,49
@ 11,35 SAY "MASTER MENU"
@ 13,30 SAY ""  && CHR(199)
@ 13,50 SAY ""  && CHR(182)
SET MESSAGE TO 12
@ 14,31 PROMPT "1. Choice A ......." MESSAGE FIX("Message a",30)
@ 15,31 PROMPT "2. Choice B ......." MESSAGE FIX("Message bb",30)
@ 16,31 PROMPT "3. Choice C ......." MESSAGE FIX("Message ccc",30)
@ 17,31 PROMPT "4. Choice D ......." MESSAGE FIX("Message dddd",30)
@ 18,31 PROMPT "5. Choice E ......." MESSAGE FIX("Message eeeee",30)
@ 19,31 PROMPT "6. Choice F ......." MESSAGE FIX("Message ffffff",30)
MENU TO Choice
* ...

FUNCTION FIX
*ͻ
* Program...: FIX                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function places the MENU message  
*             at the proper place on the screen      
* Parameters: A - A variable to be swapped.          
*             B - Another variable to be swapped.    
*ͼ
PARAMETER Mess, Start
RETURN(SPACE(Start) + "" + Mess )
************************************************************************
* SAMPLE2
* ...
CLEAR
SET DECIMALS TO 12
X = PI()
? X
* ...

FUNCTION PI
*ͻ
* Program...: PI                                     
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns the value of PI  
*             to 11 decimal places.                  
* Parameters: No parameters are used.                
*ͼ
RETURN(3.14159265359)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 30
Y = RAD(X)
?Y
* ...

FUNCTION RAD
*ͻ
* Program...: RAD                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This convert from degrees to radians.  
* Parameters: X - The value in degrees to be         
*                 converted to radians.              
*ͼ
PARAMETERS X
RETURN(3.14159265359 * X / 180)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
Y = DEG(X)
?Y
* ...

FUNCTION DEG
*ͻ
* Program...: DEG                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts radians to      
*             degrees.                               
* Parameters: X - The value in radians to be         
*                 converted to degrees.              
*ͼ
PRIVATE    X
PARAMETERS X
RETURN(180 * X / 3.14159265359)
************************************************************************
* SAMPLE2
* ...
CLEAR
SET DECIMAL TO 15
X=90
?Sine(X)
* ...

FUNCTION SINE
*ͻ
* Program...: SINE                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the Sine of a   
*             value given in degrees.                
* Parameters: X - The value in degrees that we want  
*                 the Sine of.                       
*ͼ
PARAMETERS X
PRIVATE X, J, Y
X    = RAD(X)
Y    = X
Sign = 1
FOR J = 3 TO 17 STEP 2
   Sign = IIF(Sign<0, 1, -1)
   X    = X + (Sign * Y^J)/(FACT(J))
NEXT
RETURN(X)
************************************************************************
* SAMPLE2
* ...
CLEAR
SET DECIMAL TO 15
X=60
?Cos(X)
* ...

FUNCTION COS
*ͻ
* Program...: COS                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the Cosine of a 
*             value given in degrees.                
* Parameters: X - The value in degrees that we want  
*                 the Cosine of.                     
*ͼ
PARAMETERS X
PRIVATE X, J, Y
X = RAD(X)
Y = X
X = 1
Sign = 1
FOR J = 2 TO 16 STEP 2
   Sign = IIF(Sign<0, 1, -1)
   X    = X + (Sign * Y^J)/(FACT(J))
NEXT
RETURN(X)
************************************************************************
* SAMPLE2
* ...
CLEAR
SET DECIMAL TO 15
X=45
?Tan(X)
* ...

FUNCTION TAN
*ͻ
* Program...: TAN                                    
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the Tangent of  
*             a value given in degrees.              
* Parameters: X - The value in degrees that we want  
*                 the Tangent of.                    
*ͼ
PRIVATE X, J, Y
J = SINE(X)
Y = COS(X)
RETURN(J/Y)
************************************************************************
* SAMPLE2
* ...
ARow   = 2
ACol   = 2
Height = 3
Width  = 3
Esc    = CHR(27)
DO WHILE ARow <> 0
   CLEAR
   @ 1,0 GET ARow    PICTURE "99"
   @ 2,0 GET ACol    PICTURE "99"
   @ 3,0 GET Height  PICTURE "99"
   @ 4,0 GET Width   PICTURE "99"
   READ
   IF ARow = 0
      EXIT
   ENDIF
   SET DEVICE TO PRINT
   @ 0,0 SAY Esc + "*p0x0Y"
   CIRCLE(ARow, ACol, Height, Width)
EJECT
ENDDO
SET DEVICE TO SCREEN

FUNCTION CIRCLE
*ͻ
* Program...: CIRCLE                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function draws a circle or an     
*             ellipse on a laser printer using HP    
*             laser jet codes.                       
* Parameters: ARow -   The row in inches for the     
*                      center of the circle.         
*             ACol -   The column in inches for the  
*                      center of the circle.         
*             Height - The height of the circle in   
*                      inches.                       
*             Width  - The width of the circle in    
*                      inches.                       
* Addition Notes: If the height of the circle does   
*                 not equal the width you get an     
*                 ellipse.                           
*                 This UDF is NOT fast.              
*ͼ
PARAMETERS ARow, ACol, Height, Width
PRIVATE J, Y, Z, K, L, M, R, Point
Esc = CHR(27)
FOR R = 5 TO -5 STEP -.005
   J = 30 * R
   Y = ((1-J*J)^.5)
   Z = -Y
   IF Y <> 0
      K = J * Height * 300 + (ARow * 300)
      L = Y * Width  * 300 + (ACol * 300)
      M = Z * Width  * 300 + (ACol * 300)
      Point = Esc + "*p" + STR(K,5,0) + "y" +;
              STR(L,5,0) + "X" + Esc + "*c2a2b0P"
      @ J,0 SAY "&Point"
      Point = Esc + "*p" + STR(K,5,0) + "y" +;
              STR(M,5,0) + "X" + Esc + "*c2a2b0P"
      @ J,0 SAY "&Point"
   ENDIF
NEXT
RETURN(.T.)
************************************************************************
* SAMPLE2
* ...
CLEAR
USE TEST
* File contains: ... PAUL, SAM, ZELDA ...
INDEX ON NAME TO FName
Key = "PHIL"
SEEK Key
? RECNO()
? NAME
SOFTSEEK(Key)
? RECNO()
? NAME
* ...

FUNCTION SOFTSEEK
*ͻ
* Program...: SOFTSEEK                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns a record equal to
*             or just after the seek key.            
* Parameters: NewSeek - The value to SEEK on.        
*ͼ
PARAMETERS NewSeek
PRIVATE    NewSeek, FirstChar
FirstChar = SUBSTR(NewSeek,1,1)
SEEK NewSeek
DO WHILE EOF()
   IF LEN(NewSeek) > 1
      NewSeek = SUBSTR(NewSeek,1,LEN(NewSeek)-1)
   ELSE
      NewSeek   = CHR(ASC(FirstChar) + 1)
      FirstChar = NewSeek
      IF ASC(NewSeek) > 90             && ASC 90 = Z
         GOTO BOTTOM
         EXIT
      ENDIF
   ENDIF
   SEEK NewSeek
ENDDO
RETURN(.T.)
************************************************************************
* SAMPLE2
* ...
SET COLOR TO W+/B,N/W
CLEAR
X = "THIS IS A TEST"
@ 2,2 CLEAR TO 22,70
@ 2,2       TO 22,70 DOUBLE
@ 12,12 SAY X
WAIT
BoxColor(2,2,22,70,"R/W","D")
@ 14,12 SAY X
WAIT
* ...

FUNCTION BOXCOLOR
*ͻ
* Program...: BOXCOLOR                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function changes the color of a   
*             single or double line box around a     
*             message without changing the color of  
*             the message.                           
* Parameters: T  - The top row of the box.           
*             L  - The top column of the box.        
*             B  - The bottom row of the box.        
*             R  - The bottom column of the box.     
*             C  - The new color for the box.        
*             SD - "S" = a single box and            
*                  "D" = a double box.               
*ͼ
PARAMETERS T,L,B,R,C,SD
PRIVATE    T,L,B,R,C,SD,OldC
OldC = SETCOLOR()
SET COLOR TO &C
IF UPPER(SD) = "D"
   @ T,L TO B,R DOUBLE
ELSE
   @ T,L TO B,R
ENDIF
SET COLOR TO &OldC
RETURN(.T.)
************************************************************************
* SAMPLE2
* ...
SET COLOR TO W+/B,N/W
CLEAR
X = "THIS IS A TEST"
@ 2,2 CLEAR TO 22,70
@ 2,2       TO 22,70 DOUBLE
@ 16,12 SAY X
WAIT

MessCol(16,12,X,"G/R")
@ 16,12 SAY X
WAIT
* ...

FUNCTION MESSCOL
*ͻ
* Program...: MESSCOL                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function changes the color of a   
*             message without affecting any other    
*             colors.                                
* Parameters: R  - The row the message starts on.    
*             C  - The column the message starts on. 
*             M  - The message.                      
*             NC - The new color for the message.    
*ͼ
PARAMETERS R,C,M,NC
PRIVATE    R,C,M,NC,OldC
OldC = SETCOLOR()
SET COLOR TO &NC
@ R,C SAY M
SET COLOR TO &OldC
RETURN(.T.)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 123456.7
Y = Dollars(X)
? Y
X = -23456.7
Y = Dollars(X)
? Y
* ...

FUNCTION DOLLARS
*ͻ
* Program...: DOLLARS                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function displays a number as a   
*             dollar amount.                         
* Parameters: X  - The number to display as a dollar 
*                  amount.                           
*ͼ
PARAMETERS X
PRIVATE Z
Z = LTRIM(TRANSFORM(X, "999,999,999,999.99"))
Z = IIF(X>0, "$"+Z, "-$"+SUBSTR(Z,2))
RETURN (Z)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = TIME()
? X
Y = NonMilt(X)
? Y
* ...

FUNCTION NONMILT
*ͻ
* Program...: NONMILT                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function displays military time   
*             as a normal time with AM and PM.       
*             14:22:22 is displayed  as 2:22:22 PM   
* Parameters: X  - The military time to be displayed.
*ͼ
PARAMETERS X
PRIVATE    Y, Z
Y = VAL(LEFT(X,2))
Z = IIF(Y<12, X+" AM", STR(Y-12,2,0)+SUBSTR(X,3)+" PM")
RETURN(Z)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = "14:32:21"        && Time1
Y = "17:18:06"        && Time2
Z = ElapTime(X,Y)
?Z
* ...

FUNCTION ELAPTIME
*ͻ
* Program...: ELAPTIME                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function computes the difference  
*             between time one and time two.         
* Parameters: X  - Time one.                         
*             Y  - Time two.                         
*ͼ
PARAMETERS X, Y
PRIVATE  Time1, Time2, Z, Hrs, Min, Sec
Time1 = (VAL(SUBSTR(X,1,2)) * 3600) +;
        (VAL(SUBSTR(X,4,2)) * 60) + (VAL(SUBSTR(X,7)))
Time2 = (VAL(SUBSTR(Y,1,2)) * 3600) +;
        (VAL(SUBSTR(Y,4,2)) * 60) + (VAL(SUBSTR(Y,7)))
Z   =   ABS(Time1 - Time2)
Hrs =   INT(Z / 3600)
Min =   INT((Z - Hrs * 3600) / 60)
Sec =   Z - (Hrs * 3600) - (Min * 60)
RETURN (LTRIM(STR(Hrs,4,0) + ":" + STR(Min,2,0) + ":" + Str(Sec,2,0)))
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 14.87
A = NLen(X)
? A
X = -1314.87
A = NLen(X)
? A
* ...

FUNCTION NLEN
*ͻ
* Program...: NLEN                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns the length of a  
*             numeric field.                         
* Parameters: X  - The numeric field.                
*ͼ
PARAMETERS X
RETURN (LEN(ALLTRIM(STR(X))))
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 0
Y = " "
Z = CTOD("  /  /  ")
@ 12,12 GET X PICTURE "9" VALID AnyThing(X)
@ 13,12 GET Y PICTURE "!" VALID AnyThing(Y)
@ 14,12 GET Z             VALID AnyThing(Z)
READ
* ...

FUNCTION ANYTHING
*ͻ
* Program...: ANYTHING                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function returns a .F. if a data  
*             entry field contains blanks or a null. 
* Parameters: X  - The variable to check for a blank 
*                  or a null.                        
*ͼ
PARAMETERS X
IF EMPTY(X)
   RETURN(.F.)
ELSE
   RETURN(.T.)
ENDIF
************************************************************************
FUNCTION METFOOT
*ͻ
* Program...: METFOOT                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts meters to feet  
*             and feet to meters.                    
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
Meter_Foot  = 3.280833333
Foot_Meter  = 0.3048006096
FactorM     = Meter_Foot
FactorA     = Foot_Meter
Factor      = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = KmMile(X,"A")
? X
? NewValue
* ...

FUNCTION KMMILE
*ͻ
* Program...: KMMILE                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts kilometers to   
*             miles and miles to kilometers.         
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
KMeter_Miles = 0.6213699495
Miles_KMeter = 1.609347219
FactorM      = KMeter_Miles
FactorA      = Miles_KMeter
Factor       = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = KmMPH(X,"A")
? X
? NewValue
* ...

FUNCTION KMMPH
*ͻ
* Program...: KMMPH                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts kilometers per  
*             minute to miles per hour and miles per 
*             hour to kilometers per minute.         
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
KMetMin_MPH = 37.2822
MPH_KMetMin = 0.026822
FactorM     = KMetMin_MPH
FactorA     = MPH_KMetMin
Factor      = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = CentIn(X,"M")
? X
? NewValue
* ...

FUNCTION CENTIN
*ͻ
* Program...: CENTIN                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts centimeters to  
*             inches and inches to centimeters.      
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
Cm_Inch = 0.3937
Inch_Cm = 2.54000508
FactorM = Cm_Inch
FactorA = Inch_Cm
Factor  = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = KiloLbs(X,"M")
? X
? NewValue
* ...

FUNCTION KILOLBS
*ͻ
* Program...: KILOLBS                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts kilograms to    
*             pounds and pounds to kilograms.        
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
KGram_Lbs = 2.204622341
Lbs_KGram = 0.4535924277
FactorM   = KGram_Lbs
FactorA   = Lbs_KGram
Factor    = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = GramOz(X,"M")
? X
? NewValue
* ...

FUNCTION GRAMOZ
*ͻ
* Program...: GRAMOZ                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts grams to ounces 
*             and ounces to grams.                   
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
Gram_Oz = 0.0352739
Oz_Gram = 28.349527
FactorM = Gram_Oz
FactorA = Oz_Gram
Factor  = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = LiterGal(X,"M")
? X
? NewValue
* ...

FUNCTION LITERGAL
*ͻ
* Program...: LITERGAL                               
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts liters to       
*             gallons and gallons to liters.         
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
Liter_Gal = 0.219976
Gal_Liter = 3.78533
FactorM   = Liter_Gal
FactorA   = Gal_Liter
Factor    = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = CentF(X,"M")
? X
? NewValue
* ...

FUNCTION CENTF
*ͻ
* Program...: CENTF                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts centigrade to   
*             Fahrenheit and Fahrenheit to           
*             centigrade.                            
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
Centigrade = (F - 32) * 5 / 9
Fahrenheit = (C * 9 /5) + 32
FactorM    = Centigrade
FactorA    = Fahrenheit
Factor     = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = CalBTU(X,"A")
? X
? NewValue
* ...

FUNCTION CALBTU
*ͻ
* Program...: CALBTU                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts kilocalories to 
*             BTUs and BTUs to kilocalories.         
*             centigrade.                            
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
CalK_BTU = 3.9685
BTU_CalK = 0.025198
FactorM  = CalK_BTU
FactorA  = BTU_CalK
Factor   = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)

************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = JouCal(X,"A")
? X
? NewValue
* ...

FUNCTION JOLCAL
*ͻ
* Program...: JOLCAL                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts Joules to       
*             kilocalories and kilocalories to Joules
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
Joule_CalK = 0.00023918
CalK_Joule = 4186
FactorM    = Joule_CalK
FactorA    = CalK_Joule
Factor     = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = MetFrl(X,"A")
? X
? NewValue
* ...

FUNCTION METFRL
*ͻ
* Program...: METFRL                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts meters to       
*             furlongs and furlongs to meters.       
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
Meter_Furlng = 0.00497096
Furlng_Meter = 201.168
FactorM      = Meter_Furlng
FactorA      = Furlng_Meter
Factor       = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = MetFat(X,"A")
? X
? NewValue
* ...

FUNCTION METFAT
*ͻ
* Program...: METFAT                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts meters to       
*             fathoms and fathoms to meters.         
* Parameters: X  - The variable to be converted from 
*                  metric or American to the other.  
*             MA - "M" = convert to metric;          
*                  "A" = convert to American.        
*ͼ
PARAMETERS X, MA
PRIVATE    FactorM, FactorA, Factor
Meter_Fathom = 0.546806
Fathom_Meter = 1.828804
FactorM      = Meter_Fathom
FactorA      = Fathom_Meter
Factor       = IIF(UPPER(MA)="A", FactorM, FactorA)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = FatFt(X,1)
? X
? NewValue
* ...

FUNCTION FATFT
*ͻ
* Program...: FATFT                                  
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts fathoms to feet 
*             and feet to fathoms.                   
* Parameters: X  -  The variable to be converted     
*                   from one measure to the other.   
*             Ord - 1 Forward direction from title.  
*                   2 Reverse direction from title.  
*ͼ
PARAMETERS X, Ord
PRIVATE    FactorF, FactorB, Factor
Fathom_Ft = 6
Ft_Fathom = 1 / 6
FactorF   = Fathom_Ft
FactorB   = Ft_Fathom
Factor    = IIF(Ord=1, FactorF, FactorB)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = FurMile(X,1)
? X
? NewValue
* ...

FUNCTION FURMILE
*ͻ
* Program...: FURMILE                                
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts furlongs to     
*             miles and miles to furlongs.           
* Parameters: X  -  The variable to be converted     
*                   from one measure to the other.   
*             Ord - 1 Forward direction from title.  
*                   2 Reverse direction from title.  
*ͼ
PARAMETERS X, Ord
PRIVATE    FactorF, FactorB, Factor
Furlong_Mile = 0.125
Mile_Furlong = 8
FactorF      = Furlong_Mile
FactorB      = Mile_Furlong
Factor       = IIF(Ord=1, FactorF, FactorB)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = LCalHP(X,1)
? X
? NewValue
* ...

FUNCTION KCALHP
*ͻ
* Program...: KCALHP                                 
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts kilocalories to 
*             horsepower hours and horsepower hours  
*             to kilocalories.                       
* Parameters: X  -  The variable to be converted     
*                   from one measure to the other.   
*             Ord - 1 Forward direction from title.  
*                   2 Reverse direction from title.  
*ͼ
PARAMETERS X, Ord
PRIVATE    FactorF, FactorB, Factor
CalK_HPHrs = 0.0015593
HPHrs_CalK = 641.304
FactorF    = CalK_HPHrs
FactorB    = HPHrs_CalK
Factor     = IIF(Ord=1, FactorF, FactorB)
RETURN (X * Factor)
************************************************************************
* SAMPLE2
* ...
CLEAR
X = 1
NewValue = KWHP(X,1)
? X
? NewValue
* ...

FUNCTION KWHP
*ͻ
* Program...: KWHP                                   
* Author....: Phil Steele - President                
*             Phillipps Computer Systems Inc.        
* Address...: 52 Hook Mountain Road,                 
*             Montville NJ 07045                     
* Phone.....: (201) 575-8575                         
* Date......: 03/22/88                               
* Notice....: Copyright 1988  Philip Steele,         
*             All Rights Reserved.                   
* Notes.....: This function converts kilowatts to    
*             horsepower and horsepower to kilowatts.
* Parameters: X  -  The variable to be converted     
*                   from one measure to the other.   
*             Ord - 1 Forward direction from title.  
*                   2 Reverse direction from title.  
*ͼ
PARAMETERS X, Ord
PRIVATE    FactorF, FactorB, Factor
HP_KWatts = 0.74570
KWatts_HP = 1.3410
FactorF   = HP_KWatts
FactorB   = KWatts_HP
Factor    = IIF(Ord=1, FactorF, FactorB)
RETURN (X * Factor)
