* Program: Maklnk.prg
* Author:  F. Scott Barker
*          Associated Computer Specialists, Inc.
* Version: Clipper Summer '87
* Note(s): This program creates a rudimentary MAK and LNK
*          file, as is.  It works without overlays and
*          with Tlink. [Ed. note: You can link Clipper
*          applications with Borland's Turbo Link versions 1.0
*          and 1.1.  Version 2.0 will not work.]
*
*          This program takes the prg files listed in current dir
*          and with the given name creates the Make definition
*          file and LNK file.  If the name for the MAK file is not
*          found in the directory, it will asked for the main
*          program name.  This must be given for linking purposes.
*
PARAMETER mName
CLEAR
IF TYPE("mName") = [U]
   mName = SPACE(8)
   * Get name of make definition file to create.
   @ 10,5 SAY [Enter initials of system: ] GET mName PICT [@!]
   READ
   IF EMPTY(mName)           && If none entered go home.
      CLEAR
      RETURN
   ENDIF
ENDIF
mName = TRIM(mName)
makname = TRIM(mName) + [.MAK]
IF FILE(makname)             && Make sure MAK file is not
                             ** already there.
   mOver = .N.
   @ 12,5 SAY makname + [ Already exists, do you wish to ] +;
      [overwrite? ] GET mOver PICT [Y]
   READ
   IF ! mOver
      CLEAR
      RETURN
   ENDIF
ENDIF
prgcnt = ADIR("*.PRG")       && Get # of prog files in current
                             ** dir to include.

* Declare prg file array, # of sections there will be.
DECLARE aprg[prgcnt], mSTR[(prgcnt/6) + 1]
ADIR("*.PRG", aprg)          && Load and sort prg array.
ASORT(aprg)

* This next section puts the head program into the first position
* in the file array, if there is not a file matching mak def. name
* inputed, you will be prompted to name the head, or main calling
* program.
mNamePos = ASCAN(aprg, mName + [.PRG])
DO WHILE mNamePos = 0 .AND. LASTKEY() # 27
   mHead = SPACE(8)
   TONE(100,10)
   @ 14,5 SAY [Problem, you need to enter ] + ;
      [name of head program: ];
      GET mHead PICT [@!]
   READ
   mHead = TRIM(mHead)
   mNamePos = ASCAN(aprg ,mHead + [.PRG])
ENDDO
* If no calling program go home.
IF mNamePos = 0
   RETURN
ENDIF
* Actual movement to front of file array.
mTemp = aprg[1]
aprg[1] = aprg[mNamePos]
aprg[mNamePos] = mTemp

* Create file whatever.mak.
infile = FCREATE(makname)
* Init section counter.
sect = 1
* Init prgs per section counter.
numprgs = 0
* Init First section string.
mStr[sect] = [sect1 = ]

* This section writes the macros for OBJs.
FOR I = 1 TO prgcnt
   * This grabs the name for each file and
   * slaps OBJ on.
   mStr[sect] = mStr[sect] + ;
      SUBSTR(aprg[I],1,AT([.],aprg[I]))+[OBJ ]
   * If the maximum number of files per
   * section is reached, write it to disk and
   * init the next section.
   IF numprgs = 6  
      FWRITE(infile, TRIM(mStr[sect]) + ;
         CHR(13) + CHR(10))
      IF I = prgcnt
         EXIT
      ENDIF
      sect = sect + 1
      mStr[sect] = [sect]+STR(sect,1) + [ = ]
      numprgs = 1
   ENDIF
   * If all prgs are processed,
   * write last section.
   IF I = prgcnt
      FWRITE(infile, TRIM(mStr[sect]) + ;
         CHR(13) + CHR(10))
   ENDIF
   * Increment # of prgs per section.
   numprgs = numprgs + 1
NEXT

* Next section just writes a blank line, and
* the compile commands.
mTxt = CHR(13) + CHR(10)
FWRITE(infile, mTxt)
mTxt = ".prg.obj:" + CHR(13) + CHR(10)
FWRITE(infile, mTxt)
mTxt = "clipper $* -m -q" + CHR(13) + CHR(10)
FWRITE(infile, mTxt)
mTxt = "  if errorlevel 1 pause Error in " +;
   "compilation. Break and fix before " +;
   "continuing." + CHR(13) + CHR(10)
FWRITE(infile, mTxt)
mTxt = CHR(13) + CHR(10)
FWRITE(infile, mTxt)

* This section lists the prg to OBJ
* dependencies.
mTxt = [# PRG -> OBJ creation] + CHR(13) + ;
   CHR(10)
FOR I = 1 TO prgcnt
   mObj = SUBSTR(aprg[I],1,AT([.],aprg[I])) +;
      [OBJ]
   mTxt = mObj + SPACE(13-LEN(mObj)) + [: ] +;
      aprg[I] + CHR(13) + CHR(10)
   FWRITE(infile, mTxt)
NEXT
mTxt = CHR(13) + CHR(10)
FWRITE(infile, mTxt)
mTxt = [# .EXE file] + CHR(13) + CHR(10)
FWRITE(infile, mTxt)

* This section creates the exe -> section
* dependencies.  Tlink is used.
mTxt = mName + [.EXE :]
FOR I = 1 TO sect
   mTxt = mTxt + [ $(sect] + STR(I,1) + [)]
NEXT
mTxt = mTxt + CHR(13) + CHR(10)
FWRITE(infile, mTxt)
mTxt = [  break on] + CHR(13) + CHR(10)
FWRITE(infile, mTxt)
mTxt = [  tlink @] + mName + [.LNK] + ;
   CHR(13) + CHR(10)
FWRITE(infile, mTxt)
FCLOSE(makname)

* All done with the Mak file, time for the LNK
* file again, this is done with Tlink only.
lnkname = mName + [.LNK]

* Make sure LNK file is not already there.
IF FILE(lnkname)
   mOver = .N.
   @ 18,5 SAY lnkname + [ Already exists, ]+;
      [do you wish to overwrite? ];
      GET mOver PICT [Y]
   READ
   IF ! mOver
      CLEAR
      RETURN
   ENDIF
ENDIF
infile = FCREATE(lnkname)

* Time to list the files for linking.
FOR I = 1 TO sect
   mTxt = SUBSTR(mStr[I],9) + [ +] + ;
      CHR(13) + CHR(10)
   FWRITE(infile, mTxt)
NEXT

* Check to see if any other OBJ files are used
* and add them in.
mTxt = []
DO WHILE .T.
   mOther = SPACE(20)
   @ 20,5 SAY [Enter OBJ files with paths, ]+;
      [<CR> when done: ] GET mOther
   READ
   IF EMPTY(mOther)
      EXIT
   ENDIF
   mTxt = mTxt + TRIM(mOther) + [ ]
ENDDO

* Debug is added; you may want to alter.
mTxt = mTxt + [DEBUG.OBJ] + CHR(13) + CHR(10)
FWRITE(infile, mTxt)

* Check to see if any LIB files are used and
* add them in.
mLibTxt = []
DO WHILE .T.
   mOther = SPACE(20)
   @ 22,5 SAY [Enter lib files with paths, ]+;
      [<CR> when done: ] GET mOther
   READ
   IF EMPTY(mOther)
      EXIT
   ENDIF
   mLibTxt = mLibTxt + TRIM(mOther) + [ ]
ENDDO
mTxt = mName + [.EXE,,] + mLibTxt + CHR(13) +;
   CHR(10)
FWRITE(infile, mTxt)
FCLOSE(lnkname)
CLEAR
@ 1,0 SAY [Creation complete!]
RETURN
