* Program:     EditMemo.PRG
* Author:      Dennis L. Dias
* Modified by: Don L. Powells
* Version:     Clipper Summer '87
* Notes:       Example of MEMOEDIT() with a UDF.
* Copyright (c) 1987, 1988 Nantucket Corp.

PARAMETERS memofile

* If no file name was supplied on the command line use unnamed.
IF PCOUNT() < 1
	memofile = "unnamed"
ENDIF

* Initialize variables and parameters
prev_memo = ""    && Last memo file edited.
ret_val = 0       && Return value sent to MEMOEDIT().
deja_vu = .F.     && "Been here before" flag for init process.
eresume = .F.     && Resume editing after Alt-W file write.
altered = .F.     && Memofile has been altered.

t = 0
l = 0
b = 23
r = 79
update = .T.
browse = .T.
line_length = 132
use_func = .T.
ufunc = "mfunc"
ins_on = .F.
scrl_on = .F.
word_wrap = .F.
tabsize = 4

SET BELL ON
SET SCOREBOARD OFF

* Continue editing until user exits or a Disk Write Error occurs.
mexit = .F.
DO WHILE !mexit
   BEGIN SEQUENCE
      IF !eresume
         Config()
         IF LASTKEY() = 27
            @ b + 1, 79 SAY ""
            mexit =.T.
            BREAK
         ENDIF
         IF use_func
            ufunc = "mfunc"
            SET SCOREBOARD OFF
         ELSE
         IF browse
            ufunc = ""
         ELSE
            ufunc = .F.
         ENDIF
         IF t = 0
            SET SCOREBOARD OFF
         ELSE
            SET SCOREBOARD ON
         ENDIF
      ENDIF
      IF !(prev_memo == memofile)
         memofile = IIF(EMPTY(memofile),"unnamed",memofile)
         usr_memo = MEMOREAD(memofile)
         prev_memo = memofile
         line_num = 1
         col_num = 0
         rel_row = 0
         rel_col = 0
         altered = .F.
      ENDIF

      * User messages may start at the leftmost column and end
      *   five spaces before the 'Line:' status message.
      msg_len = r - l - 25

      * Draw screen constants
      CLEAR SCREEN
      @ t, l, b, r BOX "͸Գ"
      Saycenter(b,"<F1>: Key Reference")
      @ b + 1, l SAY pad(LOWER(memofile), msg_len)
   ENDIF

   init_count = 1
   deja_vu = .F.
   eresume = .F.

   usr_memo = MEMOEDIT(usr_memo, t + 1, l + 1, b - 1, r - 1,;
                  update, ufunc,line_length, tabsize,;
                  line_num, col_num, rel_row, rel_col)

   IF !memofile == "unnamed" .AND. !EMPTY(usr_memo) .AND.;
                  ret_val = 23
      altered = .F.
      IF !MEMOWRIT(memofile, usr_memo)
         SET COLOR TO w*+
         @ 24,79 SAY ""
         ? "DISK WRITE ERROR"
         SET COLOR TO
         CLOSE DATABASES
         mexit = .T.
         BREAK
      ENDIF
      @ b + 1, l SAY pad("Write successful.", msg_len)
   ENDIF
   END
ENDDO


*****
* Mfunc() - MEMOEDIT user function
*
*	

FUNCTION Mfunc

   PARAMETERS mstatus, line, col
   PRIVATE keypress

   ret_val = 0

   IF mstatus = 3
      * Initialization
      ret_val = InitStat()
   ELSEIF mstatus = 0
      * Idle status
      request = IdleStat()
   ELSE
      * Keystroke exception
      request = Keyexcep()
ENDIF
RETURN(ret_val)

*****
* Pad()
*
* pad with spaces

FUNCTION Pad

PARAMETERS string, length
RETURN SUBSTR(string + SPACE(length), 1, length)

*****
* Config() - set parameters for simulation
*
*	

FUNCTION Config

memofile = pad(memofile, 64)
CLEAR SCREEN

Saycenter(1,"CLIPPER TRAINING")
Saycenter(2,"MEMOEDIT() DEMO")
@ 3,0 SAY REPLICATE("",80)

@ 5, 0 SAY "File To Edit_" GET memofile PICTURE "@K"
Saycenter(4,"<PgDn>: Accept configuration  <ESC>: Exit to DOS")
@ 8, 0 SAY "Window Coordinates:"
@ 9, 5 SAY "Top_____________________" GET t
@ 10, 5 SAY "Left____________________" GET l
@ 11, 5 SAY "Bottom__________________" GET b
@ 12, 5 SAY "Right___________________" GET r

@ 14, 5 SAY "Line Length (memowidth)_" GET line_length
@ 15, 5 SAY "Tab Size________________" GET tabsize

@ 17, 5 SAY "Allow Updates [yn]______" GET update
@ 18, 5 SAY "Allow Browse [yn]_______" GET browse
@ 19, 5 SAY "Use User Function [yn]__" GET use_func

@ 21, 5 SAY "Insert Mode On [yn]_____" GET ins_on
@ 22, 5 SAY "Scroll State On [yn]____" GET scrl_on
@ 23, 5 SAY "Word Wrap On [yn]_______" GET word_wrap
READ

memofile = ALLTRIM(memofile)
RETURN(.T.)

*****
* InitStat() - Initialization routine for MEMOEDIT()
*

FUNCTION InitStat
   * Initialization..global variables "init_count" and "deja_vu"
   * control the initialization process..note that this is
   * much simpler when the parameters passed to MEMOEDIT
   * are known in advance (which is usually true).

   IF init_count = 1
      * set initial insert mode
      ins_mode = READINSERT()
      IF (ins_on .AND. !ins_mode) .OR.;
           (!ins_on .AND. ins_mode)
         * toggle insert mode
         ret_val = 22
      ELSE
         * insert mode correct
         init_count = 2
         @ b + 1, r - 25 SAY IF(ins_on, "I", " ")
      ENDIF
   ENDIF

   IF init_count = 2
      * set initial scroll state (defaults ON if update OFF)
      IF ((!scrl_on .AND. !update) .OR.;
            (scrl_on .AND. update)) .AND. !deja_vu
         * need to toggle
         deja_vu = .T.
         ret_val = 35
      ELSE
         * scroll state correct
         init_count = 3
         deja_vu = .F.
         @ b + 1, r - 24 SAY IF(scrl_on, "S", " ")
      ENDIF
   ENDIF

   IF init_count = 3
      * set initial word wrap..always defaults ON

      IF !word_wrap .AND. !deja_vu
         * need to toggle
         deja_vu = .T.
         ret_val = 34
      ELSE
         * word wrap correct
         init_count = 4
         deja_vu = .F.
         @ b + 1, r - 23 SAY IF(word_wrap, "W", " ")
      ENDIF
   ENDIF

   IF init_count = 4
      * Finished initialization..note that if all defaults are
      * correct we reach this point on the first call.
      ret_val = 0
   ENDIF
RETURN(ret_val)

*****
* IdleStat() - Process Idle status of MEMOEDIT()
*

FUNCTION IdleStat
   * Update Line and Col values
   @ b + 1, r - 20 SAY "Line: " + pad(LTRIM(STR(line)), 4)
   @ b + 1, r - 8 SAY "Col: " + pad(LTRIM(STR(col)), 3)
RETURN(0)

*****
* Keyexcep() - Process keystroke exceptions for MEMOEDIT()
*

FUNCTION Keyexcep
   keypress = LASTKEY()

   * save values to possibly resume edit
   line_num = line
   col_num = col
   rel_row = ROW() - t - 1
   rel_col = COL() - l - 1

   IF mstatus = 2
      altered = .T.
   ENDIF

   IF keypress = 23
      * ^W..ignore (disable)
      ret_val = 32
   ELSEIF keypress = 273
      * Alt-W..write file
      IF !altered
         * no changes to write
         @ b + 1, l SAY pad("No changes to write.", msg_len)
      ELSE
         * write and resume
         @ b + 1, l SAY SPACE(msg_len)
         @ b + 1, l SAY "Writing " + LOWER(memofile) + "..."
         ret_val = 23
         eresume = .T.
      ENDIF

   ELSEIF keypress = 301 .OR. keypress = 27
      * Esc/Alt-X..exit
      IF !altered
         * no change
         ret_val = 27
      ELSE
         * changes have been made to memo
         @ b + 1, l SAY SPACE(msg_len)
         @ b + 1, l SAY "Abandon [ynw]? "

         response = " "
         DO WHILE !response $ "YNW"
            response = UPPER(CHR(INKEY(0)))
         ENDDO
         @ b + 1, l SAY SPACE(msg_len)
         IF response = "Y"
            * abort
            ret_val = 27
         ELSEIF response = "N"
            * ignore
            ret_val = 32
         ELSEIF response = "W"
            * save and exit
            @ b + 1, l SAY SPACE(msg_len)
            @ b + 1, l SAY "Writing " + LOWER(memofile)+"..."
            ret_val = 23
         ENDIF
      ENDIF
   ELSEIF keypress = 289
      * Alt-F..display file name
      @ b + 1, l SAY pad(LOWER(memofile), msg_len)
   ELSEIF keypress = 28
      * F1..key reference
      ret_val = Key_ref()
   ELSEIF keypress = -2
      * F3..delete line
      ret_val = 25
   ELSEIF keypress = -3
      * F4..insert line
      ret_val = 14
   ELSEIF keypress = -4 .AND. update
      * F5..toggle word wrap
      word_wrap = !word_wrap
      @ b + 1, r - 23 SAY IF(word_wrap, "W", " ")
      ret_val = 34
   ELSEIF keypress = -5
      * F6..toggle scroll lock
      scrl_on = !scrl_on
      @ b + 1, r - 24 SAY IF(scrl_on, "S", " ")
      ret_val = 35
   ELSEIF keypress = -6
      * F7..insert a form feed in the text
      KEYBOARD CHR(12)
      ret_val = 32
   ELSEIF (keypress = 279 .OR. keypress = 22) .AND. update
      * ^V/Ins/Alt-I..toggle insert mode
      ins_on = !ins_on
      @ b + 1, r - 25 SAY IF(ins_on, "I", " ")
      ret_val = 22
   ENDIF
RETURN(ret_val)

*****
* Key_ref() - Key Reference Chart
*

FUNCTION Key_ref
   PRIVATE mrow,mcol,ref_scrn
   ref_scrn = SAVESCREEN(4,22,20,59)
   @ 4,22 TO 18,59 DOUBLE
   @ 4,24 SAY "Key Reference"
   @ 18,24 SAY "Press <ESC> when done."
   mrow = 6
   mcol = 24
   SET CURSOR OFF
   @ mrow,mcol SAY "^W..ignore (disable)"
   @ ROW() + 1, mcol SAY  "Alt-W..write file"
   @ ROW() + 1, mcol SAY  "Esc/Alt-X..exit"
   @ ROW() + 1, mcol SAY  "Alt-F..display file name"
   @ ROW() + 1, mcol SAY  "F1..key reference"
   @ ROW() + 1, mcol SAY  "F3..delete line"
   @ ROW() + 1, mcol SAY  "F4..insert line"
   @ ROW() + 1, mcol SAY  "F5..toggle word wrap"
   @ ROW() + 1, mcol SAY  "F6..toggle scroll lock"
   @ ROW() + 1, mcol SAY  "F7..insert a form feed in the text"
   @ ROW() + 1, mcol SAY  "^V/Ins/Alt-I..toggle insert mode"
   INKEY(0)
   SET CURSOR ON
   RESTSCREEN(4,22,20,59,ref_scrn)
RETURN(0)

*****
* Saycenter() - Function to center a string on a given row.
* Usage: Saycenter(row#,expC)
*

FUNCTION Saycenter
   PARAMETERS trow,in_string
   IF LEN(in_string)>=80
      @ trow,0 SAY in_string
   ELSE
      @ trow,(80 - LEN(in_string))/2 SAY in_string
   ENDIF
RETURN (.T.)
