Version 1.00
BEGIN Form frmDisplay
	AutoRedraw   = -1
	BackColor    = QBColor(7)
	BorderStyle  = 5
	Caption      = "Molar Mass"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(25)
	Left         = Char(14)
	MaxButton    = 0
	MinButton    = 0
	MousePointer = 0
	Tag          = ""
	Top          = Char(2)
	Visible      = -1
	Width        = Char(64)
	WindowState  = 0
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 0
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 8
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 1
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 10
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 2
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 12
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 3
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 14
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 4
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 16
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(10)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 5
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 18
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(12)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 6
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 20
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(14)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 7
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 22
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(16)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 8
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 24
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(18)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 9
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 26
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(20)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN Label lblHeading
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&Element Number       Percent         Atomic Mass"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 6
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(48)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 0
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 7
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 1
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 9
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 2
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 11
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 3
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 13
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 4
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 15
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(10)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 5
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 17
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(12)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 6
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 19
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(14)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 7
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 21
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(16)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 8
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 23
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(18)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 9
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 25
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(20)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN CommandButton cmdClear
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&Clear"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(65)
		MousePointer = 0
		TabIndex     = 2
		TabStop      = -1
		Tag          = ""
		Top          = Char(14)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN CommandButton cmdExit
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "E&xit"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(65)
		MousePointer = 0
		TabIndex     = 4
		TabStop      = -1
		Tag          = ""
		Top          = Char(20)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN Label lblMolarMass
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "Molar Mass:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(19)
		MousePointer = 0
		TabIndex     = 5
		Tag          = ""
		Top          = Char(22)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN CommandButton cmdMore
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&More"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(65)
		MousePointer = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = ""
		Top          = Char(11)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN CommandButton cmdPrint
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&Print"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(65)
		MousePointer = 0
		TabIndex     = 0
		TabStop      = -1
		Tag          = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN CommandButton cmdAbout
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&About..."
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(65)
		MousePointer = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Top          = Char(17)
		Visible      = -1
		Width        = Char(12)
	END
END
DECLARE SUB txtElement_DragOver (Index AS INTEGER, Source AS CONTROL, X AS SINGLE, Y AS SINGLE, State AS INTEGER)
DECLARE SUB cmdMore_Click ()
'$FORM frmAbout
DECLARE SUB NumberFormat (BYVAL Number AS DOUBLE, BYVAL dStdDev AS DOUBLE, BYVAL TabStop!, srMsg AS STRING, rPrintX AS INTEGER)
DECLARE SUB Initialize_Form ()
DECLARE SUB Calculate ()
DECLARE SUB PeriodicTable (sSymbol AS STRING, AtomicMass AS DOUBLE, Uncertainty AS SINGLE)
OPTION EXPLICIT
DEFINT A-Z

DIM SHARED sSymbol(29) AS STRING * 3    ' Symbol of each atom
DIM SHARED dMassElement(29) AS DOUBLE
DIM SHARED fStdDevElement(29) AS SINGLE
DIM SHARED lNumberOfAtoms(29) AS LONG
DIM SHARED Variance(29) AS SINGLE   ' These two are only used in Calculate,
DIM SHARED dMassOfAtoms(29) AS DOUBLE  ' but for compatability with VB for Windows, arrays are placed in the main module.
DIM SHARED mbNonContinuedLine
DIM SHARED mMolarMassPositionY
DIM SHARED mMaxIndex
DIM SHARED msOriginalText AS STRING
DIM SHARED mIntDecimal AS STRING * 1
DIM SHARED mIntComma AS STRING * 1

CONST TRUE = -1
CONST FALSE = 0
CONST TITLEBAR_BACKCOLOR = 16
CONST MAGENTA = 5
CONST YELLOW = 14
CONST CYAN = 3
CONST BRIGHT_CYAN = 11
CONST DESKTOP_PATTERN = 7               ' Desktop fill pattern (ASCII 0-255).

CONST KEY_RETURN = 13           ' Enter key
CONST KEY_ESCAPE = 27
CONST KEY_UP = 38
CONST KEY_DOWN = 40
CONST KEY_BACK = 8
CONST KEY_DELETE = 127          ' Delete key returns 46 in Visual Basic for Windows.

CONST ENTER = 0
CONST LEAVE = 1

' Calculates % Comp., molar mass, and displays results by calling
' NumberFormat.
SUB Calculate ()

DIM dMolarMass AS DOUBLE
DIM N AS INTEGER
DIM fStdDev AS SINGLE
DIM dVarianceTotal AS DOUBLE
DIM dPercent AS DOUBLE
DIM fStdDevPercent AS SINGLE
DIM Decimal
DIM bNonZero
DIM sMsg AS STRING
DIM PrintX

   FOR N = 0 TO mMaxIndex
      IF sSymbol(N) <> "   " AND lNumberOfAtoms(N) > 0 THEN
         dMassOfAtoms(N) = dMassElement(N) * lNumberOfAtoms(N)
         Variance(N) = fStdDevElement(N) * fStdDevElement(N) * lNumberOfAtoms(N) * lNumberOfAtoms(N)
         dMolarMass = dMassOfAtoms(N) + dMolarMass
         dVarianceTotal = dVarianceTotal + Variance(N)
         bNonZero = TRUE   ' If all entries are "" or 0 then don't calculate.
      END IF
   NEXT N
   ' **************************** Output *************************************
   CLS
   IF bNonZero = TRUE THEN
      ' Go ahead and print to screen.
      FOR N = 0 TO mMaxIndex
         IF sSymbol(N) <> "   " AND lNumberOfAtoms(N) > 0 THEN
            IF mMaxIndex > 10 THEN
               CurrentY = 2 + N + N \ 5
            ELSE
               CurrentY = 2 + 2 * N
            END IF

            ' ***************** Percent ********************
            dPercent = dMassOfAtoms(N) / dMolarMass * 100
            IF dPercent = 100 THEN
               PrintX = 23
               sMsg = "100"
            ELSE
               fStdDevPercent = dPercent * SQR(Variance(N) / dMassOfAtoms(N) / dMassOfAtoms(N) + dVarianceTotal / dMolarMass / dMolarMass)
               NumberFormat dPercent, fStdDevPercent, 18, sMsg, PrintX
            END IF
            CurrentX = PrintX
            PRINT sMsg;


            ' ***************** Atomic Mass *********************
            NumberFormat dMassElement(N), fStdDevElement(N), 36, sMsg, PrintX
            CurrentX = PrintX
            PRINT sMsg;
         END IF
      NEXT N

      ' **************  Molar mass ******************
      NumberFormat dMolarMass, SQR(dVarianceTotal), 36, sMsg, PrintX
      CurrentX = PrintX
      CurrentY = mMolarMassPositionY
      PRINT sMsg;
   END IF

END SUB

SUB cmdAbout_Click ()
   DIM Index
   frmAbout.SHOW 1
   Index = VAL(frmDisplay.Tag)
   IF Index >= 0 THEN
      txtElement(Index).SETFOCUS
   ELSE
      txtNumber(-Index - 1).SETFOCUS
   END IF
END SUB

SUB cmdClear_Click ()
   CLS
   Initialize_Form
   txtElement(0).SETFOCUS
END SUB

SUB cmdExit_Click ()
   END
END SUB

' Changes from 25 to 43 lines on the screen, and back.
SUB cmdMore_Click ()
   DIM N
   DIM saveElement AS STRING
   DIM saveNumber AS STRING
   DIM Index
   DIM BlankLine
   frmDisplay.HIDE
   Index = VAL(frmDisplay.Tag)
   IF cmdMore.Caption = "&More" THEN
      ON LOCAL ERROR GOTO ManyLinesError
      WIDTH 80, 43
      ON LOCAL ERROR GOTO 0
      cmdMore.Caption = "&Less"
      saveElement = txtElement(0).Text
      txtElement(0).Text = ""
      txtElement(0).BackColor = BRIGHT_CYAN
      saveNumber = txtNumber(0).Text
      txtNumber(0).Text = "1"
      txtNumber(0).BackColor = CYAN
      FOR N = 1 TO 9
         BlankLine = N \ 5
         txtElement(N).Top = N + 2 + BlankLine
         txtNumber(N).Top = N + 2 + BlankLine
      NEXT N
      FOR N = 10 TO 29
         BlankLine = N \ 5
         LOAD txtElement(N)
         txtElement(N).Top = N + 2 + BlankLine
         txtElement(N).Visible = TRUE

         LOAD txtNumber(N)
         txtNumber(N).Top = N + 2 + BlankLine
         txtNumber(N).Visible = TRUE
         'txtNumber(N).Text = "1"

         ' Initialize arrays.
         sSymbol(N) = ""
         lNumberOfAtoms(N) = 1
      NEXT N
      txtElement(0).Text = saveElement
      txtNumber(0).Text = saveNumber
      mMaxIndex = 29
      mMolarMassPositionY = 39
      lblMolarMass.Top = mMolarMassPositionY
      cmdPrint.Top = 26
      cmdMore.Top = 29
      cmdClear.Top = 32
      cmdAbout.Top = 35
      cmdExit.Top = 38
      frmDisplay.CLS
      frmDisplay.SHOW
      IF Index >= 0 THEN
         txtElement(Index).SETFOCUS
      ELSE
         txtNumber(-Index - 1).SETFOCUS
      END IF
   ELSE
      cmdMore.Caption = "&More"
      FOR N = 10 TO 29
         UNLOAD txtElement(N)
         UNLOAD txtNumber(N)
      NEXT N
      WIDTH 80, 25
      FOR N = 1 TO 9
         txtElement(N).Top = 2 * N + 2
         txtNumber(N).Top = 2 * N + 2
      NEXT N
      mMaxIndex = 9
      mMolarMassPositionY = 22
      lblMolarMass.Top = mMolarMassPositionY
      cmdPrint.Top = 8
      cmdMore.Top = 11
      cmdClear.Top = 14
      cmdAbout.Top = 17
      cmdExit.Top = 20
      frmDisplay.CLS
      frmDisplay.SHOW
      IF Index < 10 AND Index > -11 THEN
         IF Index >= 0 THEN
            txtElement(Index).SETFOCUS
         ELSE
            txtNumber(-Index - 1).SETFOCUS
         END IF
      ELSE
         txtElement(0).SETFOCUS
      END IF
   END IF
   Calculate   ' Can't print to form that's not showing.
   EXIT SUB

ManyLinesError:
   WIDTH 80, 25
   cmdMore.Visible = FALSE
   frmDisplay.SHOW
   txtElement(0).SETFOCUS
   MSGBOX "Your computer does not support 43 lines on the screen.", 0, "More Button"
   EXIT SUB

END SUB

' Prints the results showing on the screen, if any.  Calls NumberFormat
SUB cmdPrint_Click ()

DIM dMolarMass AS DOUBLE
DIM N AS INTEGER
DIM dAtomicMass AS DOUBLE
DIM fStdDev AS SINGLE
DIM dVarianceTotal AS DOUBLE
DIM dPercent AS DOUBLE
DIM fStdDevPercent AS SINGLE
DIM Decimal
DIM bNonZero
DIM sMsg AS STRING
DIM PrintX
DIM SecondCol
DIM Index

ON LOCAL ERROR GOTO PrinterError
   FOR N = 0 TO mMaxIndex
      IF sSymbol(N) <> "   " AND lNumberOfAtoms(N) > 0 THEN
         dMassOfAtoms(N) = dMassElement(N) * lNumberOfAtoms(N)
         Variance(N) = fStdDevElement(N) * fStdDevElement(N) * lNumberOfAtoms(N) * lNumberOfAtoms(N)
         dMolarMass = dMassOfAtoms(N) + dMolarMass
         dVarianceTotal = dVarianceTotal + Variance(N)
         bNonZero = TRUE   ' If all entries are "" or 0 then don't calculate.
      END IF
   NEXT N
   ' **************************** Output *************************************
   IF bNonZero = TRUE THEN

      Printer.PRINT "Element    Number     % Composition     Atomic Mass"
      Printer.PRINT "_______  __________  _______________   ______________"
      FOR N = 0 TO mMaxIndex
         IF sSymbol(N) <> "   " AND lNumberOfAtoms(N) > 0 THEN
            Printer.PRINT "  "; sSymbol(N); TAB(9); lNumberOfAtoms(N);

            ' ***************** Percent ********************
            dPercent = dMassOfAtoms(N) / dMolarMass * 100
            IF dPercent = 100 THEN
               PrintX = 27
               sMsg = "100"
            ELSE
               fStdDevPercent = dPercent * SQR(Variance(N) / dMassOfAtoms(N) / dMassOfAtoms(N) + dVarianceTotal / dMolarMass / dMolarMass)
               NumberFormat dPercent, fStdDevPercent, 21, sMsg, PrintX
            END IF
            Printer.PRINT TAB(PrintX); sMsg;

            ' ***************** Atomic Mass *********************
            NumberFormat dMassElement(N), fStdDevElement(N), 40, sMsg, PrintX
            Printer.PRINT TAB(PrintX); sMsg
         END IF
      NEXT N

      ' **************  Molar mass ******************
      Printer.PRINT
      Printer.PRINT SPC(21); "Molar Mass:";
      NumberFormat dMolarMass, SQR(dVarianceTotal), 40, sMsg, PrintX
      Printer.PRINT TAB(PrintX); sMsg
      Printer.PRINT
      Printer.PRINT
      Printer.ENDDOC
   END IF
   Index = VAL(frmDisplay.Tag)
   IF Index >= 0 THEN
      txtElement(Index).SETFOCUS
   ELSE
      txtNumber(-Index - 1).SETFOCUS
   END IF
EXIT SUB

PrinterError:
   MSGBOX "There was a problem printing to your printer.", 0, "Printing"
   EXIT SUB

END SUB

SUB Form_Load ()
   DIM sTemp AS STRING
   sTemp = FORMAT$(1234.5, "0,000.0")
   mIntComma = MID$(sTemp, 2)
   mIntDecimal = MID$(sTemp, 6)

   Screen.ControlPanel(TITLEBAR_BACKCOLOR) = MAGENTA
   Screen.ControlPanel(DESKTOP_PATTERN) = 32 ' (space)
   WindowState = 2   ' Maximized.
   mMolarMassPositionY = 22
   mMaxIndex = 9
   Initialize_Form
   IF Screen.Height >= 43 THEN cmdMore_Click
   frmDisplay.SHOW   ' Because can't set focus to hidden control.
   txtElement(0).SETFOCUS
END SUB

' Displays introductory information on the form, and initializes some arrays.
SUB Initialize_Form ()
   DIM N
   IF mMaxIndex = 9 THEN
      ' Display some directions.
      CurrentY = 2
      PRINT TAB(20); "The field changes automatically.  Try entering ""h2o2"";"
      PRINT TAB(25); "notice that you MUST then move to another field."
      CurrentY = 5
      PRINT TAB(20); "To move around:"
      PRINT TAB(20); "Enter            next element"
      PRINT TAB(20); "Tab              next field"
      PRINT TAB(20); "Shift-Tab        previous field"
      PRINT TAB(20); "Up/Down-Arrow    up/down one field"
      PRINT TAB(20); "Alt-E            first element"
      PRINT
      PRINT TAB(25); "Abbreviations:"
      PRINT TAB(25); "Me     CH3       Gly    -COCH(H)NH-"
      PRINT TAB(25); "Et     C2H5      Cys    -COCH(CH2SH)NH-"
      PRINT TAB(25); "Bu     C4H9      Side chains of all"
      PRINT TAB(25); "Pn     C5H11     amino acids are in "
      PRINT TAB(25); "Hx     C6H13     neutral form, e.g.,"
      PRINT TAB(25); "cH     C6H11     Asp    -COCH(CH2CO2H)NH-"
      PRINT TAB(25); "Ph     C6H5"
      PRINT TAB(25); "cP     C5H5"
   END IF
   FOR N = 0 TO mMaxIndex
      txtElement(N).Text = ""
      txtNumber(N).Text = "1"
      sSymbol(N) = ""
      lNumberOfAtoms(N) = 1
   NEXT N
END SUB

DEFSNG A-Z
' Prints a number, such as 1.00756463, having a variance, such as .0002,
' as 1.0076(2).  Prints large numbers, such as 1543423122, having a variance
' of 200, as 1.54341(2)E9.  Prints small numbers, such as .0000456384823(2),
' as 4.56384823(2)E-5.
'     Input:
'        Number      Number to be formatted
'        dStdDev     Standard deviation of number
'        TabStop     Where printing is desired to begin
'     Output:
'        srMsg       Formatted string to print
'        rPrintX     Where printing should begin so decimals line up
SUB NumberFormat (BYVAL Number AS DOUBLE, BYVAL dStdDev AS DOUBLE, BYVAL TabStop, srMsg AS STRING, rPrintX AS INTEGER)
' dStdDev needs to be double to handle small decimals; fStdDev is automatically
' converted to double in a statement like:
' NumberFormat Number, dStdDev, TabStop, srMsg, rPrintX
   DIM sNumber AS STRING, sStdDev AS STRING
   DIM DecimalStdDev, DecimalNumber, Zero, LastZero

   ' How to print the number depends on whether the rounded uncertainty
   ' is greater or less than 1.

   IF dStdDev < .0000000095# THEN
      ' To conserve space, exponential notation is needed.
      ' ********************* Negative exponential format ******************
      sStdDev = FORMAT$(dStdDev, "0E+#0")
      IF MID$(sStdDev, 2, 1) = "0" THEN
         ' A bug with format$:  9.8E-5 is rounded to 10E-5, not 1E-4.
         sStdDev = "1E" + FORMAT$(VAL(MID$(sStdDev, 4)) + 1)
      END IF
      ' sStdDev is now something like "8E-9"
      srMsg = "(" + LEFT$(sStdDev, 1) + ")E-"
      DecimalStdDev = VAL(MID$(sStdDev, 4))   ' No negative sign on exponent.
      sNumber = FORMAT$(Number, "0.000000000E+#0")
      DecimalNumber = VAL(MID$(sNumber, 14))
      IF VAL(MID$(sNumber, DecimalNumber + DecimalStdDev - 1, 1)) > 4 THEN
         Number = Number + 1# * 10 ^ -DecimalStdDev
         sNumber = FORMAT$(Number, "0.000000000E+#0")
         DecimalNumber = VAL(MID$(sNumber, 14))
      END IF
      srMsg = srMsg + MID$(sNumber, 14)
      sNumber = LEFT$(sNumber, DecimalStdDev - DecimalNumber + 2)
      srMsg = sNumber + srMsg
      rPrintX = TabStop + 1
   ELSEIF dStdDev < .95 THEN
      ' ******************* Non-exponential format, < 1 *******************
      ' Find the first non-zero character after the decimal in sStdDev.
      sStdDev = FORMAT$(dStdDev, "0.00000000000")
      LastZero = 2
      DO
         Zero = INSTR(LastZero + 1, sStdDev, "0")
         IF Zero > LastZero + 1 OR Zero = 0 THEN
            EXIT DO
         ELSE
            LastZero = Zero
         END IF
      LOOP

      ' Round dStdDev
      IF VAL(MID$(sStdDev, LastZero + 2, 1)) > 4 THEN
         dStdDev = dStdDev + 1 * 10 ^ -(LastZero - 1)
         ' If this caused, say, .00095 to be rounded to .0010, then
         ' display 1 less digit in Number:
         sStdDev = FORMAT$(dStdDev, "0.00000000000")
         IF MID$(sStdDev, LastZero, 1) = "1" THEN
            LastZero = LastZero - 1
         END IF
      END IF

      ' Get the digit in  representing uncertainty in the last digit of number.
      sStdDev = MID$(sStdDev, LastZero + 1, 1)

      ' Round Number
      sNumber = FORMAT$(Number, "0.00000000000")
      DecimalNumber = INSTR(2, sNumber, mIntDecimal)
      IF VAL(MID$(sNumber, DecimalNumber + LastZero, 1)) > 4 THEN
         Number = Number + 1# * 10 ^ -(LastZero - 1)
      END IF
      sNumber = FORMAT$(Number, "0.00000000000")
      DecimalNumber = INSTR(2, sNumber, mIntDecimal)
      srMsg = LEFT$(sNumber, DecimalNumber + LastZero - 1)
      rPrintX = TabStop + 4 - DecimalNumber
      srMsg = srMsg + "(" + sStdDev + ")"
   ELSEIF dStdDev < 9.5 THEN
      ' ******************** Non-exponential format, > 1 ******************
      ' Uncertainty is at least 1 and less than 10.
      sStdDev = FORMAT$(dStdDev, "0.00000")

      ' Round dStdDev
      IF VAL(MID$(sStdDev, 3, 1)) > 4 THEN
         dStdDev = dStdDev + 1
         sStdDev = FORMAT$(dStdDev, "0.00000")
      END IF

      ' Get the digit representing uncertainty.
      sStdDev = "(" + MID$(sStdDev, LastZero + 1, 1) + ")"

      ' Round Number
      sNumber = FORMAT$(Number, "0.000")
      DecimalNumber = INSTR(2, sNumber, mIntDecimal)
      IF VAL(MID$(sNumber, DecimalNumber + 1, 1)) > 4 THEN
         Number = Number + 1
      END IF
      sNumber = FORMAT$(Number, "0.000")
      DecimalNumber = INSTR(2, sNumber, mIntDecimal)
      srMsg = LEFT$(sNumber, DecimalNumber - 1)
      rPrintX = TabStop + 4 - DecimalNumber
      srMsg = srMsg + sStdDev
   ELSE
      ' ****************** The exponential format *************************
      ' Round standard deviation.
      sStdDev = FORMAT$(dStdDev, "#########.0000")
      DecimalStdDev = INSTR(sStdDev, mIntDecimal)
      IF DecimalStdDev = 1 THEN
         ' dStdDev is between .95 and .9999999..., which rounds to 1
         DecimalStdDev = 2
         sStdDev = "1"
      ELSEIF DecimalStdDev = 2 THEN
         ' dStdDev is something like 9.9 or 4.3
         IF VAL(MID$(sStdDev, 3, 1)) > 4 THEN
            ' Round up
            dStdDev = dStdDev + 1
            sStdDev = FORMAT$(dStdDev, "#########.0#")
            DecimalStdDev = INSTR(sStdDev, mIntDecimal)
         END IF
         sStdDev = LEFT$(sStdDev, 1)
      ELSE  ' DecimalStdDev > 2
         IF VAL(MID$(sStdDev, 2, 1)) > 4 THEN
            ' Round up
            dStdDev = dStdDev + 1 * 10 ^ (DecimalStdDev - 2)
            sStdDev = FORMAT$(dStdDev, "#########.0#")
            DecimalStdDev = INSTR(sStdDev, mIntDecimal)
         END IF
         sStdDev = LEFT$(sStdDev, 1)
      END IF

      ' Round the Number.
      '  Number= 1493924775.3   Decimal in Number = 11
      '  StdDev=      23493.01  Decimal in StdDev = 6
      sNumber = FORMAT$(Number, "#############.0")
      DecimalNumber = INSTR(3, sNumber, mIntDecimal)
      IF DecimalStdDev = 2 THEN
         ' Round the number if use number after the decimal place.
         '  Number= 24775.3   Decimal in Number = 11
         '  StdDev=     3.01  Decimal in StdDev = 6
         IF VAL(MID$(sNumber, DecimalNumber - DecimalStdDev + 2, 1)) > 4 THEN
            Number = Number + 10 ^ (DecimalStdDev - 1)
         END IF
      ELSE
         IF VAL(MID$(sNumber, DecimalNumber - DecimalStdDev + 1, 1)) > 4 THEN
            Number = Number + 10 ^ (DecimalStdDev - 2)
         END IF
      END IF

      ' Compose the string to print.
      sNumber = FORMAT$(Number, "#############.")
      ' Rounding could have changed 99. to 100., so relocate the decimal.
      DecimalNumber = INSTR(3, sNumber, mIntDecimal)
      srMsg = LEFT$(sNumber, 1) + mIntDecimal
      srMsg = srMsg + MID$(sNumber, 2, DecimalNumber - DecimalStdDev)
      srMsg = srMsg + "(" + sStdDev + ")E" + FORMAT$(DecimalNumber - 2)
      rPrintX = TabStop
   END IF
END SUB

'
'  Input:
'     sSymbol     The symbol, such as "Li" of interest
'  Output:
'     AtomicMass  Average atomic mass of element, group, or amino acid sSymbol
'     Uncertainty Uncertainty in atomic mass
'
SUB PeriodicTable (sSymbol AS STRING, AtomicMass AS DOUBLE, Uncertainty AS SINGLE)
SELECT CASE sSymbol
    CASE "H  "
        AtomicMass = 1.00794#
        Uncertainty = .00007
    CASE "He "
        AtomicMass = 4.002602#
        Uncertainty = .000002
    CASE "Li "
        AtomicMass = 6.941#
        Uncertainty = .002
    CASE "Be "
        AtomicMass = 9.012182#
        Uncertainty = .000003
    CASE "B  "
        AtomicMass = 10.811#
        Uncertainty = .005
    CASE "C  "
        AtomicMass = 12.011#
        Uncertainty = .001
    CASE "N  "
        AtomicMass = 14.00674#
        Uncertainty = .00007
    CASE "O  "
        AtomicMass = 15.9994#
        Uncertainty = .0003
    CASE "F  "
        AtomicMass = 18.9984032#
        Uncertainty = .0000009
    CASE "Ne "
        AtomicMass = 20.1797#
        Uncertainty = .0006
    CASE "Na "
        AtomicMass = 22.989768#
        Uncertainty = .000006
    CASE "Mg "
        AtomicMass = 24.305#
        Uncertainty = .0006
    CASE "Al "
        AtomicMass = 26.981539#
        Uncertainty = .000005
    CASE "Si "
        AtomicMass = 28.0855#
        Uncertainty = .0003
    CASE "P  "
        AtomicMass = 30.973762#
        Uncertainty = .000004
    CASE "S  "
        AtomicMass = 32.066#
        Uncertainty = .006
    CASE "Cl "
        AtomicMass = 35.4527#
        Uncertainty = .0009
    CASE "Ar "
        AtomicMass = 39.948#
        Uncertainty = .001
    CASE "K  "
        AtomicMass = 39.0983#
        Uncertainty = .0001
    CASE "Ca "
        AtomicMass = 40.078#
        Uncertainty = .004
    CASE "Sc "
        AtomicMass = 44.95591#
        Uncertainty = .000009
    CASE "Ti "
        AtomicMass = 47.88#
        Uncertainty = .03
    CASE "V  "
        AtomicMass = 50.9415#
        Uncertainty = .0001
    CASE "Cr "
        AtomicMass = 51.9961#
        Uncertainty = .0006
    CASE "Mn "
        AtomicMass = 54.93805#
        Uncertainty = .00001
    CASE "Fe "
        AtomicMass = 55.847#
        Uncertainty = .003
    CASE "Co "
        AtomicMass = 58.9332#
        Uncertainty = .00001
    CASE "Ni "
        AtomicMass = 58.6934#
        Uncertainty = .0002
    CASE "Cu "
        AtomicMass = 63.546#
        Uncertainty = .003
    CASE "Zn "
        AtomicMass = 65.39#
        Uncertainty = .02
    CASE "Ga "
        AtomicMass = 69.723#
        Uncertainty = .001
    CASE "Ge "
        AtomicMass = 72.61#
        Uncertainty = .02
    CASE "As "
        AtomicMass = 74.92159#
        Uncertainty = .00002
    CASE "Se "
        AtomicMass = 78.96#
        Uncertainty = .03
    CASE "Br "
        AtomicMass = 79.904#
        Uncertainty = .001
    CASE "Kr "
        AtomicMass = 83.8#
        Uncertainty = .01
    CASE "Rb "
        AtomicMass = 85.4678#
        Uncertainty = .0003
    CASE "Sr "
        AtomicMass = 87.62#
        Uncertainty = .01
    CASE "Y  "
        AtomicMass = 88.90585#
        Uncertainty = .00002
    CASE "Zr "
        AtomicMass = 91.224#
        Uncertainty = .002
    CASE "Nb "
        AtomicMass = 92.90638#
        Uncertainty = .00002
    CASE "Mo "
        AtomicMass = 95.94#
        Uncertainty = .01
    CASE "Tc "
        AtomicMass = 98#
        Uncertainty = 1
    CASE "Ru "
        AtomicMass = 101.07#
        Uncertainty = .02
    CASE "Rh "
        AtomicMass = 102.9055#
        Uncertainty = .00003
    CASE "Pd "
        AtomicMass = 106.42#
        Uncertainty = .01
    CASE "Ag "
        AtomicMass = 107.8682#
        Uncertainty = .0002
    CASE "Cd "
        AtomicMass = 112.411#
        Uncertainty = .008
    CASE "In "
        AtomicMass = 114.82#
        Uncertainty = .01
    CASE "Sn "
        AtomicMass = 118.71#
        Uncertainty = .007
    CASE "Sb "
        AtomicMass = 121.757#
        Uncertainty = .003
    CASE "Te "
        AtomicMass = 127.6#
        Uncertainty = .03
    CASE "I  "
        AtomicMass = 126.90447#
        Uncertainty = .00003
    CASE "Xe "
        AtomicMass = 131.29#
        Uncertainty = .02
    CASE "Cs "
        AtomicMass = 132.90543#
        Uncertainty = .00005
    CASE "Ba "
        AtomicMass = 137.327#
        Uncertainty = .007
    CASE "La "
        AtomicMass = 138.9055#
        Uncertainty = .0002
    CASE "Ce "
        AtomicMass = 140.115#
        Uncertainty = .004
    CASE "Pr "
        AtomicMass = 140.90765#
        Uncertainty = .00003
    CASE "Nd "
        AtomicMass = 144.24#
        Uncertainty = .03
    CASE "Pm "
        AtomicMass = 145#
        Uncertainty = 1
    CASE "Sm "
        AtomicMass = 150.36#
        Uncertainty = .03
    CASE "Eu "
        AtomicMass = 151.965#
        Uncertainty = .009
    CASE "Gd "
        AtomicMass = 157.25#
        Uncertainty = .03
    CASE "Tb "
        AtomicMass = 158.92534#
        Uncertainty = .00003
    CASE "Dy "
        AtomicMass = 162.5#
        Uncertainty = .03
    CASE "Ho "
        AtomicMass = 164.93032#
        Uncertainty = .00003
    CASE "Er "
        AtomicMass = 167.26#
        Uncertainty = .03
    CASE "Tm "
        AtomicMass = 168.93421#
        Uncertainty = .00003
    CASE "Yb "
        AtomicMass = 173.04#
        Uncertainty = .03
    CASE "Lu "
        AtomicMass = 174.967#
        Uncertainty = .001
    CASE "Hf "
        AtomicMass = 178.49#
        Uncertainty = .02
    CASE "Ta "
        AtomicMass = 180.9479#
        Uncertainty = .0001
    CASE "W  "
        AtomicMass = 183.85#
        Uncertainty = .03
    CASE "Re "
        AtomicMass = 186.207#
        Uncertainty = .001
    CASE "Os "
        AtomicMass = 190.2#
        Uncertainty = .1
    CASE "Ir "
        AtomicMass = 192.22#
        Uncertainty = .03
    CASE "Pt "
        AtomicMass = 195.08#
        Uncertainty = .03
    CASE "Au "
        AtomicMass = 196.96654#
        Uncertainty = .00003
    CASE "Hg "
        AtomicMass = 200.59#
        Uncertainty = .02
    CASE "Tl "
        AtomicMass = 204.3833#
        Uncertainty = .0002
    CASE "Pb "
        AtomicMass = 207.2#
        Uncertainty = .1
    CASE "Bi "
        AtomicMass = 208.98037#
        Uncertainty = .00003
    CASE "Po "
        AtomicMass = 209#
        Uncertainty = 1
    CASE "At "
        AtomicMass = 210#
        Uncertainty = 1
    CASE "Rn "
        AtomicMass = 222#
        Uncertainty = 1
    CASE "Fr "
        AtomicMass = 223#
        Uncertainty = 1
    CASE "Ra "
        AtomicMass = 226.0254#
        Uncertainty = .0001
    CASE "Ac "
        AtomicMass = 227.02775#
        Uncertainty = .00001
    CASE "Th "
        AtomicMass = 232.0381#
        Uncertainty = .0001
    CASE "Pa "
        AtomicMass = 231#
        Uncertainty = 1
    CASE "U  "
        AtomicMass = 238.0289#
        Uncertainty = .0001
    CASE "Np "
        AtomicMass = 237#
        Uncertainty = 1
    CASE "Pu "
        AtomicMass = 244#
        Uncertainty = 1
    CASE "Am "
        AtomicMass = 243#
        Uncertainty = 1
    CASE "Cm "
        AtomicMass = 247#
        Uncertainty = 1
    CASE "Bk "
        AtomicMass = 247#
        Uncertainty = 1
    CASE "Cf "
        AtomicMass = 251#
        Uncertainty = 1
    CASE "Es "
        AtomicMass = 252#
        Uncertainty = 1
    CASE "Fm "
        AtomicMass = 257#
        Uncertainty = 1
    CASE "Md "
        AtomicMass = 258#
        Uncertainty = 1
    CASE "No "
        AtomicMass = 259#
        Uncertainty = 1
    CASE "Lr "
        AtomicMass = 260#
        Uncertainty = 1
    ' ***************************** Common Radicals *************************
    CASE "Ph "   ' Phenyl, C6H5
        AtomicMass = 77.105#
        Uncertainty = .006
    CASE "Me "   ' Methyl, CH3
        AtomicMass = 15.034#
        Uncertainty = .001
    CASE "Et "   ' Ethyl, CH3CH2
        AtomicMass = 29.061#
        Uncertainty = .002
    CASE "Cp "   ' cyclopentadienyl, C5H5
        AtomicMass = 69.094#
        Uncertainty = .005
    CASE "Bu "   ' butyl, C4H9
        AtomicMass = 57.115#
        Uncertainty = .004
    CASE "Pn "   ' pentyl, C5H11
        AtomicMass = 71.142#
        Uncertainty = .005
    CASE "Hx "   ' hexyl, C6H13
        AtomicMass = 85.169#
        Uncertainty = .006
    CASE "Ch "   ' cyclohexyl, C6H11
        AtomicMass = 83.153#
        Uncertainty = .006
    CASE "Ala"   'alanine, C3H5NO
        AtomicMass = 71.079#
        Uncertainty = .003
    CASE "Arg"   'arginine, C6H12N4O  (Unprotonated)
        AtomicMass = 156.188#
        Uncertainty = .006
    CASE "Asn"   'asparagine, C4H6N2O
        AtomicMass = 98.105#
        Uncertainty = .004
    CASE "Asp"   'aspartic acid, C4H5NO3  (undissociated)
        AtomicMass = 115.089#
        Uncertainty = .004
    CASE "Cys"   'cystine, C3H5NOS  (no disulfide link)
        AtomicMass = 103.145#
        Uncertainty = .007
    CASE "Gln"   'glutamine, C5H8N2O2
        AtomicMass = 128.131#
        Uncertainty = .005
    CASE "Glu"   'glutamic acid, C5H7NO3  (undissociated)
        AtomicMass = 129.116#
        Uncertainty = .005
    CASE "Gly"   'glycine, C2H3NO
        AtomicMass = 57.052#
        Uncertainty = .002
    CASE "His"   'histidine, C6H7N3O   (unprotonated)
        AtomicMass = 137.141#
        Uncertainty = .006
    CASE "Ile", "Leu"  'isoleucine or leucine, C6H11NO
        AtomicMass = 113.159#
        Uncertainty = .006
    CASE "Lys"   'lysine, C6H12N2O
        AtomicMass = 128.174#
        Uncertainty = .006
    CASE "Met"   'methionine, C5H9NOS
        AtomicMass = 131.199#
        Uncertainty = .008
    CASE "Phe"   'phenyalanine, C9H9NO
        AtomicMass = 147.177#
        Uncertainty = .009
    CASE "Pro"   'proline, C5H7NO
        AtomicMass = 97.117#
        Uncertainty = .005
    CASE "Ser"   'serine, C3H5NO2
        AtomicMass = 87.078#
        Uncertainty = .003
    CASE "Thr"   'threonine, C4H7NO2
        AtomicMass = 101.105#
        Uncertainty = .004
    CASE "Trp"   'tryptophan, C11H10N2O
        AtomicMass = 186.21#
        Uncertainty = .01
    CASE "Tyr"   'tyrosine, C9H9NO2
        AtomicMass = 163.179#
        Uncertainty = .009
    CASE "Val"   'valine, C5H9NO
        AtomicMass = 99.133#
        Uncertainty = .005
    CASE "   "
        AtomicMass = 0#  ' Indicates last element
    CASE ELSE
        AtomicMass = -1# ' Indicates unrecognized Symbol
END SELECT

END SUB

DEFINT A-Z
SUB txtElement_GotFocus (Index AS INTEGER)
   ' NonContinuedLine indicates whether or not the selection is to be
   ' deleted by the first key pressed.
   txtElement(Index).BackColor = YELLOW
   txtElement(Index).SelStart = -(NOT mbNonContinuedLine)
   txtElement(Index).SelLength = -3 * mbNonContinuedLine
   mbNonContinuedLine = TRUE
   frmDisplay.Tag = STR$(Index)
   msOriginalText = txtElement(Index).Text ' Save original text; recall with escape key.
END SUB

SUB txtElement_KeyPress (Index AS INTEGER, KeyAscii AS INTEGER)
IF KeyAscii = KEY_RETURN THEN
   ' Go to next Element.
   KeyAscii = 0
   txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
ELSEIF (KeyAscii > 47 AND KeyAscii < 58) THEN
   ' Numbers 0 - 9; go to txtNumber.
   txtNumber(Index).Text = CHR$(KeyAscii)
   KeyAscii = 0
   txtNumber(Index).SETFOCUS
   mbNonContinuedLine = FALSE
ELSEIF KeyAscii = KEY_ESCAPE THEN
   KeyAscii = 0
   txtElement(Index).Text = msOriginalText
ELSEIF (KeyAscii < 65 OR KeyAscii > 90) AND (KeyAscii < 97 OR KeyAscii > 122) AND KeyAscii <> KEY_BACK AND KeyAscii <> KEY_DELETE THEN
   KeyAscii = 0
   BEEP
END IF

END SUB

SUB txtElement_KeyUp (Index AS INTEGER, KeyCode AS INTEGER, Shift AS INTEGER)
DIM Number
IF Shift = 0 THEN
   IF KeyCode = KEY_DOWN THEN
      ' Down arrow.
      txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   ELSEIF KeyCode = KEY_UP THEN
      ' Up arrow.
      IF Index = 0 THEN
         Number = mMaxIndex
      ELSE
         Number = Index - 1
      END IF
      txtElement(Number).SETFOCUS
   END IF
END IF

END SUB

' The element symbol is blank unless a valid symbol is entered.
' Output:
'      sSymbol(Index)
'      dMassElement(Index)
'      fStdDevElement(Index)
SUB txtElement_LostFocus (Index AS INTEGER)
   DIM NewElement AS STRING * 3
   DIM sSecondLetters AS STRING * 2
   DIM dAtomicMass AS DOUBLE, fStdDev AS SINGLE
   DIM sOriginalElement AS STRING * 3
   sOriginalElement = sSymbol(Index)
   NewElement = UCASE$(LTRIM$(txtElement(Index).Text))
      'Make second & third letters lower case
   sSecondLetters = MID$(NewElement, 2)
   MID$(NewElement, 2) = LCASE$(sSecondLetters)
   CALL PeriodicTable(NewElement, dAtomicMass, fStdDev)
   IF dAtomicMass = -1 THEN
      ' Unrecognized Symbol
      BEEP
      txtElement(Index).Text = sSymbol(Index)  ' Restore previous symbol.
      sSymbol(Index) = ""
      txtElement(Index).SETFOCUS
      EXIT SUB
   ELSEIF dAtomicMass = 0 THEN
      ' User wants it blank.
      txtElement(Index).Text = ""
      sSymbol(Index) = ""
   ELSE
      sSymbol(Index) = NewElement
      txtElement(Index).Text = NewElement
      dMassElement(Index) = dAtomicMass
      fStdDevElement(Index) = fStdDev
   END IF
   txtElement(Index).BackColor = BRIGHT_CYAN
   IF txtNumber(Index).Text <> "" AND sOriginalElement <> sSymbol(Index) THEN
      Calculate
   END IF

END SUB

SUB txtNumber_GotFocus (Index AS INTEGER)
   ' NonContinuedLine indicates whether or not the selection is to be
   ' deleted by the first key pressed.
   txtNumber(Index).BackColor = YELLOW
   txtNumber(Index).SelStart = -(NOT mbNonContinuedLine)
   txtNumber(Index).SelLength = -10 * mbNonContinuedLine
   mbNonContinuedLine = TRUE
   frmDisplay.Tag = STR$(-Index - 1)
   msOriginalText = txtNumber(Index).Text ' Save original text; recall with escape key.
END SUB

SUB txtNumber_KeyPress (Index AS INTEGER, KeyAscii AS INTEGER)
IF KeyAscii = KEY_RETURN THEN
   KeyAscii = 0
   txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
ELSEIF (KeyAscii > 64 AND KeyAscii < 91) OR (KeyAscii > 96 AND KeyAscii < 123) THEN
   txtElement((Index + 1) MOD (mMaxIndex + 1)).Text = CHR$(KeyAscii)
   KeyAscii = 0
   txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   mbNonContinuedLine = FALSE
ELSEIF KeyAscii = KEY_ESCAPE THEN
   KeyAscii = 0
   txtNumber(Index).Text = msOriginalText
ELSEIF (KeyAscii < 48 OR KeyAscii > 57) AND KeyAscii <> KEY_BACK AND KeyAscii <> KEY_DELETE THEN
   KeyAscii = 0
   BEEP
END IF
END SUB

SUB txtNumber_KeyUp (Index AS INTEGER, KeyCode AS INTEGER, Shift AS INTEGER)
' Originally this code was in the KeyDown event.  It doesn't work well there.
' If the down arrow was held down, not all of the text boxes changed colors
' properly.  For some reason, I don't have that problem with the code here.
DIM Number
IF Shift = 0 THEN
   IF KeyCode = KEY_DOWN THEN
      ' Down arrow.
      KeyCode = 0    ' Needed???
      txtNumber((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   ELSEIF KeyCode = KEY_UP THEN
      ' Up arrow.
      KeyCode = 0
      IF Index = 0 THEN
         Number = mMaxIndex
      ELSE
         Number = Index - 1
      END IF
      txtNumber(Number).SETFOCUS
   END IF
END IF

END SUB

' lNumberOfAtoms should be "" or else a valid number.
' Processes the input, calls calculate.
SUB txtNumber_LostFocus (Index AS INTEGER)
   DIM lNumberOfAtoms AS LONG
   DIM lOriginalNumber AS LONG

   lOriginalNumber = lNumberOfAtoms(Index)
   ON LOCAL ERROR GOTO OverFlow
   lNumberOfAtoms = VAL(txtNumber(Index).Text)
   ON LOCAL ERROR GOTO 0
   IF lNumberOfAtoms > 0 THEN
      txtNumber(Index).Text = FORMAT$(lNumberOfAtoms)
      lNumberOfAtoms(Index) = lNumberOfAtoms
   ELSE
      IF lNumberOfAtoms < 0 OR (lNumberOfAtoms = 0 AND LEN(txtNumber(Index).Text) > 0) AND txtNumber(Index).Text <> "0" THEN BEEP
      txtNumber(Index).Text = ""
      lNumberOfAtoms(Index) = 0
   END IF
   IF txtElement(Index).Text <> "" AND lOriginalNumber <> lNumberOfAtoms(Index) THEN
      Calculate
   END IF
   txtNumber(Index).BackColor = CYAN
   EXIT SUB

OverFlow:
   MSGBOX "The number you entered," + CHR$(13) + txtNumber(Index).Text + CHR$(13) + "is too large to handle.", 0, "Number Entry"
   txtNumber(Index).Text = LEFT$(msOriginalText, 10)
   txtNumber(Index).SETFOCUS
   RESUME

END SUB

