.I 6 6
      where:      -i     = accept files from stdin
                  -ln    = set lines per page to n
                  -on    = set page offset to n
                  -pname = output to file <name>
                  -tn    = set tabs to n cols
                  -wn    = set page width to n
.D 7 6
.I 19 4
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "getopts.h"                            /* Also in SNIPPETS     */
.I 29 33

int       page_length = PAGE_LENGTH;
int       page_offset = PAGE_OFFSET;
int       page_width  = PAGE_WIDTH;
int       tab_width   = TAB_DEFAULT;
Boolean_T read_stdin  = FALSE;

char      print_name[FILENAME_MAX] = "PRN";
char      filenames[MAX_FILES] [FILENAME_MAX];

struct Option_Tag options[] = {
      {'I',  Boolean_Tag, &read_stdin  },       /* Valid options        */
      {'i',  Boolean_Tag, &read_stdin  },
      {'L',  Word_Tag,    &page_length },
      {'l',  Word_Tag,    &page_length },
      {'O',  Word_Tag,    &page_offset },
      {'o',  Word_Tag,    &page_offset },
      {'T',  Word_Tag,    &tab_width   },
      {'t',  Word_Tag,    &tab_width   },
      {'W',  Word_Tag,    &page_width  },
      {'w',  Word_Tag,    &page_width  },
      {'P',  String_Tag,   print_name  },
      {'p',  String_Tag,   print_name  },
      {'\0', ERROR,        NULL  }              /* Terminating record   */
};

char title[80];
char Date[20];
char Time[20];
int  ln, pn;

PAGE (MAIN)
main(int argc, char *argv[])  /* copy file to printer */
.D 30 32
.I 63 1
      int fi;
.D 64 2
.I 100 25
      
      if (ERROR == getopts(argc, argv))
            return 1;
      
      if ((page_length <= 0) || (page_length > 120))
            page_length = PAGE_LENGTH;

      if ((tab_width <= 0) || (tab_width > 8))
            tab_width = TAB_DEFAULT;

      if ((page_offset < 0) || (page_offset > 120))
            page_offset = PAGE_OFFSET;

      if ((page_width <= 0) || (page_width > 160))
            page_width = PAGE_WIDTH;

      for (fi = 0, pn = 1; pn < xargc; ++fi, ++pn)
      {
            if (fi < MAX_FILES)
                  strcpy(filenames[fi], xargv[pn]);
            else
            {
                  fprintf(stderr, "pr: "
                        "Exceeded maximum file capacity\n");
                  break;
.D 101 56
.I 175 1
                  cp = fgets(filenames [fi], FILENAME_MAX, stdin);
.D 176 1
.I 188 1
new_page (char *fnp, FILE *lp)
.D 189 3
.I 198 1
                   fnp, Date, Time, pn, title);
.D 199 1
.I 203 1
prt (char fnp[], FILE *lp)
.D 204 3
.I 210 2
      time_t now;
      struct tm *tnow;
.I 222 4
      now  = time(&now);
      tnow = localtime(&now);
      strftime(Date, 19, "%a %d %b %Y", tnow);
      strftime(Time, 19, "%I:%M %PM", tnow);
.D 223 2
.I 230 3
                  if (NULL != (st = strchr(line, '(')))
                  {
                        et = strchr(line, ')');
.D 231 3
.I 293 1
indent(FILE *lp)
.D 294 2
