.I 0 31
/************************************************************************/
/*                                                                      */
/*  EVALUATE.C - A simple mathematical expression evaluator in C        */
/*                                                                      */
/*  operators supported: Operator               Precedence              */
/*                                                                      */
/*                         (                     Lowest                 */
/*                         )                     Highest                */
/*                         +   (addition)        Low                    */
/*                         -   (subtraction)     Low                    */
/*                         *   (multiplication)  Medium                 */
/*                         /   (division)        Medium                 */
/*                         \   (modulus)         High                   */
/*                         ^   (exponentiation)  High                   */
/*                         sin(                  Lowest                 */
/*                         cos(                  Lowest                 */
/*                         atan(                 Lowest                 */
/*                         abs(                  Lowest                 */
/*                         sqrt(                 Lowest                 */
/*                         ln(                   Lowest                 */
/*                         exp(                  Lowest                 */
/*                                                                      */
/*  constants supported: pi                                             */
/*                                                                      */
/*  Original Copyright 1991-93 by Robert B. Stout as part of            */
/*  the MicroFirm Function Library (MFL)                                */
/*                                                                      */
/*  This subset version is hereby donated to the public domain.         */
/*  Requires RMALLWS.C, also in SNIPPETS.                               */
/*                                                                      */
/************************************************************************/
.D 1 24
.D 26 1
.I 31 9
#define LAST_CHAR(string) (((char *)string)[strlen(string)-1])

struct operator {
      char        token;
      char       *tag;
      size_t      taglen;
      int         precedence;
};

.I 35 19
static struct operator verbs[] = {
      {'+',  "+",       1, 2 },
      {'-',  "-",       1, 3 },
      {'*',  "*",       1, 4 },
      {'/',  "/",       1, 5 },
      {'\\', "\\",      1, 5 },
      {'^',  "^",       1, 6 },
      {'(',  "(",       1, 0 },
      {')',  ")",       1, 99},
      {'S',  "SIN(",    4, 0 },
      {'C',  "COS(",    4, 0 },
      {'A',  "ABS(",    4, 0 },
      {'L',  "LN(",     3, 0 },
      {'E',  "EXP(",    4, 0 },
      {'t',  "ATAN(",   5, 0 },
      {'s',  "SQRT(",   5, 0 },
      {NUL,  NULL,      0, 0 }
};

.D 36 1
.I 42 1
              state;                            /* 0 = Awaiting expression
.D 43 1
.I 45 16
const double Pi = 3.14159265358979323846;

int                     evaluate(char *, double *);

char                   *rmallws(char *);        /* Also in SNIPPETS     */

static int              do_op(void);
static int              do_paren(void);
static void             push_op(char);
static void             push_arg(double);
static int              pop_arg(double *);
static int              pop_op(int *);
static char            *get_exp(char *);
static struct operator *get_op(char *);
static int              getprec(char);
static int              getTOSprec(void);
.D 46 12
.I 60 5
#include <stdio.h>

main(int argc, char *argv[])
{
      int retval;
.D 61 2
.I 65 25
      printf("returned %d\n", retval = evaluate(argv[1], &val));
      if (0 == retval)
            printf("val = %f\n", val);
      return 0;
}

#endif

/************************************************************************/
/*                                                                      */
/*  evaluate()                                                          */
/*                                                                      */
/*  Evaluates an ASCII mathematical expression.                         */
/*                                                                      */
/*  Arguments: 1 - String to evaluate                                   */
/*             2 - Storage to receive double result                     */
/*                                                                      */
/*  Returns: SUCCESS if successful                                      */
/*           ERROR if syntax error                                      */
/*           R_ERROR if runtime error                                   */
/*                                                                      */
/*  Side effects: Removes all whitespace from the string and converts   */
/*                it to U.C.                                            */
/*                                                                      */
/************************************************************************/
.D 66 9
.I 80 5
      struct operator *op;

      strupr(line);
      rmallws(line);
      state = op_sptr = arg_sptr = parens = 0;
.D 81 2
.I 88 1
                  if (NULL != (str = get_exp(ptr)))
.D 89 1
.I 90 2
                        if (NULL != (op = get_op(str)) &&
                              strlen(str) == op->taglen)
.D 91 1
.I 92 2
                              push_op(op->token);
                              ptr += op->taglen;
.D 93 2
.I 97 19
                        if (SUCCESS == strcmp(str, "-"))
                        {
                              push_op(*str);
                              ++ptr;
                              break;
                        }

                        if (SUCCESS == strcmp(str, "PI"))
                              push_arg(Pi);

                        else
                        {
                              if (0.0 == (arg = strtod(str, &endptr)) &&
                                    NULL == strchr(str, '0'))
                              {
                                    return ERROR;
                              }
                              push_arg(arg);
                        }
.D 98 6
.I 111 3
                  if (NULL != (op = get_op(ptr)))
                  {
                        if (')' == *ptr)
.D 112 6
.I 123 6
                              while (op_sptr &&
                                    op->precedence <= getTOSprec())
                              {
                                    do_op();
                              }
                              push_op(op->token);
.D 124 1
.I 127 1
                        ptr += op->taglen;
.D 128 1
.I 180 6
      case '\\':
            if (0.0 == arg1)
                  return R_ERROR;
            push_arg(fmod(arg2, arg1));
            break;

.I 181 14
            push_arg(pow(arg2, arg1));
            break;

      case 't':
            ++arg_sptr;
            push_arg(atan(arg1));
            break;

      case 'S':
            ++arg_sptr;
            push_arg(sin(arg1));
            break;

      case 's':
.I 183 28
            ++arg_sptr;
            push_arg(sqrt(arg1));
            break;

      case 'C':
            ++arg_sptr;
            push_arg(cos(arg1));
            break;

      case 'A':
            ++arg_sptr;
            push_arg(fabs(arg1));
            break;

      case 'L':
            if (0.0 < arg1)
            {
                  ++arg_sptr;
                  push_arg(log(arg1));
                  break;
            }
            else  return R_ERROR;

      case 'E':
            ++arg_sptr;
            push_arg(exp(arg1));
            break;

.D 184 3
.I 212 1
      } while (getprec((char)op));
.D 213 1
.I 222 1
      if (!getprec(op))
.D 223 1
.I 232 1
static int pop_arg(double *arg)
.D 233 1
.I 240 1
static int pop_op(int *op)
.D 241 1
.I 252 1
static char * get_exp(char *str)
.D 253 1
.I 255 9
      struct operator *op;

      if (SUCCESS == strncmp(str, "PI", 2))
            return strcpy(token, "PI");


      while (*ptr)
      {
            if (NULL != (op = get_op(ptr)))
.D 256 4
.I 264 12
                        if (str == ptr && !isdigit(ptr[1]) && '.' != ptr[1])
                        {
                              push_arg(0.0);
                              strcpy(token, op->tag);
                              return token;
                        }
                  }

                  else if (str == ptr)
                  {
                        strcpy(token, op->tag);
                        return token;
.D 267 8
.I 288 40
static struct operator * get_op(char *str)
{
      struct operator *op;

      for (op = verbs; op->token; ++op)
      {
            if (SUCCESS == strncmp(str, op->tag, op->taglen))
                  return op;
      }
      return NULL;
}

/*
**  Get precedence of a token
*/

static int getprec(char token)
{
      struct operator *op;

      for (op = verbs; op->token; ++op)
      {
            if (token == op->token)
                  break;
      }
      if (op->token)
            return op->precedence;
      else  return 0;
}

/*
**  Get precedence of TOS token
*/

static int getTOSprec(void)
{
      if (!op_sptr)
            return 0;
      return getprec(op_stack[op_sptr - 1]);
}
.D 289 26
