Comment _
Ŀ
jzchrpos								     
Return the index of a character in a string or -1 if error		     
									     
Synopsis:								     
  *wstr = "hello there";                                                    
  index = jzchrpos(wstr,' ');                                               
									     
  ( returns 5 )							     

_

;=============================================================================
;				    Data
;=============================================================================

DGROUP	group	_DATA
_DATA	segment word public 'DATA'
	assume	ds:DGROUP

	; Your Data goes here . . .

_DATA	ends

;=============================================================================
;				   Code
;=============================================================================

	assume cs:_text
_text	segment public byte 'code'
	PUBLIC _jzchrpos

_jzchrpos	proc near

	push bp 			; save base of stack
	mov bp,sp			; establish stack frame

	push di 			; save MS-C's Register vars

	mov di,[bp].4			; address of string
	xor ax,ax			; search for zero byte
	mov cx,0FFFFh			; 64k max string
	repnz scasb			; find end of string
	inc cx
	neg cx
	mov dx,cx			; save string length

	mov di,[bp].4			; get address of string again
	mov ax,[bp].6			; char to search for
	xor bl,bl			; make a zero

	repnz scasb			; scan for character
	mov ax,0FFFFh			; return -1 if not found

	jcxz Notfound

	mov ax,dx			; get string length
	dec ax				; convert to index
	sub ax,cx			; subtract pos from length

notfound:

	pop di				; Restore MS-C's Register vars

	mov sp,bp			; restore stack pointer
	pop  bp 			; and base of stack
	ret				; return to caller

_jzchrpos	endp
_text	ends
end
