/* -- fileio.c	file reading and writing benchmark -- */
/* ---- sequentially writes a 65000 byte file on disk
	generates random long integers
	uses these modulo 65000 to read and write strings of ODDNUM bytes
	with the file handling system of the C package
	the random number generator is set to a specific seed,
	so that all compiles should generate a specific code
   ---- */

#include "stdio.h"

#define ERROR -1
#define READERR 0
#define BEG 0
#define CURR 1
#define END 2
#define READ 0
#define WRITE 1
#define UPDATE 2
#define OKCLOSE 0
#define FILESIZE 65000L
#define COUNT 500
#define C 13849L
#define A 25173L
#define ODDNUM 23

long seed = 7L;
long random(), lseek();

main () {

	int i;
	long j, pos;
	int fd;
	char buffer[ODDNUM + 1];

	if ((fd = creat("test.dat", WRITE)) == ERROR)
		abort("Can't create data file\n");
	else	printf("File open for sequential writing\n");
	for (j = 0; j < FILESIZE; ++j)
		if (write(fd, "x", 1) == ERROR)
			abort("Unexpected EOF in writing data file\n");
	if (close(fd) != OKCLOSE)
		abort("Error closing data file\n");
	else	printf("Normal termination writing data file\n");
	if ((fd = open("test.dat", UPDATE)) == ERROR)
		abort("Can't open data file for random reading and writing\n");
	else	printf("File opened for random reading and writing\n");
	for (i = 0; i < COUNT; ++i) {
		j = random(FILESIZE);
		if (j < 0L)
			j = (-j);
		if (FILESIZE - j < ODDNUM)
			continue;
		if ((pos = lseek(fd, j, BEG)) == -1L)
			abort("Error seeking to random offset\n");
		if (read(fd, buffer, ODDNUM) == READERR)
			abort("Error reading at random offset\n");
		j = random(FILESIZE);
		if (j < 0L)
			j = (-j);
		if (FILESIZE - j < ODDNUM)
			continue;
		if ((pos = lseek(fd, j, BEG)) == -1L)
			abort("Error seeking to random offset\n");
		if (write(fd, buffer, ODDNUM) == READERR)
			abort("Error writing at random offset\n");
	}
	if (close(fd) != OKCLOSE)
		abort("Error closing data file\n");
	else	printf("Normal termination from random reading and writing\n");
}

long random(size)

	long size;

	{
		seed = seed * A + C;
		return(seed % size);
	}

abort(message)

	char *message;

	{
		printf(message);
		exit(ERROR);
	}










