/**   EXPAND.C -  expands tab characters into 8 blank spaces and optionally
                  deletes header record.  Used for DIFFS and PROMOTE.

                  written  03-14-85    by Rick Leeper
                  updated  04-15-85    by Rick Leeper
**/

#include "stdio.h"
#include "ctype.h"
#include "def.h"
#include "ascii.h"

#define  MAXTMP         96
#define  STRIP_HEADER   0x01

struct XREG
        {
        short ax,bx,cx,dx,si,di;
        };
struct HREG
        {
        char al,ah,bl,bh,cl,ch,dl,dh;
        };
union REGS
        {
        struct XREG x;
        struct HREG h;
        };

main(argc,argv)
int   argc;
char  *argv[];
{
      char  *spt, *dpt;
      char  tmpfile[MAXTMP+1];
      int   ret;

      if (argc > 3) {
         printf("USAGE:\n     EXPAND [d:{path\}]filename.ext -flags\n");
         exit(-1);
      }

      spt = argv[1];
      dpt = &tmpfile[0];

      clrbuf(dpt, MAXTMP+1);

      maketmp(spt, dpt);

      if ((ret = copyfile(spt, dpt)) != NULL) {
         printf("\nERROR: copy unsuccessful\n");
         exit(ret);
      }

      rename(dpt, spt);
}

clrbuf(string, length)
int   length;
char  *string;
{
      int   i;

      for (i = 0; i < length; i++, *string++ = '\0')
         ;
}

maketmp(oldfile, tmpfile)
char  *oldfile, *tmpfile;
{
      static char tmp[] = ".TMP";
      char  *tpt = &tmp[0];
      int   c;

      while ((c = *oldfile) != '.' && c != '\0')
         *tmpfile++ = *oldfile++;

      while ((c = *tpt) != '\0')
         *tmpfile++ = *tpt++;

      return(0);
}

copyfile(oldfile, newfile)
char  *oldfile, *newfile;
{
      extern   int   argc;
      extern   char  *argv[];

      static   char  header[] = "HEADER";

      int      c = 32, space, lncnt = 0, colcnt, d, flags;
      char     buf[MAXTMP+1], *bufptr = &buf[0], *hdrptr = &header[0];

      FILE     *org, *tmp, *new;

      if ((org = fopen(oldfile, "r")) == NULL)
         return (EOF);
      if ((tmp = fopen(newfile, "w")) == NULL)
         return (EOF);

      if (argc == 3 && *argv[2] == '-') {
         flags = chk_flags(argv[2]);

         if ((flags & STRIP_HEADER) == STRIP_HEADER) {
            clrbuf(&buf[0], MAXTMP+1);
            colcnt = 0;
            while ((c = fgetc(org)) != CR && c != LF) {
               if (c == TAB)
                  for (space = (colcnt % 8); space++ < 8; colcnt++)
                     *bufptr++ = SPACE;
               else {
                  *bufptr++ = c;
                  colcnt++;
               }
            }
            *bufptr++ = c;
            if ((c = strcmp(&header[0], &buf[7])) == NULL)
               ;
            else
               putline(&buf[0], tmp);
         }
      }

      while ((d = feof(org)) != FEOF && c != EOF) {
         colcnt = 0;
         while ((c = fgetc(org)) != CR && c != LF && c != EOF) {
            if (c == TAB)
               for (space = (colcnt % 8); space++ < 8; colcnt++)
                  fputc(SPACE, tmp);
            else {
               fputc(c,tmp);
               colcnt++;
            }
         }
      (c == EOF) ? fputc('\x1a',tmp) : fputc(c,tmp);
      if ((++lncnt % 25) == 0)
         printf(".");
      }

      fclose(org);
      fclose(tmp);

      return(0);
}

rename(file1, file2)
char  *file1, *file2;
{
      int   ret, *inxptr;
      union REGS  inregs, outregs;
      char  *incptr;

      unlink(file2);

      inxptr = &inregs.x.dx;
      *inxptr = file1;
      inxptr = &inregs.x.di;
      *inxptr = file2;
      incptr = &inregs.h.ah;
      *incptr = '\x56';

      ret = intdos(&inregs, &outregs);

      if (ret == 3 || ret == 5 || ret == 17)
         return('\xFF');
      else
         return(0);
}

chk_flags(args)
char  *args;
{
      int   flags = 0;
      char  *altarg, c;

      altarg = ++args;
      while (*altarg) {
         c = toupper(*altarg);
         switch (c) {
            case  'S':
               flags = flags | STRIP_HEADER;
               break;
         }
         altarg++;
      }

      return (flags);
}

strcmp(string1, string2)
char  *string1, *string2;
{
      while (*string1 == *string2) {
         ++string1;
         if (!*string1)
            return (0);
         ++string2;
      }

      if (*string1 < *string2)
         return (-1);
      else
         return (1);
 }

putline(buffer, file)
char  *buffer;
FILE  *file;
{
      while (*buffer != NULL) {
         fputc(*buffer, file);
         buffer++;
      }
}
