Title   TypeOf  Determine type of DOS being Used - 05 Oct 1987 - Davy Crockett

;       ͻ
;          Davy Crockett Productions   
;          5807 Cherrywood Lane, 104   
;          Greenbelt, Maryland 20770   
;       ͼ

Cseg    Segment
        Assume  DS:Cseg, SS:Cseg, CS:Cseg, ES:Cseg

Null    Equ     00H
CR      Equ     0DH
LF      Equ     0AH
Parms   Equ     5CH

        Org     100H

TypeOf:
        Mov     BX,Parms                ; get parm pointer
        Cmp     Byte Ptr [BX],Null      ; anything there?
        Jnz     GetDefault              ; yes, continue
        Jmp     DisplayHelp             ; no, display help screen

GetDefault:
        Mov     AL,[BX]                 ; pick up parameter
        Dec     AL                      ; adjust for in-consistency
        Mov     BX,Offset DiskBuffer    ; disk buffer address
        Mov     CX,1                    ; number of sectors
        Mov     DX,0                    ; beginning sector number
        Int     25H                     ; absolute disk read
        Pop     BX                      ; remove flags from stack
        Jc      NoDiskExit              ; no, exit stage left

VersionTest:
        Cmp     Byte Ptr 10[DiskBuffer],'1'      ; Version 3.1 DOS?
        Jnz     NoDiskExit              ; no, can't determine

LeTest:
        Cmp     Byte Ptr 3[DiskBuffer],'P'       ; Leading Edge?
        Jnz     NcrTest                 ; no, try NCR
        Cmp     Byte Ptr 4[DiskBuffer],'S'       ; Leading Edge?
        Jnz     NcrTest                 ; no, try NCR
        Cmp     Byte Ptr 5[DiskBuffer],'A'       ; Leading Edge?
        Jz      LeExit                  ; yes, exit stage right

NcrTest:
        Cmp     Byte Ptr 162[DiskBuffer],'N'     ; NCR?
        Jnz     IbmTest                 ; no, try IBM
        Cmp     Byte Ptr 163[DiskBuffer],'C'     ; NCR?
        Jnz     IbmTest                 ; no, try IBM
        Cmp     Byte Ptr 164[DiskBuffer],'R'     ; NCR?
        Jz      NcrExit                 ; yes, exit stage right

IbmTest:
        Cmp     Byte Ptr 3[DiskBuffer],'I'       ; IBM?
        Jnz     NoDiskExit              ; no, exit stage left
        Cmp     Byte Ptr 4[DiskBuffer],'B'       ; IBM?
        Jnz     NoDiskExit              ; no, exit stage left
        Cmp     Byte Ptr 5[DiskBuffer],'M'       ; IBM?
        Jz      IbmExit                 ; yes, exit stage right

NoDiskExit:
        Mov     AL,0                    ; Return disk not found
        Jmp     Short   TypeOfExit      ; go to Exit
LeExit:
        Mov     AL,1                    ; Return disk not found
        Jmp     Short   TypeOfExit      ; go to Exit
NcrExit:
        Mov     AL,2                    ; Return disk not found
        Jmp     Short   TypeOfExit      ; go to Exit
IbmExit:
        Mov     AL,3                    ; Return disk not found
        Jmp     Short   TypeOfExit      ; go to Exit
DisplayHelp:
        Mov     DX,Offset DiskBuffer    ; point to message
        Mov     AH,09H                  ; display string function
        Int     21H                     ; StdOut
        Mov     AL,0                    ; no disk return code

TypeOfExit:
        Mov     AH,4CH                  ; terminate a process
        Int     21H                     ; exit stage left

DiskBuffer      DB      CR,LF,LF
                DB      '* TypeOf * Version 1.0 * 05 Oct 1987 '
                DB      '* Davy Crockett *',CR,LF,LF
                DB      'Determines type of DOS being used.',CR,LF,LF
                DB      '    Execute:  TypeOf [drive]',CR,LF,LF
                DB      '    Return Code = 0, non-system disk or can not determine.',CR,LF
                DB      '    Return Code = 1, Leading Edge, Version 3.1.',CR,LF
                DB      '    Return Code = 2, NCR-DOS, Version 3.1.',CR,LF
                DB      '    Return Code = 3, IBM-DOS, Version 3.1.',CR,LF,LF
                DB      '$'

TypeOfLen       Equ     (This Byte) - (Offset TypeOf)
Filler          Equ     944 - TypeOfLen
                DB      Filler DUP(0)
CopyRight       Equ     $
                DB      'ͻ '
                DB      'Davy Crockett '
                DB      ' Productions  '
                DB      ' 05 Oct 1987  '
                DB      'ͼ'

Cseg    Ends

        End     TypeOf
