	PAGE	,132
	TITLE	REBOOT -- Command to Force a Reboot
	%OUT	History

; reboot.asm  20 Mar 85  Craig Milo Rogers at USC/ISI
;	Copied from Info-IBMPC Digest V4 #34, made format changes,
; and fixed bugs.  The original was by Joeseph M. Newcomer,
; based on REBOOT.SEQ in the Info-IBMPC library.

;	This program reboots your IBM-PC, but omits the memory
; diagnostic.  WARNING!  There is code here which is very
; BIOS dependent!

;	The following commands should remake this program:
;		MASM REBOOT;
;		LINK REBOOT;
;		EXE2BIN REBOOT
;		RENAME REBOOT.BIN REBOOT.COM
;		DEL REBOOT.EXE

	%OUT	BIOS RAM Locations

BIOSCOM	SEGMENT AT 40H
	ORG	BIOSCOM+72H
RESET_FLAG DW	?		; Warm/cold restart flag.
BIOSCOM	ENDS

	%OUT	Start of Program and Data

;	The following location (RESTART) holds the address of the
; label START in the IBMPC ROM BIOS.  Jumping to START does a cold
; boot, but skips the RAM check step.  Warning!  The address of START
; may be different in IBM-PC clones, or even in later releases of IBM
; BIOS.  [Toad Hall Note:  Still works with PCDOS 3.1]

	CODESEG SEGMENT 'CODE'		; Start the code segment
	ASSUME	CS:CODESEG,DS:CODESEG

	ORG	100H		; Beginning of code area.

BEGIN:	JMP	SHORT CLRBFI	; Jump around data area.

RESTART  LABEL	DWORD
	DW	0E05BH		; IP for reboot
	DW	0F000H		; CS for reboot

	%OUT	Code

CLRBFI:
	MOV	AX,SEG BIOSCOM	; Point to BIOS data segment.
	MOV	DS,AX
	ASSUME	DS:BIOSCOM

	MOV	RESET_FLAG,1234H ; Set 'Warm Start' flag.
	JMP	RESTART		; Jump into BIOS.

CODESEG	ENDS

	END BEGIN
