TITLE	TASK	12-6-85	[4-18-88]
;Toad Hall Disassembly, tweak

LF	EQU	0AH
CR	EQU	0DH
;
;INITIAL VALUES :	CS:IP	0000:0100
;			SS:SP	0000:FFFF
CodeSeg	SEGMENT
	ASSUME DS:CodeSeg,SS:CodeSeg,CS:CodeSeg,ES:CodeSeg
	ORG	100H

Task	proc	near
	JMP	Start

usageMsg DB	'TASK; Version 1.33, created on 04/20/88 at 18:00:00',CR,LF
	DB	'(C) COPYRIGHT 1985 by System Enhancement Associates; '
	DB	'ALL RIGHTS RESERVED',CR,LF
	db	'(Toad Hall Tweak)',CR,LF,LF
	DB	'Timed ASK for batch files.  Error level 0=Yes, 1=No,'
	db	' 2=No answer',CR,LF,LF
	DB	'Usage: task [<n>] [<q>]',CR,LF
	DB	'Where:   <n> = Time limit in seconds (default 20)',CR,LF
	DB	'         <q> = Question to ask',CR,LF,'$'

promptStr	DB	'(Y or N) $'
noStr		DB	'No',CR,LF,'$'
yesStr		DB	'Yes',CR,LF,'$'
noAnswerStr	DB	' (no answer given)',CR,LF,'$'

day_25D		DB	0
hour_25E	DB	0
minute_25F	DB	0
second_260	DB	0
decisec_261	DB	0
bflag_262	DB	0
second_263	DB	0
word_264	dw	0
Task	endp


;Convert time (in CX and DX) to seconds,
;return in AX
Time_To_Seconds	proc	near
	MOV	DL,DH		;seconds
	XOR	DH,DH		;clear msb
	PUSH	DX		;save
	MOV	DL,CL		;minutes
	PUSH	DX		;save
	XOR	AH,AH		;clear msb
	MOV	AL,CH		;hours
	MOV	DX,3CH		;*60
	MUL	DX
	POP	DX		;restore minutes
	ADD	AX,DX		;add to hours in minutes
	MOV	DX,3CH		;*60
	MUL	DX		;produces hours + minutes in seconds
	POP	DX		;restore seconds
	ADD	AX,DX		;accum hours + minutes + seconds
	RET
Time_To_Seconds	endp

Compare_Time	proc	near
	CMP	DH,second_263		;compare now with start seconds
	JZ	Ret2AC			;same
	MOV	second_263,DH		;save as start seconds
	CALL	Time_To_Seconds		;convert time to seconds
	MOV	DX,word_264		;start time
	SUB	DX,AX			;minus now in seconds
	CMP	DX,9			;timed out?
	JG	Ret2AC			;exit, carry set
	CMP	DX,0			;timed out?
	JLE	Ret2AC			;exit, carry, zflag set
	MOV	AH,2			;display char
	add	dl,30H			;asciify char in DL
	INT	21H
	mov	dl,8			;display Ctrl H, backspace
	INT	21H
Ret2AC:	RET
Compare_Time	endp


;Dumb, cleaned this up below.
;Show_Usage	proc	near
;	MOV	DX,OFFSET usageMsg	;usage message'
;	MOV	AH,9
;	INT	21H
;	RET
;Show_Usage	endp


Start	proc	near
	MOV	AX,2523H		;Set new int 23H vector
	MOV	DX,OFFSET Die_3F2	;to our process
	INT	21H
	MOV	AH,2CH			;get current system time
	INT	21H
	MOV	day_25D,AL		;day of week
	MOV	hour_25E,CH		;current hour
	MOV	minute_25F,CL		; minute
	MOV	second_260,DH		; second
	MOV	decisec_261,DL		; decisecond
	XOR	CH,CH			;clear msb
	MOV	CL,DS:80H		;DOS PSP cmd line length byte
	CMP	CX,1			;1 char or less?
	ja	Cmd_Ok			; long enough maybe,continue
	  mov	dx,offset usageMsg	;explain how
	  jmp	Die_0			;display, terminate

Cmd_Ok:
	MOV	DI,81H			;point to first char on cmd line
	CLD				;insure fwd
	MOV	AL,20H			;scan for a space
	REPZ	SCASB
	DEC	DI			;back up to actual cmd line start
	INC	CX			;adjust where the space is
	XOR	AX,AX			;clear ax
	xor	bx,bx			;clear msb
CmdLine_Loop:
	JCXZ	L0309			;cx is zeroed out, skip
	MOV	BL,[DI]			;snarf cmd line char
	CMP	BL,'0'			;legal digit?
	JL	L0309			; nope, less
	CMP	BL,'9'			;legal digit?
	JG	L0309			; nope, greater
	SUB	BL,30H			;deasciify
	MOV	DX,0AH			;multiplier
	MUL	DX			;ax *10
	ADD	AX,BX			;add in the 1's digit
	DEC	CX			;decrement cmd line char counter
	INC	DI			;bump cmd line char pointer
	JMP	SHORT	CmdLine_Loop	; and reloop

L0309:	PUSH	AX			;save decimal time value a sec
	MOV	AL,' '			;scan for a space
	REPZ	SCASB
	MOV	BX,CX			;use as offset
	MOV	BYTE PTR [BX+DI],'$'	;terminate cmd line as a string
	DEC	DI			;adjust pointer
	POP	AX			;restore
	or	ax,ax			;zero time delay?
	JNZ	L031D			; nope, got some sort of delay
	 MOV	AX,14H			;force to 20 seconds minimum
L031D:	ADD	AL,second_260		;add in start second
	XOR	BX,BX			;clear msb
	MOV	BL,minute_25F		;start minute
	XOR	CX,CX			;clear msb
	MOV	CL,hour_25E		;start hour
	XOR	DX,DX			;clear msb
	MOV	DL,day_25D		;start day
Lup333:	CMP	AX,3CH			;target seconds <60?
	JL	Lup33E			; ok, legal
	 SUB	AX,3CH			;adjust seconds (-60)
	 INC	BX			;bump target minutes
	 JMP	SHORT	Lup333		; and reloop

Lup33E:	CMP	BX,3CH			;target minutes <60?
	JL	Lup349			; ok, legal
	 SUB	BX,3CH			;adjust minutes (-60)
	 INC	CX			;bump target hours
	 JMP	SHORT	Lup33E		; and reloop

Lup349:	CMP	CX,18H			;target hours <24?
	JL	Lup354			; ok, legal
	 SUB	CX,18H			;adjust -24
	 INC	DX			;bump target days
	 JMP	SHORT	Lup349		; and reloop

Lup354:	CMP	DX,7			;target days <7? (max delay is 1 week)
	JL	L035E			; ok, legal
	 SUB	DX,7			;adjust target day (-7)
	 JMP	SHORT	Lup354		; and reloop

L035E:	MOV	second_260,AL		;save target seconds to go
	MOV	minute_25F,BL		; and minutes
	MOV	hour_25E,CL		; and hours
	MOV	day_25D,DL		; and days
	MOV	CH,CL			;move hours to CH
	MOV	CL,BL			; move minutes to CL
	MOV	DH,AL			; move seconds to DH
	CALL	Time_To_Seconds		;convert time to seconds
	MOV	word_264,AX		;and save here
	MOV	DX,DI			;question to ask (from cmd line)
	MOV	AH,9			;display question
	INT	21H
	MOV	AH,2			;output char
	MOV	DL,' '			; a space
	INT	21H
;Now we wait for the user to respond (up to a week!)
TimeLoop:
	MOV	AH,0BH			;check kbd status
	INT	21H
	or	al,al			;anything there?
	JZ	L03BC			; Nope
	MOV	AH,8			; yep, read the kbd
	INT	21H			;(response in AL)
	CMP	AL,CR			;did he answer w/just RETURN?
	JZ	Die_NoAnswer		; yep, die with "No answer"
	CMP	AL,1BH			;did he answer w/escape char?
	JZ	Die_NoAnswer		; yep, die with "No answer"
	AND	AL,5FH			;uppercase response
	CMP	AL,'Y'			;did he answer Yes?
	JZ	DieYes			; yep, exit
	CMP	AL,'N'			;did he answer No?
	JZ	DieNo			; yep, exit

	MOV	DL,7			;bell
	MOV	AH,2			;display char
	INT	21H

	CMP	BYTE PTR bflag_262,0	;have we prompted yet?
	JNZ	L03BC			; yep, skip the prompt
	 MOV	DX,OFFSET promptStr	;'Y or N' prompt
	 mov	ah,9			;display string
	 INT	21H
	 MOV	BYTE PTR bflag_262,1	;flag we've prompted

L03BC:	MOV	AH,2CH			;get system time
	INT	21H
	CMP	AL,day_25D		;target day?
	JG	Die_NoAnswer		; timed out, die
	JL	L03E6			; less, passed thru Sunday, go recalc
	CMP	CH,hour_25E		;compare now with start hour
	JG	Die_NoAnswer		; greater, timed out, exit
	JL	L03E6			; less, past midnight, go recalc
	CMP	CL,minute_25F		;compare now with start minute
	JG	Die_NoAnswer		; greater, timed out, exit
	JL	L03E6			; less, went to new hour, go recalc
	CMP	DH,second_260		;compare now with start second
	JG	Die_NoAnswer		; greater, timed out, exit
	JL	L03E6			; less, went to new minute
	CMP	DL,decisec_261		;compare now with start decisecond
	JG	Die_NoAnswer		; greater, timed out, exit
L03E6:	CALL	Compare_Time		;check time, display counter
	JMP	SHORT	TimeLoop

DieNo:	MOV	DX,OFFSET noStr		;'No'
	MOV	AH,9			;display string
	INT	21H
Die_3F2:
	mov	ax,4C01H		;Terminate, Errorlevel 1
	INT	21H

DieYes:	MOV	DX,OFFSET yesStr	;'Yes'
;enter here with string ofs in dx
Die_0:					;enter here with String ofs in DX
	MOV	AH,9			;display string
	INT	21H
	mov	ax,4C00H		;Terminate, Errorlevel 0
	INT	21H

Die_NoAnswer:
	MOV	DX,OFFSET noAnswerStr	;'No answer given'
	MOV	AH,9
	INT	21H
	mov	ax,4C02H		;Terminate, Errorlevel 2
	INT	21H
Start	endp

CodeSeg	ENDS
	END	Task
