'
'  SIMPLE.BAS Example Program
'

'$INCLUDE: 'PCL4VB.BI'

 Buf256$ = STRING$(256+16,0)   'Must be 1st string statement
 BufSeg = (1+SSEG(Buf256$)) + (SADD(Buf256$) \ 16)

 CONST FALSE = 0, TRUE = NOT FALSE
 CONST CTLZ = 26
 DIM RATES$(12)

 RATES$(1) = "300"
 RATES$(2) = "600"
 RATES$(3) = "1200"
 RATES$(4) = "2400"
 RATES$(5) = "4800"
 RATES$(6) = "9600"
 RATES$(7) = "19200"
 RATES$(8) = "38400"
 RATES$(9) = "57600"
 RATES$(10) = "115200"

 PARMS$ = RTRIM$(COMMAND$)
 I = INSTR(PARMS$, " ")
 IF I < 1 THEN
   PRINT "  Usage: SIMPLE <Port> <BaudRate>"
   PRINT "Example: SIMPLE 1 9600"
   END
 END IF
 L = LEN(PARMS$)
 ARG1$ = LEFT$(PARMS$, I - 1)
 ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
 BaudCode = -1
 'Get COM port
 Port = VAL(ARG1$) - 1
 'Get baud code
 FOR I = 1 TO 10
   IF RATES$(I) = ARG2$ THEN
      BaudCode = I - 1
      EXIT FOR
   END IF
 NEXT I
 'Verify good baud rate
 IF BaudCode = -1 THEN
   PRINT "Cannot recognize baud rate "; ARG2$
   END
 END IF
 'Reset port
 Code = SioRxBuf(Port, BufSeg, Size256)
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioRxBuf()"
   Code = SioError(Code)
   END
 END IF
 Code = SioReset(Port, BaudCode)
 CLS
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioReset()"
   Code = SioError(Code)
   END
 END IF

 PRINT "SIMPLE 5/5/95"
 PRINT " "
 LIBVER = SioInfo(ASC("V"))
 PRINT "Library Version: "; LIBVER \ 16; ".";
 PRINT LIBVER - 16 * (LIBVER \ 16)

 PRINT "Entering TERMINAL loop (^Z to exit)..."

 Code = SioDTR(Port, SET_LINE)
 Code = SioRTS(Port, SET_LINE)
 DO
   'Look at incoming serial
   Code = SioGetc(Port, 1)
   IF Code > -1 THEN
     Code = SioCrtWrite(Code)
   END IF
   'Anything to send
   AnyKey$ = INKEY$
   IF AnyKey$ <> "" THEN Code = SioPutc(Port, ASC(AnyKey$))
   IF AnyKey$ = CHR$(CTLZ) THEN EXIT DO
 LOOP

 PRINT "User typed ^Z"
 Code = SioDone(Port)

 END


                                   