'
'  Login.BAS Example Program
'

'$INCLUDE: 'PCL4VB.BI'
'$INCLUDE: 'MODEM_IO.BI'

 DEFINT A-Z

 DECLARE SUB MyExit (Port)
 DECLARE FUNCTION Login (Port, Send$, Pace, Expect$, Tics)

 Buf256$ = STRING$(256+16,0)  'must be 1st string statement
 BufSeg = (1+SSEG(Buf256$)) + (SADD(Buf256$) \ 16)

 CONST FALSE = 0
 CONST TRUE = NOT FALSE
 CONST CTLZ = 26
 CONST ONE_SEC = 18
 CONST Debug = TRUE

 DIM RATES$(12)

 RATES$(1) = "300"
 RATES$(2) = "600"
 RATES$(3) = "1200"
 RATES$(4) = "2400"
 RATES$(5) = "4800"
 RATES$(6) = "9600"
 RATES$(7) = "19200"
 RATES$(8) = "38400"
 RATES$(9) = "57600"
 RATES$(10) = "115200"

 PARMS$ = RTRIM$(COMMAND$)
 I = INSTR(PARMS$, " ")
 IF I < 1 THEN
   PRINT "  Usage: Login <Port> <BaudRate>"
   PRINT "Example: Login 1 9600"
   END
 END IF
 L = LEN(PARMS$)
 ARG1$ = LEFT$(PARMS$, I - 1)
 ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
 BaudCode = -1
 'Get COM port
 Port = VAL(ARG1$) - 1
 'Get baud code
 FOR I = 1 TO 10
   IF RATES$(I) = ARG2$ THEN
      BaudCode = I - 1
      EXIT FOR
   END IF
 NEXT I
 'Verify good baud rate
 IF BaudCode = -1 THEN
   PRINT "Cannot recognize baud rate "; ARG2$
   END
 END IF
'Reset port
 Code = SioRxBuf(Port, BufSeg, Size256)
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioRxBuf()"
   Code = SioError(Code)
   END
 END IF
 Code = SioReset(Port, BaudCode)
 CLS
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioReset()"
   Code = SioError(Code)
   END
 END IF

 PRINT "Login 5/5/95"
 PRINT " "
 LIBVER = SioInfo(ASC("V"))
 PRINT "Library Version: "; LIBVER \ 16; ".";
 PRINT LIBVER - 16 * (LIBVER \ 16)

 Code = SioDTR(Port, SET_LINE)
 Code = SioRTS(Port, SET_LINE)

 'send "AT" to modem & expect "OK" back
 IF NOT Login(Port, "!AT!", 5, "OK", 180) THEN MyExit (Port)
 'initialize modem & expect "OK" back
 IF NOT Login(Port, "AT E1 S7=60 S11=60 V1 X1 Q0!", 5, "OK", 5*ONE_SEC) THEN MyExit (Port)
 'send "ATDT1,205,880,9748" & expect "CONNECT" back
 IF NOT Login(Port, "ATDT1,205,880,9748!", 5, "CONNECT", 60*ONE_SEC) THEN MyExit (Port)
 ' log on as GUEST
 IF NOT Login(Port,"!",Pace,"graphics (y/N)?",30*ONE_SEC) THEN MyExit(Port)
 IF NOT Login(Port,"!",Pace,"LAST name:",10*ONE_SEC) THEN MyExit(Port)
 IF NOT Login(Port,"GUEST GUEST!",Pace,"password:",10*ONE_SEC) THEN MyExit(Port)
 IF NOT Login(Port,"GUEST!",Pace,"",10*ONE_SEC) THEN MyExit(Port)

 PRINT "Entering TERMINAL loop (^Z to exit)..."

 DO
   'Look at incoming serial
   Code = SioGetc(Port, 1)
   IF Code > -1 THEN
     Code = SioCrtWrite(Code)
   END IF
   'Anything to send
   AnyKey$ = INKEY$
   IF AnyKey$ <> "" THEN Code = SioPutc(Port, ASC(AnyKey$))
   IF AnyKey$ = CHR$(CTLZ) THEN EXIT DO
 LOOP

 PRINT "User typed ^Z"
 MyExit (Port)

 END

 FUNCTION Login (Port, Send$, Pace, Expect$, Tics)
 Login = TRUE
 Send$ = LTRIM$(Send$)
 Expect$ = LTRIM$(Expect$)
 IF Debug THEN
   PRINT
   PRINT "Sending '";Send$;"'"
   IF Expect$ <> "" THEN
     PRINT "Awaiting '";Expect$;"'"
   END IF
 END IF
 IF Expect$ = "" THEN
   rc = ModemSendTo(Port, Pace, Send$)
 ELSE
   rc = ModemSendTo(Port, Pace, Send$)
   IF NOT ModemWaitFor(Port, Tics, FALSE, Expect$) THEN
     PRINT "'";Expect$;"' not received"
     Login = FALSE
   END IF
 END IF
 END FUNCTION

 SUB MyExit (Port)
 rc = SioDone(Port)
 END
 END SUB

                                                                              