separate(MatrixO)
task body Multiplier_Task is
  North, East, South, West: Channels;
  X, Sum, A: Integer;
begin
  accept Init(Coeff: Integer; T: Task_Ptr) do
    A := Coeff;
    North := T.North; East := T.East; 
    South := T.South; West := T.West;
    Channel(North).Destination(T, T.North);
    Channel(East) .Destination(T, T.East);
  end Init;
  for N in 1..Size loop
      accept Input(North)(I: in Integer) do
        X := I;
      end Input;
      Channel(South).Output(X);
      accept Input(East) (I: in Integer) do
        Sum := I;
      end Input;
      Sum := Sum + A*X;
      Channel(West).Output(Sum);
  end loop;
end Multiplier_Task;

separate(MatrixO)
task body Source_Task is
  South: Channels;
  Vec: Vector;
begin
  accept Init(V: Vector; T: Task_Ptr) do
    Vec := V;
    South := T.South;
  end Init;
  for N in 1..Size loop
    Channel(South).Output(Vec(N));
  end loop;
end Source_Task;

separate(MatrixO)
task body Sink_Task is
  North: Channels;
begin
  accept Init(T: Task_Ptr) do
    North := T.North;
    Channel(North).Destination(T, T.North);
  end Init;
  for N in 1..Size loop
    accept Input(North)(I: in Integer);
  end loop;
end Sink_Task;

separate(MatrixO)
task body Zero_Task is
  West: Channels;
begin
  accept Init(T: Task_Ptr) do
    West := T.West;
  end Init;
  for N in 1..Size loop
    Channel(West).Output(0);
  end loop;
end Zero_Task;

with Text_IO; use Text_IO;
separate(MatrixO)
task body Result_Task is
  East: Channels;
  Ident: Integer;
begin
  accept Init(ID: Integer; T: Task_Ptr) do
    Ident := ID;
    East := T.East;
    Channel(East).Destination(T, T.East);
  end Init;
  for N in 1..Size loop
    accept Input(East)(I: in Integer) do
      Put_Line(Integer'Image(Ident) & Integer'Image(N) &
               Integer'Image(I));
    end Input;
  end loop;
end Result_Task;

separate(MatrixO)
task body Channel_Task is
  T:  Task_Ptr;
  Ch: Channels;
  Save: Integer;
  Invalid_Channel: exception;
begin
  accept Destination(T_Ptr: Task_Ptr; Chan: Channels) do
    T  := T_Ptr;
    Ch := Chan;
  end Destination;    
  loop
    select
      accept Output(I: in Integer) do
        Save := I;
      end Output;
    or
      terminate;
    end select;
    case T.Task_Type is
      when Multiplier => T.M.Input(Ch)(Save);
      when Source     => raise Invalid_Channel;
      when Sink       => T.T.Input(Ch)(Save);
      when Zero       => raise Invalid_Channel;
      when Result     => T.R.Input(Ch)(Save);
    end case;
  end loop;
end Channel_Task;
