WITH Ada.Text_IO, My_Int_IO; USE Ada.Text_IO, My_Int_IO;

PROCEDURE QSort IS -- 26-12-93
    TYPE Data_Type IS ARRAY(Integer RANGE <>) OF Integer;
    Data : Data_Type(1..20) := (10, 9, 8, 7, 6, 5, 4, 3, 2, 1  
                               , 0,-1,-2,-3,-4,-5,-6,-7,-8,-9);

    PROCEDURE Swap(X, Y : IN OUT Integer) IS
        Temp : Integer;
    BEGIN
        Temp := X;
        X := Y;
        Y := Temp;
    END Swap;
    
    PROCEDURE Find_Pivot(Left : Integer; Right : Integer; Pivot : OUT Integer) IS

        FirstKey  : Integer := Data(Left);

    BEGIN
        Pivot := 0;
        FOR Up IN Left+1 .. Right LOOP
            IF Data(Up) > FirstKey THEN
                Pivot := Up;
                EXIT;
            ELSIF Data(Up) < FirstKey THEN
                Pivot := Left;
                EXIT;
            END IF;
        END LOOP;
            
    END Find_Pivot;

    PROCEDURE Partition(Left, Right : Integer;
                        Pivot : Integer; 
                        Partition_Point : OUT Integer) IS
                            
	Up   : Integer := Left;
	Down : Integer := Right;
    BEGIN
        LOOP            
            Swap(Data(Up),Data(Down));
            WHILE Data(Up) < Pivot LOOP
                Up := Up + 1;
            END LOOP;
                
            WHILE Pivot <= Data(Down) LOOP
                Down := Down - 1;
            END LOOP;
                
            EXIT WHEN Up > Down;
                
        END LOOP;
            
        Partition_Point := Up;
            
    END Partition;

    PROCEDURE CQuick_Sort(Left, Right : Integer) IS

        Pivot_Point     : Integer;
        Pivot           : Integer;
        Partition_Point : Integer;
       
    BEGIN

        Find_Pivot(Left,Right,Pivot_Point);

        IF Pivot_Point /= 0 THEN

            Pivot := Data(Pivot_Point);
            Partition(Left,Right,Pivot,Partition_Point);

            DECLARE  

                TASK TYPE CQSort IS
                    ENTRY Start(First, Last : Integer);
                END;
		
		CQSort_Left, CQSort_Right : CQSort;

                TASK BODY CQSort IS
                    First_B, Last_B : Integer;    
                BEGIN
        
                    ACCEPT Start(First, Last : Integer) DO
                        First_B := First;
                        Last_B  := Last;
                    END Start;
                    IF First_B < Last_B THEN
	                    CQuick_Sort(First_B , Last_B);
	            END IF;
                END;

            BEGIN
            
                CQSort_Right.Start(Partition_Point,Right);
                CQSort_Left .Start(Left,Partition_Point - 1);
                
            END;
        END IF;

    END CQuick_Sort;
        
BEGIN

    FOR I IN Data'RANGE LOOP        
        Put(Data(I),3);
    END LOOP;

    New_Line;

    CQuick_Sort(Data'First , Data'Last);

    FOR I IN Data'RANGE LOOP        
        Put(Data(I),3);
    END LOOP;

    New_Line;
END QSort;