-- UNIX.ADA   Ver. 3.00   22-AUG-1994   Copyright 1988-1994 John J. Herro
-- Software Innovations Technology
-- 1083 Mandarin Drive NE, Palm Bay, FL  32905-4706   (407)951-0233
--
-- Compile this before compiling ADA_TUTR.ADA on a UNIX based system.  You must
-- also compile ONECHAR.C or ALTCHAR.C with a C compiler before linking.  See
-- first page of ADA_TUTR.ADA for more details.
--
with Text_IO;
package Custom_IO is
   type Color is (Black, Red, Green, Yellow, Blue, Magenta, Cyan, White);
   Foregrnd_Color   : Color := White;                 -- Default values in case
   Backgrnd_Color   : Color := Black;                 -- ADA-TUTR finds no User
   Border_Color     : Color := Black;                 -- File.
   Fore_Color_Digit : Character := Character'Val(Color'Pos(Foregrnd_Color)+48);
   Back_Color_Digit : Character := Character'Val(Color'Pos(Backgrnd_Color)+48);
   Normal_Colors    : String(1 .. 10) := ASCII.ESC & "[0;3" &
                              Fore_Color_Digit & ";4" & Back_Color_Digit & "m";
   Clear_Scrn       : constant String := ASCII.ESC & "[H" & ASCII.ESC & "[2J";

   procedure Set_Border_Color (To   : in  Color);
   procedure Get              (Char : out Character);
   procedure Put              (Char : in  Character) renames Text_IO.Put;
   procedure Put              (Str  : in  String)    renames Text_IO.Put;
   procedure Put_Line         (Str  : in  String)    renames Text_IO.Put_Line;
   procedure Get_Line         (Str  : out String;
                               Last : out Natural)   renames Text_IO.Get_Line;
   procedure New_Line      (Spacing : in  Text_IO.Count := 1)
                                                     renames Text_IO.New_Line;
end Custom_IO;

package body Custom_IO is
   procedure Set_Border_Color(To : in Color) is
      -- Dummy procedure for computers other than PCs.
   begin
      null;
   end Set_Border_Color;

   procedure Get(Char : out Character) is
      function Onechar return Character;
      pragma Interface (C, Onechar);            -- Pragma Interface is used for
   begin                                        -- compatibility with Ada 83.
      Char := Onechar;
   end Get;
end Custom_IO;
