type fichier =
     record
        dir : string[15];
        filename : string[12];
        size : longint;
        date : string[8];
        desc : string[60];
     end;

var ligne, dir : string;
    i : integer;
    fich : text;
    content : text;
    page : text;
    nbpage : integer;
    nbpagetxt : string;
    f : fichier;
    acontent : array [1..500] of string[30];
    ncontent : integer;
    first : boolean;

function fieldstr(ligne : string; var p : integer):string;

var tmp : string;
    break : boolean;

begin
   tmp:='';
   if ligne[p]='"' then p:=p+1;
   break:=false;
   while (p<=byte(ligne[0])) and not(break) do
   begin
      if (ligne[p]='"')
      then break:=true
      else tmp:=tmp+ligne[p];
      p:=p+1;
   end;
   fieldstr:=tmp;
   if p<byte(ligne[0]) then p:=p+1;
end;

function fieldnum(ligne : string; var p : integer):string;

var tmp : string;
    break : boolean;

begin
   tmp:='';
   break:=false;
   while (p<=byte(ligne[0])) and not(break) do
   begin
      if (ligne[p]=',')
      then break:=true
      else tmp:=tmp+ligne[p];
      p:=p+1;
   end;
   fieldnum:=tmp;
end;

function stripdir(ligne : string; p : integer):string;

var tmp : string;
    break : boolean;

begin
    tmp:='';
    break:=false;
    while (p>=1) and not(break) do
    begin
       if ligne[p]='/'
          then break:=true
          else tmp:=ligne[p]+tmp;
       p:=p-1;
    end;
    stripdir:=tmp;
end;

procedure decomp(ligne : string; var f : fichier);

var position : integer;
    status : integer;
    skip : string;

begin
   position:=1;
   skip:=fieldstr(ligne, position);
   f.dir:=fieldstr(ligne, position);
   f.filename:=fieldstr(ligne, position);
   skip:=fieldnum(ligne, position);
   val(fieldnum(ligne, position), f.size, status);
   skip:=fieldnum(ligne, position);
   f.date:=fieldnum(ligne, position);
   f.desc:=fieldstr(ligne, position);
end;

procedure header(var page : text; dir : string);

begin
    writeln(page, '<title>Directory : '+stripdir(dir, length(dir)-1)+' on '+sitedesc+'</title>');
    writeln(page, '<hr><h2>Files available in directory '+stripdir(dir, length(dir)-1)+'</h2><p>');
    writeln(page,' <a href="ftp://'+site+'/'+rootdir+'/'+dir+indexfile+'">Index file</a><hr><p><ul>');
end;

procedure generate(var page : text; f : fichier);

begin
    write(page, '<li><a href="ftp://'+site+'/'+rootdir+'/');
    writeln(page, f.dir+f.filename+'">'+stripdir(f.filename, integer(f.filename[0]))
                  +'</a> ',f.desc,' (size : ',f.size,', date : ',f.date,')');
end;

procedure trailer(var page : text);

const days : array [0..6] of String[9] =
    ('Sunday','Monday','Tuesday',
     'Wednesday','Thursday','Friday',
     'Saturday');

var
  y, m, d, dow : Word;

begin
   writeln(page, '</ul><hr>');
   GetDate(y,m,d,dow);
   writeln(page,'<p><i>Generated on  ', days[dow], d:0, '/', m:0, '/', y:0,' by IDX2HTML</i></p>');
   write(page,problem1);
   write(page,problem2);
   write(page,'<a href="http://www.info.fundp.ac.be/~vdh/">Vincent D''Haeyere</a>');
   writeln(page,' - Copyright 1995 - Contact me to freely get IDX2HTML</p></address>');
end;

procedure ContentPage;

var i : integer;
    pagetxt : string;

begin
     assign(content, outputdir+contentfile);
     rewrite(content);
     writeln(content,'<title>'+sitedesc+'</title>');
     writeln(content,'<h1>'+sitedesc+'</h1>');
     write(content,'<hr><p>The following software is available from the ftp site <b>'+site+'</b></p>');
     write(content,'<p><i><font size="+2">Please, remember that ftp is a privilege. Don''t abuse it !</font></i></p><hr>');
     writeln(content,'<ul>');
     for i:=1 to ncontent do
     begin
          str(i, pagetxt);
          write(content,'<li><a href="http://'+homewww+'/'+prefixpage+pagetxt+'.html"');
          writeln(content,'>'+stripdir(acontent[i], length(acontent[i])-1)+'</a>');
     end;
     trailer(content);
     close(content);
end;
