/*
Renumber WAFFLE mails
(c) 1991 Budi Rahardjo <budi@bison.mb.ca>
*/

#include <stdio.h>
#include <ctype.h>
#include <dos.h>
#include <errno.h>
#include <io.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>

/*
#define DEBUG
*/
#define MAXFILES 512
#define VERBOSE
#define VERSION "0.1"

int extension[MAXFILES];
int nfiles;
int sorted[MAXFILES];

main(argc,argv)
int argc;
char **argv;
   {
   int i;

   printf("renumf v.%s (c) 1991 Budi Rahardjo <budi@bison.mb.ca>\n", VERSION);
   if (argc < 2) { usage(); exit(-1); }
   getlist(argv[1]);
   sort();
   renaming(argv[1]);
   exit(0);
   } /* end of main */

/* rename the files */
renaming(basename)
char *basename;
   {
   int i,index,result;
   char *old, *new;
   old = (char*)calloc(strlen(basename)+4,sizeof(char));
   new = (char*)calloc(strlen(basename)+4,sizeof(char));
   if ((old == NULL)||(new==NULL)) { 
      printf("renumf: insufficient memory\n");
      exit(-1); }
#ifdef DEBUG
   printf("debug: renaming:\n");
#endif
   for (i=1;i<=nfiles;i++)  {
      index = sorted[i-1];
      sprintf(old,"%s.%d", basename,extension[index]);
      sprintf(new,"%s.%d", basename,i);
#ifdef VERBOSE
      printf("renumf: renaming %s to %s\n", old, new);
#endif
      result = rename(old,new);
      switch (result) {
         case EACCES : printf("renumf: file %s already exists\n", new); break;
         case ENOENT : printf("renumf: file %s not found\n", old); break;
         default: break;
         }
      }
   }

/* Sort the files in ascending order                 */
/* This routine is not an efficient - modified later */
sort()
   {
   int i,ii,j,k,temp;
   int ti;
#ifdef DEBUG
   printf("debug: sorting\n");
#endif
   for (i=0 ; i < nfiles ; i++) { sorted[i]=i; }
   for (ii=0 ; ii < nfiles ; ii++) {
   for (i=0 ; i < (nfiles-1) ; i++) {
      j = sorted[i]; k = sorted[i+1];
      if (extension[j] > extension[k]) {
         temp = sorted[i+1]; sorted[i+1]=sorted[i]; sorted[i]=temp;
         }
/*
      for (ti=0 ; ti <nfiles ; ti++) printf("%4d", sorted[ti]);
      printf("\n");
      for (ti=0 ; ti <nfiles ; ti++) printf("%4d", extension[sorted[ti]]);
      printf("\n");
*/
      } /* end of i loop */
      }
   }

/* Get a list of files with "file.*" as the mask */
/* Ignore non numeric extention                  */
getlist(file)
char *file;
   {
   char *fname;
   struct find_t files;
   int dotpos, extval;

   nfiles = 0;
   fname = (char*)calloc(strlen(file)+4,sizeof(char));
   if (fname == NULL) { printf("renumf: insufficient memory\n"); exit(-1); }
   sprintf(fname,"%s.*",file);
   /* DO ERROR CHECKING IF NOT FOUND */
   if (_dos_findfirst(fname, _A_NORMAL, &files) != 0) {
      printf("renumf: file not found\n");
      exit(-1); }
   dotpos = strlen(file);
   extval = getnumber(files.name,dotpos);
   if (extval >= 0) {
      extension[nfiles] = extval;
#ifdef DEBUG
      printf("debug: %s (%d)\n", files.name, extension[nfiles]); 
#endif
      nfiles++; }
   else {
#ifdef DEBUG
      printf("debug: %s NOT PROCESSED\n", files.name);
#endif
      }
   while (_dos_findnext(&files) == 0) {
      extval = getnumber(files.name,dotpos);
      if (extval >=0 ) {
         extension[nfiles]=getnumber(files.name,dotpos);
#ifdef DEBUG
         printf("debug: %s (%d)\n", files.name, extension[nfiles]);
#endif
         nfiles++; }
      else {
#ifdef DEBUG
         printf("debug: %s NOT PROCESSED\n", files.name);
#endif
         }
      } /* end while */
   } /* end of "getlist()" */


/* get the number in the extension          */
/* return -1 if the extension is not number */
getnumber(string,start)
char *string;
int start;
   {
   char chnum[4];
   int i,j;
   if (start == strlen(string)) { return(-1); }
   j = 0;
   for (i=start+1 ; i < strlen(string) ; i++) {
      if ( string[i] < 48) { return(-1); }
      if ( string[i] > 57) { return(-1); }
      chnum[j] = string[i]; j++;
      }
   return(atoi(chnum));
   }

int usage()
   {
   printf("usage   : renumf filename\n");
   printf("          Renumber Waffle Mails\n");
   printf("Example : renumf budi\n");
   printf("          will renumber budi.* files\n");
   printf("(c) 1991  Budi Rahardjo <budi@bison.mb.ca>\n");
   }
