{$A+,B-,D+,E+,F-,I+,L+,N-,O-,R-,S+,V-}
{$M 16384,0,655360}
program Put_new_boot_sector_in_drive_A;
{(C) Copyright A. Merckens 1989}
{DO NOT MODIFY IN ANY WAY}

uses Crt, Dos;

type
  cluster_size = array [0..511] of byte;

var
  reg: registers;
  buffer, buffer2: cluster_size;
  f: file;
  i, j, track, sector, head: integer;
  disk: byte;
  filename: string ;
  ch: char;

procedure abort(code: integer; s: string );
begin
  writeln; writeln(s);
  if code = 1 then
  begin
  writeln('Call: BOOTPUT [filenaam] - see manual');
  end;
  halt(255);
end;

procedure write_sector_to_drive(drive, track, sector, head: integer;
                                 var buffer: cluster_size);

begin
  if drive > 0 then abort(0, 'You must be out of your mind!');
  reg.ah := 3; reg.al := 1; reg.ch := track; reg.cl := sector; {sector nummer}
  reg.dh := head; reg.dl := drive; reg.es := seg(buffer); reg.bx := ofs(buffer);
  intr($13, reg);
  if (reg.flags and 1) = 1 then
    if reg.dl < 80 then
      abort(0,'Disk read error: disk in drive? ')
    else
      abort(0,'Disk read error');
end;

begin
  clrscr;
  highvideo;
  write('BOOTPUT 1.0 -  Put bootsector on floppy in drive A  - (C) A. Merckens 1989');
  normvideo;
  gotoxy(1,2);
  If Paramcount > 1 then abort(1, 'Too many parameters specified.');

  If Paramcount = 1 then
  Begin
    filename := paramstr(1);

  End
  Else abort(1, 'Not enough parameters specified.');

  disk := 0 ; {the A-drive. CAUTION: do not modify!!!}

  writeln('file ', filename,' ---> bootsector of disk in drive A');
  
  assign(f, filename);
  {$I-}
  reset(f, 1); {$I+}

  If Ioresult <> 0 then
    abort(0, concat('The file ', filename, ' is not found'));

  if (filesize(f) > 512) or (filesize(f)<100) then
     abort(0, 'Wrong filename given.');

  blockread(f, buffer, 512, j); {bootsector};

  writeln;
  write('System name to save','':9+length(filename),': ');
  highvideo;
  for j := $3 to $A do write(char(buffer[j]));
  normvideo;

  writeln; write('Do you wish to save this file on the bootsector of drive A?  ');
  repeat ch := UpCase(readkey) until ch in ['Y','N']; write(ch);
  if ch = 'N' then abort(0,'bootsector NOT overwritten');

  write_sector_to_drive(disk, 0, 1, 0, buffer);

  close(f);

end.
