/*
	SNEWS 1.91

	addgroup - add a new newsgroup to the newsbase


    Copyright (C) 1991  John McCombs, Christchurch, NEW ZEALAND
                        john@ahuriri.gen.nz
                        PO Box 2708, Christchurch, NEW ZEALAND

	Modifications copyright (C) 1993  Daniel Fandrich
						<dan@fch.wimsey.bc.ca> or CompuServe 72365,306

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 1, as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    See the file COPYING, which contains a copy of the GNU General
    Public License.


	Source is formatted with a tab size of 4.

 */

#include <io.h>
#include <ctype.h>
#include "defs.h"
#include "getopt.h"

INFO my_stuff;


/*---------------------------- main ---------------------------------------*/
void main(int argc, char *argv[])
{
    /*
     *  Add newsgroups.  All that has to be done is stick the new
     *  group in the active file, after checking that is doesn't
	 *  already exist.  'It aint pretty, but it works.
     */

	char   buf[256], buf2[256], *p, txt_name[20];
	char   group_name[128];
	int    added;
	int	   i;
	int	   post = 'y';		/* default posting status */
	int    local = FALSE;	/* local group (not remote) */
	time_t t, tlast = 0;
    ACTIVE *gp;
    FILE   *tmp;
    FILE   *active_file, *new_active_file;

	signal(SIGINT, sig_break);		/* turn control-break off */

    fprintf(stderr, "ADDGROUP: (%s)\n\n", VERSION);

	if ((argc < 2) || ((argv[1][0] == '-') || (argv[1][0] == '/')) && ((argv[1][1] == '?') || (argv[1][1] == 'h'))) {
		printf("usage: addgroup [-y] [-n] [-m] [-l] [-r] group.name [...]\n");
		exit(2);
	}

        if (!load_stuff()) {
            fprintf(stderr, "Couldn't read rc info\n");
        }

        /*
         *  Check for active file.  If there is none:
         *    - create it with a single entry 'junk'.
         *    - ensure that the newsbase directory exists
         *    - create an empty junk text file and index file
         */
        sprintf(buf, "%sactive", my_stuff.news_dir);
        if (access(buf, 0) != 0) {
            active_file = fopen(buf, "wb");
            fprintf(active_file, "junk 00000000 00000000 00000000 y\n");
            fclose(active_file);
        }

        /* ensure that the news base file exists - just try to create it */
        sprintf(buf, "%snewsbase", my_stuff.news_dir);
        mkdir(buf);
        sprintf(buf, "%snewsbase\\00000000", my_stuff.news_dir);
        if (access(buf, 0) != 0) {
            if ((tmp = fopen(buf, "wb")) == NULL) {
                fprintf(stderr, "addgroup: cannot create file %s\n", buf);
                exit(1);
            }
            fclose(tmp);
        }
        sprintf(buf, "%snewsbase\\00000000.idx", my_stuff.news_dir);
        if (access(buf, 0) != 0) {
            if ((tmp = fopen(buf, "wb")) == NULL) {
                fprintf(stderr, "addgroup: cannot create file %s\n", buf);
                exit(1);
            }
            fclose(tmp);
        }

        load_active_file();
        close_active();


		for (i = 1; i < argc; i++) {

		  if (argv[i][0] == '-') {
				switch (argv[i][1]) {
					case 'y':
					case 'n':
					case 'm':
						post=argv[i][1];
						break;

					case 'l':
						local=TRUE;
						break;

					case 'r':
						local=FALSE;
						break;

					default:
						fprintf(stderr, "addgroup: illegal option %s -- aborting\n", argv[i]);
						close_active_file();
						exit(1);
				}
		  } else {

            /* check that the group doesn't already exist */
			strlwr(strcpy(group_name, argv[i]));
			gp = find_news_group(group_name);

			if ((stricmp(group_name, "junk") != 0) &&
              (stricmp(gp->group, "junk") == 0)) {

				printf("addgroup: creating group %s\n", group_name);

                /* open the active file */
                sprintf(buf, "%sactive", my_stuff.news_dir);
                active_file = fopen(buf, "rb");

                /* create new one */
                sprintf(buf, "%sactive.new", my_stuff.news_dir);
                if ((new_active_file = fopen(buf, "wb")) == NULL) {
                    fprintf(stderr, "addgroup: cannot create %s\n", buf);
                    exit(1);
                }

                added = FALSE;
                if (active_file != NULL) {

					/* delay ensures names are different - ahem */
					while (tlast == time(&t))
						sleep(1);		/* be nice under OS/2 & sleep in loop */
					tlast = t;
					sprintf(txt_name, "%ld", t);
                    if (strlen(txt_name) > 8) {
                        strcpy(txt_name, txt_name+(strlen(txt_name)-8));
                    }

                    /*
                     *  Check newbase name is not already used.  If not
                     *  create an empty newsbase and index files.
                     */
                    sprintf(buf, "%snewsbase\\%s", my_stuff.news_dir, txt_name);
                    if (access(buf, 0) != 0) {

                        if ((tmp = fopen(buf, "wb")) == NULL) {
                            fprintf(stderr, "addgroup: cannot create file %s\n", buf);
                            exit(1);
                        }
                        fclose(tmp);
                        sprintf(buf, "%snewsbase\\%s.idx", my_stuff.news_dir, txt_name);
                        if ((tmp = fopen(buf, "wb")) == NULL) {
                            fprintf(stderr, "addgroup: cannot create file %s\n", buf);
                            exit(1);
                        }
                        fclose(tmp);

                    } else {
                        fprintf(stderr, "addgroup: newsbase name collision - try again\n");
                        fclose(new_active_file);
                        unlink(buf);
                        exit(1);
                    }

					/* search for alphabetical position of group name in active file */
                    while (fgets(buf, 255, active_file) != NULL) {

                        strcpy(buf2, buf);
                        p = strtok(buf2, " \t");

						if (local)
							group_name[0] = toupper(group_name[0]);
						if ((stricmp(group_name, p) < 0) && !added) {

						/* found alphabetical position */
							fprintf(new_active_file, "%s %s 00000000 00000000 %c\n",
								group_name, txt_name, post);
                            added = TRUE;
                        }

                        if (fputs(buf, new_active_file) == EOF) {
                            fprintf(stderr, "addgroup: couldn't write new active file\n");
                        }

                    }
                }

				/* group name makes it alphabetically last in file */
                if (!added) {
					if (local)
						group_name[0] = toupper(group_name[0]);
					fprintf(new_active_file, "%s %s 00000000 00000000 %c\n",
								group_name, txt_name, post);
                }

                fclose(active_file);
                fclose(new_active_file);

                sprintf(buf, "%sactive.bak", my_stuff.news_dir);
                unlink(buf);
                sprintf(buf2, "%sactive", my_stuff.news_dir);
                rename(buf2, buf);
                sprintf(buf, "%sactive.new", my_stuff.news_dir);
                rename(buf, buf2);


            } else {
				fprintf(stderr, "addgroup: newsgroup %s already exists\n", group_name);
			}
		  }

		} /* for */

        close_active_file();

}
