/*
 *      getpwent.c: Get next password file entry
 *
 *      Stephen C. Trier
 *      March 26, 1990
 *
 *      This program is in the public domain
 *
 *      Unlike the passwd file on UNIX systems, this password file is
 *      semicolon-delimited.  This is because the colon is used in the
 *      MS-DOS path syntax to designate a drive.
 */

#include <stdio.h>
#include <pwd.h>

extern FILE *_pw_file;

struct passwd *getpwent(void)
{
    static struct passwd temp;

    if ((_pw_file == NULL) && (!pw_openfile(NULL)))
	return NULL;
    if (fscanf(_pw_file, "%[^;];%[^;];%d;%d;%[^;];%[^;];%[^;\n] ", temp.pw_name,
	    temp.pw_passwd, &(temp.pw_uid), &(temp.pw_gid), temp.pw_gecos,
	    temp.pw_dir, temp.pw_shell) == 7)
	return &temp;
    else
	return NULL;
}





