{ Remove garbage characters from a file.  Useful for recovering damaged text }
{ files after disasters. Deletes everything but graphic ascii chars, CR's,   }
{ LF's and tabs.}
{ This is a demo for STRINGS.TPU copyright 1989 by Richard Winkel }
program preen;
uses strings;
const spinner:array[0..3] of char=('/','-','\','|');
type buftype=array[0..$FFF0] of char;
var i,size,inlen,outlen,written:word;
    tr_in,tr_out:string;
    src,dest:^string;
    holdlen:byte;
    holdchar:char;
    buf:^buftype;
    infile,outfile:file;

begin
   if paramcount<>2 then begin
      writeln('Invalid number of parameters.');
      writeln('Syntax: PREEN infile outfile');
      writeln('Preen removes non-printable characters from a file.');
      halt;
   end;
   tr_in:=' '+xrange(#0,#8)+#11+#12+xrange(#14,#31)+xrange(#127,#255);
   tr_out:=#0+left('',length(tr_in)-1,' ');
   assign(infile,paramstr(1));
   assign(outfile,paramstr(2));
   if maxavail>$FFF1 then size:=$FFF1 else size:=maxavail;
   getmem(buf,size);
   reset(infile,1); rewrite(outfile,1);
   repeat
      outlen:=0;
      blockread(infile,buf^[1],size,inlen);
      src:=pointer(buf); dest:=src;
      for i:=1 to inlen div 255 do begin
         write(spinner[i and 3],^M);
         holdchar:=dest^[0];
         src^[0]:=#255;
         dest^:=translate(space(translate(src^,tr_in,tr_out),0),#0,#32);
         holdlen:=byte(dest^[0]);
         outlen:=outlen+holdlen;
         dest^[0]:=holdchar;
         src:=@src^[255];
         dest:=@dest^[holdlen];
      end;
      holdchar:=dest^[0];
      src^[0]:=chr(inlen mod 255);
      dest^:=translate(space(translate(src^,tr_in,tr_out),0),#0,#32);
      outlen:=outlen+byte(dest^[0]);
      dest^[0]:=holdchar;
      blockwrite(outfile,buf^[1],outlen,written);
   until eof(infile) or (written<>outlen);
   write(' ',#8);
   if written<>outlen then writeln('Error writing ',paramstr(2),'.');
   close(infile); close(outfile);
   freemem(buf,size);
end.
