(******************************************************************************
*                                  mouseTest                                  *
* This is a simple test program that shows if the mouse is functions, and     *
* demonstrates basic mouse programming using the mouseLib unit.               *
******************************************************************************)
program mouseTest;

uses 
   mouseLib
   ,Crt
   ,Graph
{$ifdef incDrv}
   ,grDriver
{$endif} {include bgi drivers with programs ... }
   ;

var 
   gradriver,
   grmode : integer;
   errCode : integer;
const
   crsr   : byte = 0;

begin

   setVGATextGraphicCursor;
   initMouse;
   setDefaultHandler(left_button_pressed); 
   { this is needed for the handling of the textGraphic cursor ! }

     clrScr;
     if not (mouse_present) then begin
     { mouse_present was set by the mouseLib initialization code .. }
          write('mouse not installed');
          exit;
     end;
     case mouse_buttons of
          twoButton : writeLn('MicroSoft mouse Mode');
          threeButton : writeLn('PC mouse Mode');
          else writeLn('UnRecognized mouse mode');
     end; {case}
     writeln('MouseLib demo program, (c) 1992, Ron Loewy.');
     writeln;
     writeln('Move Cursor, Press Right & Left buttons together to continue');
     writeln('             Press any mouse button by itself to recognize');
     window(10, 7, 70, 20);
     if (not vgaTextGraphicCursor) then 
      hardwareTextCursor(10,13); { "normal" text cursor }
     showMouseCursor; { display the cursor }
     repeat
         if getButton(leftButton) = buttonDown then begin
            hideMouseCursor;
            writeLn('Left Button Pressed');
            showMouseCursor;
         end;
         if getButton(rightButton) = buttonDown then begin
            hideMouseCursor;
            writeLn('right Button Pressed');
            showMouseCursor;
         end;
         if getButton(middleButton) = buttonDown then begin
            hideMouseCursor;
            writeLn('Middle Button Pressed');
            showMouseCursor;
         end;
     until (getButton(leftButton) = buttonDown) and
           (getButton(RightButton) = buttonDown);
     hideMouseCursor; { we hide the cursor }
     graDriver := detect;
     initGraph(graDriver, grMode, '');
     errCode := graphResult;
     if (errCode <> grOk) then begin
      writeln(graphErrorMsg(errCode));
      halt(88);
     end;
     setMouseGraph; { fix quircks in Herc. graphic card, disable vgaTextGraph mode }
     initMouse; { let the mouse sense it is in graphic mode }
     outTextXY(10, 10, 'MouseLib demo program, (c) 1992, Ron Loewy.');
     outTextXY(10, 30, 'Press the Right Button to END');
     outTextXY(10, 50, 'Press the Left  Button to switch cursor');
     showMouseCursor; { draw the graphic default arrow cursor }
     setDefaultHandler(LEFT_BUTTON_PRESSED + RIGHT_BUTTON_PRESSED);
     repeat 
      repeat until eventHappened; { wait for event handler }
      eventHappened := false; { and clear for next time ... }
      if (getButton(leftButton) = buttonDown) then begin
         inc(crsr);
         if (crsr > 9) then 
            crsr := 0;
         case crsr of
            0 : setArrowCursor;
            1 : setWatchCursor;
            2 : setUpArrowCursor;
            3 : setLeftArrowCursor;
            4 : setCheckMarkCursor;
            5 : setPointingHandCursor;
            6 : setDiagonalCrossCursor;
            7 : setRectangularCrossCursor;
            8 : setHourGlassCursor;
            9 : setNewWatchCursor;
         end; { case }
      end;
     until (getButton(rightButton) = buttonDown);
     hideMouseCursor;
     closeGraph;
     writeln('MouseLib demo program, (c) 1992, Ron Loewy.');
end.
