{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V+}
{$M 8192,0,0}
{ TESTCRC - Simple test program for crc routines.  This program opens the
  file specified in the first command line parameter, computes three
  kinds of CRC, and writes them to stdout in hex.  Then it checks the
  peculiar behavior of the XModem CRC.  E. Floyd [76067,747], 10-29-89. }
Program TestCRC;
Uses CRC;
Const
  BufSize = 32768;
Type
  Str2 = String[2];
  Str4 = String[4];
  Str8 = String[8];
Var
  Crc32 : LongInt;
  InFile : File;
  InBuf : Array[1..BufSize] Of Byte;
  Len, Crc16, CrcArc, SaveCrc : Word;

Function HexByte(b : Byte) : Str2;
Const
  Hex : Array[$0..$F] Of Char = '0123456789abcdef';
Begin
  HexByte := Hex[b Shr 4] + Hex[b And $F];
End;

Function HexWord(w : Word) : Str4;
Begin
  HexWord := HexByte(Hi(w)) + HexByte(Lo(w));
End;

Function HexLong(ww : LongInt) : Str8;
Var
  w : Array[1..2] Of Word Absolute ww;
Begin
  HexLong := HexWord(w[2]) + HexWord(w[1]);
End;

Begin
  If ParamCount < 1 Then Begin
    WriteLn('Run like: TESTCRC <filename>');
    WriteLn('Prints crc16, CrcArc and crc32 in hex');
  End Else Begin
    {$I-}
    Assign(InFile, ParamStr(1));
    Reset(InFile, 1);
    {$I+}
    If IoResult = 0 Then Begin
      Crc16 := 0;            { "XModem" crc starts with zero.. }
      CrcArc := 0;           { ..as does ARC crc }
      Crc32 := $FFFFFFFF;    { 32 bit crc starts with all bits on }
      Repeat
        BlockRead(InFile, InBuf, BufSize, Len);
        Crc16 := UpdateCrc16(Crc16, InBuf, Len);
        CrcArc := UpdateCrcArc(CrcArc, InBuf, Len);
        Crc32 := UpdateCrc32(Crc32, InBuf, Len);
      Until Eof(InFile);
      Close(InFile);
      SaveCrc := Crc16;      { Save near-complete XModem crc for test below }
      FillChar(InBuf, 2, 0); { Finish XModem crc with two nulls }
      Crc16 := UpdateCrc16(Crc16, InBuf, 2);
      Crc32 := Not(Crc32);   { Finish 32 bit crc by inverting all bits }
      WriteLn('Crc16 = ', HexWord(Crc16), ', CrcArc = ', HexWord(CrcArc),
        ', Crc32 = ', HexLong(Crc32));
      { Now test for XModem crc trick - update the near-complete crc with.. }
      Crc16 := Swap(Crc16);  { ..the complete crc in hi:lo order in memory. }
      WriteLn('XModem crc test = ', HexWord(UpdateCrc16(SaveCrc, Crc16, 2)));
      { The result should always be zero }
    End Else WriteLn('Unable to open file ', ParamStr(1));
  End;
End.