/* tiff.h
 *
 * made this version on 88-10-31
 */

/* TIFF data types
 */
#define TIFFBYTE		1
#define TIFFASCII		2
#define TIFFSHORT		3
#define TIFFLONG		4
#define TIFFRATIONAL	5
#define TIFFSIGNED		6
#define TIFFFLOAT		32768/* manufactured type -- not found in TIFF file */

/* TIFF tag constants
 */
#define TGNEWSUBFILETYPE			254
#define TGOLDSUBFILETYPE			255
#define TGIMAGEWIDTH				256
#define TGIMAGELENGTH				257
#define TGBITSPERSAMPLE				258
#define TGCOMPRESSION				259

#define TGPHOTOMETRICINTERPRETATION	262
#define TGTHRESHHOLDING				263
#define TGCELLWIDTH					264
#define TGCELLLENGTH				265
#define TGFILLORDER					266

#define TGDOCUMENTNAME				269
#define TGIMAGEDESCRIPTION			270
#define TGMAKE						271
#define TGMODEL						272
#define TGSTRIPOFFSETS				273
#define TGORIENTATION				274

#define TGSAMPLESPERPIXEL			277
#define TGROWSPERSTRIP				278
#define TGSTRIPBYTECOUNTS			279
#define TGMINSAMPLEVALUE			280
#define TGMAXSAMPLEVALUE			281
#define TGXRESOLUTION				282
#define TGYRESOLUTION				283
#define TGPLANARCONFIGURATION		284
#define TGPAGENAME					285
#define TGXPOSITION					286
#define TGYPOSITION					287
#define TGFREEOFFSETS				288
#define TGFREEBYTECOUNTS			289
#define	TGGRAYUNIT					290
#define	TGGRAYCURVE					291

#define TGRESOLUTIONUNIT			296		/* 87-12-11 */
#define	TGPAGENUMBER				297

#define	TGCOLORRESPONSECURVES		301

#define	TGSOFTWARE					305
#define	TGDATETIME					306

#define TGARTIST					315
#define TGHOSTCOMPUTER				316

#define TGPREDICTOR					317		/* 88-09-19 */
#define	TGWHITEPOINT				318
#define	TGPRIMARYCHROMATICITIES		319
#define	TGCOLORMAP					320


/* TIFF "header" (8 bytes)
 * note: GtTiffHdr plays a little loose with this structure.
 */
typedef struct {
		WORD	thByteOrder;
		WORD	thVersion;
		DWORD	thIfdOffset;
} TIFFHDR, FAR * LPTIFFHDR;

/* IFD entry
 * note: GtTiffEntry plays a little loose with this structure.
 */
typedef struct {
		WORD  deTag;
		WORD  deType;
		DWORD deLength;
		DWORD deVal;
} DIRENTRY, FAR * LPDIRENTRY;

/* prototypes:
 */
RC GtTiffEntry ARGS((PDLOC, WORD, DWORD, DIRENTRY *));
RC GtTiffHdr ARGS((PDLOC, TIFFHDR *));



