/* swap.c - routines to swap (reverse) words and double words
 */
#include "aldtypes.h"
#include "swap.h"

/* swap bytes within words -- overlapping arrays are handled properly
 */
void swab (lpSrc, lpDst, nbytes)
register LPSTR	lpSrc, lpDst;	/* assumed to be word-aligned */
WORD  			nbytes;			/* assumed to be even */
{
		register WORD words;
		union {
			char c[2];
			WORD w;
		} wrd;

		words = nbytes/2;

		if (lpDst <= lpSrc || lpDst >= lpSrc + nbytes) {
			for (; words--; lpSrc += 2) {
				wrd.w = *(WORD FAR *)lpSrc;
				*lpDst++ = *(LPSTR)(wrd.c + 1);	/* W2 doesn't like wrd.c[1] */
				*lpDst++ = *(LPSTR)(wrd.c);
			}
		}
		else {		/* we'll have to go backward */
			lpSrc += nbytes - sizeof(WORD);
			lpDst += nbytes - 1;
			for (; words--; lpSrc -= 2) {
				wrd.w = *(WORD FAR *)lpSrc;
				*lpDst-- = *(LPSTR)(wrd.c);
				*lpDst-- = *(LPSTR)(wrd.c + 1);
			}
		}
}

/* swap words -- overlapping ranges are handled properly
 *
 * actually, does a 4-byte reversal
 */
void swaw (lpSrc, lpDst, nbytes)
register LPSTR	lpSrc, lpDst;	/* assumed to be word-aligned */
WORD  			nbytes;			/* assumed to be multiple of 4 */
{
		register WORD dwords;
		union {
			char c[4];
			DWORD dw;
		} dwrd;

		dwords = nbytes/4;

		if (lpDst <= lpSrc || lpDst >= lpSrc + nbytes) {
			for (; dwords--; lpSrc += 4) {
				dwrd.dw = *(DWORD FAR *)lpSrc;
				*lpDst++ = *(LPSTR)(dwrd.c + 3);
				*lpDst++ = *(LPSTR)(dwrd.c + 2);
				*lpDst++ = *(LPSTR)(dwrd.c + 1);
				*lpDst++ = *(LPSTR)(dwrd.c);
			}
		}
		else {		/* we'll have to go backward */
			lpSrc += nbytes - sizeof(DWORD);
			lpDst += nbytes - 1;
			for (; dwords--; lpSrc -= 4) {
				dwrd.dw = *(DWORD FAR *)lpSrc;
				*lpDst-- = *(LPSTR)(dwrd.c);
				*lpDst-- = *(LPSTR)(dwrd.c + 1);
				*lpDst-- = *(LPSTR)(dwrd.c + 2);
				*lpDst-- = *(LPSTR)(dwrd.c + 3);
			}
		}
}
