;mode1.ASM - program to set COM1-COM4 port to 38400 baud.

;This version corrects a bug in the original 19200 program which
;prevented it from setting COM2-COM4.  It only worked on COM1.
;Corrections made by Keith Petersen, W8SDZ, January 21, 1989.

;v1.1
; - Stupid error .. swapping ax/cx instead of ax/dx .. dumb!
;
;Toad Hall Tweak
; - Changed to MASM format.
; - Added full baud table for superhi rates
;   (Requires second cmdline parm).
; - Added some usage/error msgs.
;
;David Kirschbaum
;Toad Hall

_19200	equ	6		;19200 bps divisor
_38400	equ	3		;38400 baud
_57600	equ	2		;57600 baud
_115200	equ	1		;donno if this'll work

;DIVISOR equ	_38400		;whatever

CR	equ	0DH
LF	equ	0AH

CSEG	segment para public 'CODE'
	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG

	org	100H

Baud	proc	near

	CLD
	mov	dx,offset usage		;help msg
	xor	ah,ah			;clear msb
	MOV	SI,81H			;point to command line buffer

PortLup:
	LODSB				;get byte
	CMP	AL,0DH			;carriage return?
	JZ	MsgExit			;yes, display usage, exit
	CMP	AL,31H			;is it less than a "1"?
	JB	PortLup			;yes, loop
	CMP	AL,34H			;is it more than a "4"?
	JA	PortLup			;yes, loop

	SUB	AL,31H			;correct to binary (COM1=0, COM2=1,
					; COM3=2, COM4=3)

;	ROL	AX,1			;multiply by two to later point
	shl	ax,1			;*2 for 16-bit offset
	MOV	BX,AX			;save port offset in BX for later use

;v1.1 2d parm could be "1", "3", "5", '+' (for 19200, 38400, 57600 bps)
; or '+' for superhi (unlikely)

BaudLup:
	lodsb				;get byte
	cmp	al,CR			;carriage return?
	jz	MsgExit			;yes, display usage, exit
	cmp	al,' '			;just a spacer?
	jz	BaudLup			;yep, gobble it
	cmp	al,'1'			;'19200'?
	jz	GotBaud			;yep
	cmp	al,'3'			;'38400'?
	jz	GotBaud			;yep
	cmp	al,'5'			;'57600'?
	jz	GotBaud
	cmp	al,'+'			;superhi?
	mov	al,'7'			;assume yes
	jnz	MsgExit			;nope, error, show usage
	
GotBaud:
	sub	AL,31H			;correct to binary and table offset
					; ('1' = 0, '3' = 2,'5' = 4, etc.)
	add	ax,offset baudtbl	;baud table base
	mov	si,ax			;SI -> baud table[baud] (words)

	XOR	AX,AX			;zero A register pair
	mov	DS,ax			;put it in the segment register
	ASSUME	DS:NOTHING

	mov	ax,offset noport	;possible error msg
	MOV	DX,[BX+400H]		;get 16-bit port base address
	TEST	DX,DX			;check to see if there's a port defined
	xchg	ax,dx			;assume failure (err msg in DX)
	jz	MsgExit			;yep, error msg, exit

	xchg	ax,dx			;swap port addr back to DX

	mov	cx,3			;get a handy constant
	add	dx,cx			;index to uart line control register
	IN	AL,DX			;get current status byte (like 8N1)

	MOV	BL,AL			;save current status byte in BL
	OR	AL,80H			;set bit 7 to tell uart we're setting
					; divisor rate
	OUT	DX,AL			;tell uart

	sub	dx,cx			;index to divisor latch
;	mov	ax,DIVISOR		;the baudrate divisor you want
	mov	ax,CS:[si]		;snarf correct baud rate divisor word
	OUT	DX,AX			;set new rate

	add	dx,cx			;index back to uart
					; line control register
	MOV	AL,BL			;get saved status
	OUT	DX,AL			;restore old status
	mov	dx,offset beep		;just beep to ack it happened

MsgExit:
	mov	ax,CS			;insure DS=CS
	mov	DS,ax
	mov	ah,9			;display msg in DX
	int	21H

	INT	20H			;terminate

baudtbl	dw	_19200			;'1'
	dw	_38400			;'3'
	dw	_57600			;'5'
	dw	_115200			;'+'

usage	label	byte
 db 'TOADMODE.COM will increase the baud rate of COM ports 1-4',CR,LF
 db 'to rates higher than the DOS MODE command permits.',CR,LF
 db 'TOADMODE.COM must be used after the MODE command!',CR,LF,LF
 db 'Syntax for configuration:',CR,LF,LF
 db 'C:\>mode COMx:9600,n,8,1',CR,LF
 db 'C:\>toadmode x b',CR,LF,LF
 db '	where x = 1 for COM1',CR,LF
 db '		  2 for COM2',CR,LF
 db '		  3 for COM3',CR,LF
 db '		  4 for COM4',CR,LF
 db '	and   b = 1 for 19200 bps',CR,LF
 db '		  3 for 38400 bps',CR,LF
 db '		  5 for 57600 bps',CR,LF
 db '		  + for 115,200 bps',CR,LF,LF
 db '(No guarantees your serial card UART will run at ANY of these speeds!)'
 db CR,LF,'v1.1, Courtesy of David Kirschbaum, Toad Hall',CR,LF,'$'

noport	db	7,'No COM port found',CR,LF,'$'

beep	db	7,'$'

Baud	endp

CSEG	ENDS
	END	Baud
