Comment *
Ŀ
 Title   : int24hnd							     
 Purpose : This procedure is an interrupt handler which installed, bypasses 
	    the abort retry ignore messages and returns the error code to    
	    the program using the Inter program communications area at	     
	    0x40:0xF0. See the dos tech reference manual for details about   
	    how this works.						     
									     
	Written by Jack Zucker - 75766,1336    301-794-5950		     

 *
	assume cs:_text
_text	segment public byte 'code'
	public _int24hnd,_int24error

_int24hnd  proc near
				; at this point, the first 3 words on the
				; stack are:
				; IP,CS,Flags as a result of the Failed
				; dos call.

	add sp,06h;		; Discard dos stack info

	mov cs:error,di        ; save error in code segment

	pop ax			; pop all registers
	pop bx
	pop cx
	pop dx
	pop si
	pop di
	pop bp
	pop ds
	pop es
				; Now whats left on the stack is:
				; IP,CS,Flags of the guy who called
				; the dos interrupt in the first place
				; so lets return to him !

	iret			; return to who called the int 21h
_int24error	label far
error	dw	0
_int24hnd  endp
_text	ends
end
