#include <stdio.h>
char *me;
/* cp.c - implements a version of UNIX cp */
char target_name[128];
cp(argc,argv)
int argc;
register char *argv[];
{
	static char *usage = "cp : usage cp file1 [file2 . . fileN] target\r\n";
    char target[128],*fname_part();
    register int i;
	me = argv[0];
    if (argc < 3)
    {
	write(2,usage,strlen(usage));
	return(-1);
    }
    strcpy(target, argv[argc-1]);
    /* kill trailing backslashes */
    if (target[i = strlen(target) - 1] == '\\')
	target[i] = '\0';
    if (argc == 3)
    {
	if (target[1] == ':' && !target[2])
	    strcat(target,fname_part(argv[1]));
	/* if the target doesn't exist and it's not a directory then rename */
	if (access(target,0) && !dirp(target))
	{
	    fprintf(stderr,"copying %s to %s\n",argv[1],target);
	    filecopy(target,argv[1]);
	}
	else
	{
	    /* if the target is a directory copy to same name that directory */
	    if (dirp(target))
	    {
		int len;
		strcpy(target_name,target);
		if (target_name[(len = strlen(target_name))-1] != '\\')
		{
		    target_name[len = strlen(target_name)] = '\\';
		    target_name[len+1] = '\0';
		}
		strcat(target_name,fname_part(argv[1]));
		fprintf(stderr,"copying %s to %s\n",argv[1],target_name);
		filecopy(target_name,argv[1]);
	    }
	    else
	    {
		fprintf(stderr,"copying %s to %s\n",argv[1],target);
		filecopy(target,argv[1]);
	    }
	}
	return(0);
    }
    /* handle special case of a drive designation */
    if (target[(i = strlen(target))-1] != ':')
	if (!dirp(target))
	{
	    fprintf(stderr,"cp : %s isn't a directory\n",target);
	    return(-1);
	}
    for (i = 1; i < argc-1; i++)
    {
	int len;
	strcpy(target_name,target);
	if (target_name[(len = strlen(target_name))-1] != '\\')
	{
	    target_name[len = strlen(target_name)] = '\\';
	    target_name[len+1] = '\0';
	}
	strcat(target_name,fname_part(argv[i]));
	if (!filep(argv[i]))
	{
	    fprintf(stderr,"cp : %s isn't a file\n",argv[i]);
	    continue;
	}
	fprintf(stderr,"copying %s to %s\n",argv[i],target_name);
	filecopy(target_name,argv[i]);
    }
	return 0;
}

#include <fcntl.h>
char buffer[BUFSIZ*16];
filecopy(target,source)
char *target,*source;
{
    int t,s,r;
    if (-1 == (s = open(source,O_RDONLY)))
    {
		fprintf(stderr,"%s : can't open %s\n",me,target);
		return(-1);
    }
    if (-1 == (t = open(target,O_TRUNC)))
    {
		fprintf(stderr,"%s : can't open %s\n",me,target);
		return(-1);
    }
    while(0 != (r = read(s,buffer,BUFSIZ*16)) && r != -1)
    {
		if(-1 == write(t,buffer,r))
		{
		    fprintf(stderr,"%s : error writing %s\n",me,target);
		    return(-1);
		}
    }
    close(t); 
    close(s);
	return (0);
}

#include <errno.h>
typedef struct
{
    char dos_reserved[21];
    char attribute;
    unsigned file_time;
    unsigned file_date;
    long file_size;
    char file_name[13];
} 
fcb;
fcb dir;

dirp(s)
char *s;
{
    /* set the disk transfer address */
    bdos(0x1A,&dir);
    /* do a search first for the directory path */
    return (bdos(0x4E,s,0x10) == 0 && bdos(0x4E,s,0) != 0);
}

filep(s)
char *s;
{
    /* set the disk transfer address */
    bdos(0x1A,&dir);
    /* do a search first for the directory path */
    return bdos(0x4E,s,0) == 0;
}
char *fname_part(s)
register char *s;
{
    register char *r; 
    char *rindex();
    if (r = rindex(s,'\\'))
	s = r+1;
    if (r = rindex(s,':'))
	s = r+1;
    return s;
}
