:SRL.BAT Search ONLY Using FGREP.COM                                   4/17/92
:
:1) SYNTAX:                          SRL.BAT %1 %2 %3
:                                      Ŀ
:             (Mode)              %1            %2             %3
:                            Search Text     File Name/List  Option
:         ----------------   -------------   --------------  -------
:      a) Query                   [ ]           [ ]            [ ]
:      b) Partial Query      Search Text        [ ]            [ ]
:      c) Partial Query      Search Text        [ ]          Option
:      d) Command line       Search Text     File Name/List    [ ]
:      e) All command line   Search Text     File Name/List  Option
:
:         where:    %1  - Search Text
:                   %2  - File Name or @FileList
:                   %3  - FGREP options, no minus
:                   [ ] - entered at query prompt
:2) Requires FGREP.COM, INPUT.COM and SRL.MAC
:3) Uses File List %FileName% if no File Name is specified during input.
:   Specify File Name list as [@FileList] to use an alternate File_List,
:   or specify File Name, wild cards OK.
:4) FGREP options can be input at option prompt or %3, Default option is "fl"
:5) Set environment variable OPT=off to bypass FGREP Option query prompt.
:   Set  OPT=    to *not* bypass FGREP Option query prompt.
:
:
:
:*******************************************************************************
:*                                                                             *
:* Environment Variable        Action                                          *
:* --------------------------- ----------------------------------------------- *
:* set opt=                    does not bypass option query prompt             *
:* set opt=off                 bypasses option query prompt                    *
:* set filelist=               uses sm.lst for testing this batch file         *
:* set filelist=srch-fg.lst    searches with standard file list srch-fg.lst    *
:* set filelist=c:\srch-fg.lst searches with standard file list c:\srch-fg.lst *
:* set srmac=                  macro files are located in current directory    *
:* set srmac=c:\               macro files are located in c:\ directory        *
:*                                                                             *
:*******************************************************************************
:
@echo off
cls
set S~~=%1
set file=%2
set option=%3
if     "%filelist%" == "" set filelist=sm.lst
if not "%1" == ""    if not "%2" == "" goto 2b
if not "%1" == ""    goto 1a
if     "%1" == ""    echo Search Text: [{Blank} terminates batch file]
INPUT.COM Search Text=/b
if errorlevel=1 goto 6a
set S~~=%ans%
goto 2a
:1a
echo Search Text=%S~~%
:2a
set ans=
if "%2" == "" echo File Name(s): [Enter=%FileList%]  [File Name(s)]  [@FileList]
INPUT.COM File Name(s)=/b
if errorlevel=1 goto 2b
set file=%ans%
:2b
set ans=
if not "%opt%" == "" goto 2c
if not    "%3" == "" goto 2c
echo Option(s): [{Blank}=FGREP default="fl"]   [abBcvw, no minus]
INPUT.COM option(s)=/b
set option=%ans%
:2c
if "%file%" == "" set file=@%filelist%

:4a
cls
echo Search Text   = %S~~%
echo File Name(s)  = %file%
echo Option(s)     = %option%
break on
FGREP.COM -fl%option% /%S~~%/ %file% >c:\$.ql
break off
set >c:\$
copy c:\$.ql c:\!
Q.EXE        c:\!    /E%srmac%SRL.MAC /L%srmac%SRL.MAC
goto 7a
:6a
echo.
echo Search INCOMPLETE
goto 8a
:7a
echo.
echo Search Complete
:8a
echo.
