;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.model medium, Basic
.data
	;external data so all video routines can access
	EVEN
	EXTRN	B$DVIDEOSEG:WORD
	EXTRN   B$DVIDEOPORT:WORD
	EXTRN   B$DVIDEODI:WORD
	EXTRN   B$DVIDEOINSTL:BYTE
.code

INCLUDE NOWAIT.INC
EXTRN	Get_Adapter:FAR
EXTRN	SET_DI:FAR

;============================================================================
; QPRINT.ASM - performs Quick Printing in the QuickBASIC
; DECLARE SUB QPRINT (BYVAL ROW%, BYVAL COL%, Text$, BYVAL ATTRIBUTE%)
; Works in TextMode only, ignores all special characters
; Sensitive to all video modes (i.e. no snow on CGA's)
; If no attribute is selected, the default attribute is &h07 (normal)
; Assumes: Display width is 80 columns, Rows are 25, 43, or 50
;============================================================================

EVEN
QPRINT Proc FAR BASIC USES SI DI, \
ROW:Ptr, COLL:Ptr, TEXTSTRG:Ptr, ATTRIB:Ptr

comment |
     Register usage when all done:
     AH = Color attribute for printing entire string.
     AL = temporarily holds the character to print.
     CX = Length of Text string.
     DX = Port for CGA video retrace check, if necessary.
          0 means display is not a not a CGA display
     DI = Offset of Screen for current character
     ES = Segment of Video display, 0xB000 or 0xB800
     SI = Offset of Text String
     DS = Assumed to point to segment containing Text string.
          Program does not set this, so string is assumed to
          be a near string in DGROUP, the default in QB 4.5
     BX = is used as a scratch variable register
     |

	Assume	DS:@data

	Cmp   B$DVIDEOINSTL,1 ;See if we have done this before
	JE    Didit        ;yep, so skip ahead
	Call  Get_Adapter  ;call routine to find display type

Didit:
	Mov   CX,ROW       ;read value of Row
			   ;   allow EGA 43 line/ VGA 50 line
	Dec   CX           ;convert to BIOS format
	Cmp   CX,49        ;check if within range 1 to 50
	JA    Exit         ;exit if too large, or 0
	Mov   DH,CL        ;store ROW (CL) in DH

	Mov   CX,COLL      ;read value of COLL
	Dec   CX           ;convert to BIOS format
	Cmp   CX,79        ;check if within range 1 to 80
	JA    Exit         ;exit if too large, or 0
	Mov   DL,CL        ;store COLL (CL) in DL
	CALL SET_DI        ;call routin to find video seg offset in DI
      
	Mov   ES,B$DVIDEOSEG  ;restore the initialized values
	Mov   DX,B$DVIDEOPORT ;puts 0 in DX if not CGA
	Mov   AX,ATTRIB    ;get the color ATTRIBUTE% that was passed
	Mov   AH,AL        ;put it into AH for screen writing below
	Or    AH,AH        ;& make sure attribute is not &H00
	Jnz   @f           ;this is the default if no attribute selected
	Mov   AH,07        ;Default of black background, white letters
@@:
	Mov   SI,TEXTSTRG  ;put descriptor to TEXT$ into SI
	Mov   CX,[SI]      ;put Len(TEXT$) into CX for loop counter
	JCXZ  Exit         ;if CX is zero it's a null string, exit now
	Mov   SI,[SI+02]   ;put address of first character in X$ into SI
	Cld                ;clear the direction flag to move data forward

Main_Loop:
	Or    DX,DX        ;are we on a mono or EGA system (is DX = 0)?
	JZ    Mono         ;yes, skip over the retrace stuff

EVEN
CGA:
	CLI                ;prevent interrupts to speed routine
	Wait_CGA_Retrace   ;wait for CGA retrace MACRO
	Lodsb              ;get the character from TEXT$ and increment SI
	Stosw              ;store both the character and attribute
	STI                ;allow interrupts again
	Loop  CGA          ;loop until CX is zero
	Jmp  Short  Exit
EVEN
Mono:
	Lodsb              ;get the character from TEXT$ and increment SI
	Stosw              ;store both the character and attribute
	Loop  Mono         ;loop until CX is zero

Exit:
	Mov   B$DVIDEODI,DI ;save current DI
	Ret                ;return skipping the passed parameters
QPRINT  Endp

;============================================================================
; QPRT.ASM - performs Quick Printing in the QuickBASIC
; DECLARE SUB QPRT (BYVAL ROW%, BYVAL COL%, TEXT$)
; Works in TextMode only, ignores all special characters
; Sensitive to all video modes (i.e. no snow on CGA's)
; Does not change the attribute, uses whatever was there.
; Much faster than LOCATE X,Y : PRINT T$
; Routine is about 6   times faster than PRINT on a color EGA on an AT
;            about 4.5 times faster than PRINT on a color VGA on a AT-SX
;            about 7   times faster than PRINT on a mono EGA on an AT
;            about 2   times faster than PRINT on a CGA on an IBM PC
;            about 5   times faster than PRINT on a HERC on an AT
;            about 6   times faster than PRINT on a COMPAQ Portable
;
; Assumes: Display width is 80 columns, Max Rows are 25, 43, or 50
;============================================================================

EVEN
QPRT Proc FAR BASIC USES SI DI, \
ROW:Ptr, COLL:Ptr, TEXTSTRG:Ptr,

        Assume	DS:@data

	Cmp   B$DVIDEOINSTL,1 ;See if we have done this before
	JE    Didit1       ;yep, so skip ahead
	Call  Get_Adapter  ;call routine to find display type

Didit1:
	Mov   CX,ROW       ;read value of ROW
			   ;--allow EGA 43 line/ VGA 50 line
	Dec   CX           ;convert to BIOS format, 0 wd become &HFFFF
	Cmp   CX,49        ;check if within range 1 to 50
	JA    Exit1        ;exit if too large
	Mov   DH,CL        ;store CL in DH

	Mov   CX,COLL      ;read value of COLL
	Dec   CX           ;convert to BIOS format, a 0 wd become &HFFFF
	Cmp   CX,79        ;check if within range 1 to 80,
	JA    Exit1        ;exit if too large, exit if >80 or = 0
	Mov   DL,CL        ;store CL in DL

	CALL SET_DI        ;call routine to find video seg offset in DI

	Mov   ES,B$DVIDEOSEG  ;restore the initialized values
	Mov   DX,B$DVIDEOPORT ;DX = 0 if not CGA, else CGA retrace port

	Mov   SI,TEXTSTRG  ;put descriptor to TEXT$ into SI
	Mov   CX,[SI]      ;put Len(TEXT$) into CX for loop counter
	JCXZ  Exit1        ;if CX is zero it's a null string, exit now
	Mov   SI,[SI+02]   ;put address of first character in X$ into SI
	Cld                ;clear the direction flag to move data forward

Main_Loop1:
	OR    DX,DX        ;are we on a mono or EGA system (is DX = 0)?
	JZ    Mono1        ;yes, skip over the retrace stuff

EVEN			   ; speeds loop
CGA1:
	CLI                ;prevent interrupts to speed routine
	Wait_CGA_Retrace   ;wait for CGA retrace MACRO
	Lodsb              ;get the character from TEXT$ and increment SI
	Stosb              ;store just the character but not the attribute
	STI                ;allow interrupts again
	Inc    DI          ;skip to next cell
	Loop   CGA1        ;loop until CX is zero
	Jmp   Short  Exit1

EVEN			   ; speeds loop
Mono1:
	Lodsb              ;get the character from TEXT$ and increment SI
	Stosb              ;store just the character but not the attribute
	Inc    DI          ;skip to next cell
	Loop   Mono1       ;loop until CX is zero

Exit1:
	Mov  B$DVIDEODI,DI ;save current DI
	Ret                ;return skipping the passed parameters
QPRT    Endp

;============================================================================
; DECLARE SUB QATTRIB (BYVAL ROW%, BYVAL COL%, BYVAL NUMCHAR%, BYVAL ATTRIB%)
; CALL QATTRIB(ROW%, COL%, NUMCHAR%, ATTRIB%)
; Row, Column is the starting location. attribute is the color
; and Numchar is the number of characters to change.
; Changes the attribute of characters on the screen in text mode
; Assumes: Display width is 80 columns, Rows are 25, 43, or 50
;============================================================================

EVEN
QATTRIB Proc FAR BASIC USES SI DI, \
ROW:Ptr, COLL:Ptr, NUMCHAR:Ptr, ATTRIB:Ptr

comment |
     Register usage when all done:
     AH = Color attribute to change NUMCHAR to
     AL = loading point for STOB, scratch.
     CX = Number of characters to change.
     DX = Port for CGA video retrace check, if necessary.
          0 means display is not a not a CGA display

     DI = Offset of Screen for current character
     ES = Segment of Video display, 0xB000 or 0xB800

     DS = Assumed to point to segment containing Text string
          Program does not set this, so string is assumed to
          be a near string in DGROUP
     SI = is used as a scratch variable register
     BX = is used as a scratch variable register
     |

        Assume	DS:@data

	Cmp   B$DVIDEOINSTL,1  ;See if we have done this before
	JE    Didit2           ;yep, so skip ahead
	Call  Get_Adapter      ;call routine to find display type

Didit2:
	Mov   CX,ROW           ;read value of ROW
	Dec   CX               ;convert to BIOS format
			       ;allow EGA 43 line/ VGA 50 line
	Cmp   CX,49            ;check if within range 1 to 50
	JA    Exit2            ;exit if too large, > 80 or = 0
	Mov   DH,CL            ;store CL in DH

	Mov   CX,COLL          ;read value of COLL
	Dec   CX               ;convert to BIOS format
	Cmp   CX,79            ;check if within range 1 to 80
	JA    Exit2            ;exit if too large, > 80 or = 0
	Mov   DL,CL            ;store CL in DL

	CALL SET_DI            ;call routine to find video seg offset in DI
	Mov   ES,B$DVIDEOSEG    ;restore the initialized values
	Mov   DX,B$DVIDEOPORT

	Mov   AX,ATTRIB        ;get the color ATTRIBUTE% that was passed
	Mov   AH,AL            ;put it into AH for screen writing below
	Mov   CX,NUMCHAR       ;put number into CX for loop counter
	JCXZ  Exit2            ;if CX is zero, quit
	Cld                    ;clear the direction flag to move data forward
	Mov   AL,AH            ;get attribute & put it in AL

Main_Loop2:
	OR    DX,DX            ;are we on a mono or EGA system (is DX =0)?
	JZ    Mono2            ;yes, skip over the retrace stuff

EVEN
CGA2:
	CLI                    ;prevent interrupts to speed display
	Wait_CGA_Retrace       ;wait for CGA retrace MACRO
	Mov   AL,AH            ;get attribute & put it in AL
	Inc   DI
	Stosb                  ;store just the attribute
	STI                    ;allow interrupts again
	Loop  CGA2             ;loop until CX is zero
	Jmp   Short Exit2

EVEN
Mono2:
	Inc   DI
	Stosb                  ;store just the attribute
	Loop  Mono2            ;loop until CX is zero

Exit2:
	Mov   B$DVIDEODI,DI    ;save current DI
	Ret                    ;return skipping the passed parameters
QATTRIB  Endp
END
