;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.MODEL MEDIUM,BASIC

.DATA
        ;external data so all video routines can access
        EXTRN   B$DVIDEOSEG:WORD
        EXTRN   B$DVIDEOPORT:WORD
        EXTRN   B$DVIDEOINSTL:BYTE

.CODE
INCLUDE  NOWAIT.INC
EXTRN   Get_Adapter:FAR

;============================================================================
; DECLARE SUB RECOLOR (BYVAL OrigColor%, BYVAL NewColor%)
; CALL RECOLOR( OrigColor%, NewColor%)
; Purposes: Change one specific color to another without upsetting the display
; or using palette registers (which couldn't be restored easily using an EGA)
;
; Color is written as BackGround * 16 + ForeGround color
;
; Sensitive to all video modes (i.e. no snow on CGA's)
; Assumes: Display width is 80 * 25, 80 * 43 or 80 * 50
;============================================================================

EVEN
RECOLOR PROC FAR BASIC USES SI DS, OLD_COLOR:WORD, NEW_COLOR:WORD

	Assume DS:@data

        Cmp     B$DVIDEOINSTL,1   ; See if we have done this before
        JE      Didit             ; yep, so skip ahead
        Call    Get_Adapter       ; call routine to find display type

Didit:
                                  ; determine video page size, do it the hard
                                  ; way (row times column) because of error
                                  ; in certain HERC clones
        Xor     AX,AX             ; clear AX
        Mov     ES,AX             ; set ES to BIOS ram
        Xor     BH,BH             ; clear high byte
        Mov     BL,Byte Ptr ES:[0484h]  ; read ROW from BIOS ram
        Or      BL,BL             ; is ROW 0? (i.e. is this CGA, HERC or MONO?)
        JNZ     @f                ; nope, it is a EGA, MCGA or VGA
        Mov     BL,24             ; set default ROW to 24
@@:
        Inc     BL                ; remove 0 bias of ROW
        Mov     AX,ES:[044Ah]     ; read COLUMN from BIOS ram
        Mul     BX                ; multiply ROW times COLUMN
        Mov     CX,AX             ; store Page_Size in bytes in CX
        Mov     DX,B$DVIDEOPORT   ; get retrace port info
                                  ; DX = 0 if MONO or EGA/VGA, else = CGA
                                  ; retrace port
        CLD                       ; clear direction flag
        Mov     SI,1              ; start counting at attribute
        Mov     AX,OLD_COLOR      ; NOTE BYVAL in use
        Mov     BX,NEW_COLOR      ; NOTE BYVAL in use
        Mov     BH,AL             ; Get NEW_COLOR in BL
                                  ; Put OLD_COLOR in BH
        Mov     AX,B$DVIDEOSEG    ; get default video segment
        Mov     DS,AX             ; store in DS
        
Main:
        OR      DX,DX             ; is this a snowy CGA?
        JZ      Mono              ; DX = 0 so it is not

CGA:
        Cli
        Wait_CGA_Retrace          ; wait for CGA retrace MACRO
        Mov     AL, Byte Ptr DS:[SI]  ; read current attribute
        Cmp     AL,BH             ; does it equal OLD_COLOR?
        JNE     CGA1              ; nope skip ahead
        Sti                       ; allow interrupts for a second
        Cli                       ; clear interrupts again
        Wait_CGA_Retrace          ; wait for CGA retrace MACRO
        Mov     Byte Ptr DS:[SI],BL  ; write NEW_COLOR

CGA1:
        Sti                        ; allow interrupts again
        Add     SI,2               ; skip to next attribute
        Loop    CGA                ; do Loop again
        Jmp     short Finis        ; changed all the bytes

Mono:
        Mov     AL, Byte Ptr DS:[SI]  ; read attribute
        Cmp     AL,BH              ; does it equal OLD_COLOR?
        jnz     Mono1              ; nope so skip ahead
        Mov     Byte Ptr DS:[SI],BL   ; write NEW_COLOR

Mono1:
        Add     SI,2               ; skip to next attribute
        Loop    Mono               ; do loop again until all bytes changed

Finis:
        Ret
RECOLOR        ENDP
END
