;RM120TS8,16,24,32,40,48,56,64
;Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================


DOSSEG
.model medium, Basic

.data
	;external data so all video routines can access
	EVEN
	EXTRN  B$DVIDEOSEG:WORD
	EXTRN  B$DVIDEOPORT:WORD
	EXTRN  B$DVIDEOINSTL:BYTE
.code
INCLUDE NOWAIT.INC
EXTRN	Get_Adapter:FAR

comment         |
CalcOffSet_Save  macro
                              ;;destroys AX,CX & BX
                              ;;modifies SI
            Mov   AX,CurrRow
	    Dec   AX          ;;change from 1-25 to 0-24
	    Mov   CL,160
	    Mul   CL          ;;multiply CurrRow by 160
            Mov   BX,BegCol   ;;get starting column
	    Dec   BX          ;;change from 1-80 to 0-79
	    Shl   BX,1        ;;multiply (CurrRow-1) by 2
            Add   AX,BX       ;;get offset
            Mov   SI,AX       ;;move to source index
         endm
		|

CalcOffSet_Save    macro
	;; This is slightly slower in the abstract
	;; sense on a 80286.  Cannot observe the difference
	;; on a 8088 with a CGA because of delay waiting for retrace.
	;; Though if have an 8088 with MONO or VGA/EGA it is faster
	;;
	;; Input:     Nothing
	;; Output:    SI = Memory Offset
	;; Destroys:  CX,AX
	;; Macro is used because inline code speeds routine
	;;               ;8088 ;80286
	Xor     CL, CL     ;3    ;2   ;; Clear CL
	Mov     AX,CurrRow ;14   ;5   ;; get starting Row
	Dec     AX         ;3    ;2   ;; change from 1-25 to 0-24
	Mov     CH, AL     ;2    ;2   ;; CX = Row * 256
	Shr     CX, 1      ;2    ;2   ;; CX = Row * 128
	Mov     SI, CX     ;2    ;2   ;; Store in SI
	Shr     SI, 1      ;2    ;2   ;; SI = Row * 64
	Shr     SI, 1      ;2    ;2   ;; SI = Row * 32
	Add     SI, CX     ;3    ;2   ;; SI = (Row * 128)+(Row * 32)={Row*160}
	Xor     CH, CH     ;3    ;2   ;; Clear CH register
	Mov     AX,BegCol  ;14   ;5   ;; get starting Column
	Dec     AX         ;3    ;2   ;; change from 1-80 to 0-79
	Mov     CL, AL     ;2    ;2   ;; CX = Columns
	Shl     CX, 1      ;2    ;2   ;; Account for attribute
	Add     SI, CX     ;3    ;2   ;; SI = (Row * 160) + (Col * 2)
			   ;--------
	endm               ;60    ;36  ;; clocks


comment         |
CalcOffSet_Rest  macro
                              ;;destroys AX,CX & BX
                              ;;modifies DI
            Mov   AX,CurrRow
	    Dec   AX          ;;change from 1-25 to 0-24
	    Mov   CL,160
	    Mul   CL          ;;multiply CurrRow by 160
            Mov   BX,BegCol   ;;get starting column
	    Dec   BX          ;;change from 1-80 to 0-79
	    Shl   BX,1        ;;multiply (CurrRow-1) by 2
            add   AX,BX       ;;get offset
            Mov   DI,AX       ;;move to source index
         endm
		|

CalcOffSet_Rest    macro
	;; This is slightly slower in the abstract
	;; sense on a 80286.  Cannot observe the difference
	;; on a 8088 with a CGA because of delay waiting for retrace.
	;; Though if have an 8088 with MONO or VGA/EGA it is faster
	;;
	;; Input:     Nothing
	;; Output:    DI = Memory Offset
	;; Destroys:  CX,AX
	;; Macro is used because inline code speeds routine
	;;               ;8088 ;80286
	Xor     CL, CL     ;3    ;2   ;; Clear CL
	Mov     AX,CurrRow ;14   ;5   ;; get starting Row
	Dec     AX         ;3    ;2   ;; change from 1-25 to 0-24
	Mov     CH, AL     ;2    ;2   ;; CX = Row * 256
	Shr     CX, 1      ;2    ;2   ;; CX = Row * 128
	Mov     DI, CX     ;2    ;2   ;; Store in DI
	Shr     DI, 1      ;2    ;2   ;; DI = Row * 64
	Shr     DI, 1      ;2    ;2   ;; DI = Row * 32
	Add     DI, CX     ;3    ;2   ;; DI = (Row * 128)+(Row * 32)={Row*160}
	Xor     CH, CH     ;3    ;2   ;; Clear CH register
	Mov     AX,BegCol  ;14   ;5   ;; get starting Column
	Dec     AX         ;3    ;2   ;; change from 1-80 to 0-79
	Mov     CL, AL     ;2    ;2   ;; CX = Columns
	Shl     CX, 1      ;2    ;2   ;; Account for attribute
	Add     DI, CX     ;3    ;2   ;; DI = (Row * 160) + (Col * 2)
			   ;--------
	endm               ;60    ;36  ;; clocks


COMMENT |
===============================================================================
    WINDSAVE.ASM - saves a portion of the text screen in QuickBASIC
 call from Quickbasic:
 DECLARE SUB WINDSAVE(BYVAL ULR%, BYVAL ULC%, BYVAL LRR%, BYVAL LRC%,BYVAL SEGADD%, BYVAL OFFADR% )
 CALL  WINDSAVE(ULR%,ULC%,LRR%,LRC%,VARSEG(STORAGE(0)),VARPTR(STORAGE(0)))
 Description of parameters:
    Because a rectangle can be described by two points, we us the following
    data points:
       ULR = Upper left row
       UCL = Upper left column
       LRR = Lower right row
       LRC = Lower right column
    Dimension storage array to handle size of display in bytes
    E.g. 80*20 display would require an integer array of 1600
===============================================================================
          |

.code
EVEN
CurrRow        DW    0           ;current CurrRow
BegCol         DW    0           ;Starting Column
Num_Cols       DW    0           ;words to copy per line
EndingRow      DW    0           ;Ending Row

EVEN
WINDSAVE PROC FAR BASIC USES DI DS SI, \
ULR:PTR, ULC:PTR, LRR:PTR, LRC:PTR, SEGADD:PTR, OFFADD:PTR

	    Assume	DS:@data

	    Cmp   B$DVIDEOINSTL,1
	    JE    didit
	    Call  Get_Adapter      ;find information about display
didit:
	    Mov   DX,B$DVIDEOPORT
	    Push  B$DVIDEOSEG       ;save the screen segment for later
	    Mov   BX,OFFADD        ;get the starting address of the storage array
            Mov   DI,BX            ;and put it into DI
            Mov   BX,SEGADD        ;get the segment for the array
            Mov   ES,BX            ;and assign it to ES

            Mov   AX,ULC           ;get first column (BYVAL)
            Mov   BegCol,AX
            Mov   AX,LRC           ;get last column (BYVAL)
            SUB   AX,BegCol        ;subtract first column from first column
	    Inc   AX               ;Add 1 to get number of columns to print
            Mov   Num_Cols,AX      ;AX=# of words to copy per line
            Mov   AX,LRR           ;get last line (BYVAL)
            Mov   EndingRow,AX
            Mov   AX,ULR           ;get first line (BYVAL)
            Mov   CurrRow,AX
            CalcOffSet_Save        ;calculate offset for line
            Mov   CX,Num_Cols      ;load counter with words to copy
            Pop   DS               ;retrieve the screen segment saved from BX
                                   ; earlier
				   ; have to set DS last because when we do
				   ; we lose access to DGROUP and the stack
            Cld                    ;all data moves below will be forward
EVEN
ShowNext:
	    OR    DL,DL            ;monochrome or EGA (is DL = 0)?
            JZ    Mono             ;yes, skip over the retrace stuff
EVEN
CGA:
	    CLI                    ;prevent interrupts
	    Wait_CGA_Retrace       ;wait for CGA retrace MACRO
	    Movsw                  ;now get the word from the screen
				   ;and put it in array
	    STI                    ;allow interrupts again
	    Loop  CGA              ;loop until done
            Jmp   Short NextLine   ;skip over the mono routine
Mono:
            Rep   Movsw            ;move the data in one operation
NextLine:
            Mov   AX,EndingRow
	    CMP   AX,CurrRow       ;Are we done restoring window?
	    JE    Finis            ;Finis if complete
	    Inc   CurrRow          ;next line
            CalcOffSet_Save        ;compute new offset address
            Mov   CX,Num_Cols      ;set counter to number of words to copy
            jmp   Short ShowNext   ;jump to print next line
Finis:
	    Ret                    ;return skipping the passed parameters
            Assume	DS:@data
WINDSAVE    Endp

comment     |
===============================================================================
    WINDREST.ASM - restores a portion of the text screen in QuickBASIC

 DECLARE SUB WINDREST(BYVAL ULR%, BYVAL ULC%, BYVAL LRR%, BYVAL LRC%,BYVAL SEGADD%, BYVAL OFFADR% )
 CALL  WINDREST(ULR%,ULC%,LRR%,LRC%,VARSEG(STORAGE(0)),VARPTR(STORAGE(0)))
 Description of parameters:
    Because a rectangle can be described by two points, we us the following
    data points:
       ULR = Upper left row
       UCL = Upper left column
       LRR = Lower right row
       LRC = Lower right column
    Dimension storage array to handle size of display in bytes
    E.g. 80*20 display would require an integer array of 1600
===============================================================================
          |

EVEN
WINDREST PROC FAR BASIC USES DI DS SI, \
ULR:PTR, ULC:PTR, LRR:PTR, LRC:PTR, SEGADD:PTR, OFFADD:PTR

            Assume	DS:@data

	    Cmp   B$DVIDEOINSTL,1
	    JE    didit1
	    Call  Get_Adapter      ;find information about display

didit1:
	    Mov   DX,B$DVIDEOPORT
	    Mov   ES,B$DVIDEOSEG   ;save the screen segment in ES
	    Mov   AX,ULC           ;get first column (BYVAL)
            Mov   BegCol,AX
            Mov   AX,LRC           ;get last column (BYVAL)
            Sub   AX,BegCol        ;subtract first column from first column
	    Inc   AX               ;add 1 to get number of columns to print
            Mov   Num_Cols,AX      ;AX=# of words to copy per line
            Mov   AX,LRR           ;get last line (BYVAL)
            Mov   EndingRow,AX
            Mov   AX,ULR           ;get first line (BYVAL)
            Mov   CurrRow,AX	   ;set current row to first line
            CalcOffSet_Rest        ;calculate offset for line
            Mov   CX,Num_Cols      ;load counter with words to copy
            Mov   SI,SEGADD        ;get the segment of the storage array
	    Mov   AX,SI            ;and save it in AX for a moment
            Mov   SI,OFFADD        ;get the address of the first array element
	    Mov   DS,AX            ;okay to change DS after getting all variables
            Cld                    ;all data moves below will be forward
EVEN
ShowNext1:
	    OR    DL,DL            ;monochrome or EGA (is DL = 0)?
            JZ    Mono1            ;yes, skip over the retrace stuff
EVEN
CGA1:
	    CLI                    ;prevent interrupts
	    Wait_CGA_Retrace       ;wait for CGA retrace MACRO
	    Movsw                  ;now get the word from the screen
				   ;and put it into the array
	    STI                    ;allow interrupts again
	    Loop  CGA1             ;loop until done
            Jmp   Short NextLine1  ;skip over the mono routine
Mono1:
            Rep   Movsw            ;move the data in one operation

NextLine1:
            Mov   AX,EndingRow
	    CMP   AX,CurrRow        ;Are we done restoring window?
	    JE    Finis1            ;Finis if complete
	    Inc   CurrRow           ;next line
            CalcOffSet_Rest         ;compute new offset address
            Mov   CX,Num_Cols       ;set counter to # of words to copy
            Jmp   Short ShowNext1   ;jump to print next line
Finis1:
	    Ret                     ;return skipping the passed parameters
	    Assume      DS:@data
WINDREST Endp
END
