/*  ==============================================
**  structs.h -- These are various data structures
**               for use with Microsoft MS-DOS
**               function calls.
**  ==============================================
*/
/*  ms_date -- packed date format used in directory */
struct ms_date {
  unsigned d : 5;
  unsigned m : 4;
  unsigned y : 7;
};
/*  ms_time -- packed time format used in directory */
struct ms_time {
  unsigned xx : 5;
  unsigned mm : 6;
  unsigned hh : 5;
};
/*  extended_header -- header used in constructing an
**                     extended file control block.
*/
struct extended_header {
  char header;
  char zeros[5];
  char attrib;
};
/*  ext_fcb -- extended file control block */
struct ext_fcb {
  struct extended_header fcb_hdr;
  char drive_id;
  char file_name[8];
  char file_extension[3];
  unsigned curblok;
  unsigned recsize;
  long file_size;
  struct ms_date date;
  struct ms_time time;
  char reserved[8];
  char rec_in_blok;
  long rel_record;
};
/* Macros & values used in interpreting FAT entries */
#define AVAILABLE 0x0000
#define MAX_12BIT 0x0FF6
#define LOCKED_OUT(IS12) (IS12 ? 0x0FF7 : 0xFFF7)
#define LAST_CLUSTER(IS12) (IS12 ? 0xFFF : 0xFFFF)

/* Bits used in attribute field of directory entry */
#define READ_ONLY 0x01
#define HIDDEN    0x02
#define SYSTEM    0x04
#define VOL_ENTRY 0x08
#define DIRECTORY 0x10
#define ARCHIVE   0x20

/*  entry -- directory entry structure */
struct entry {
  char drive_no;
  char filname[11];
  char attributes;
  char unused[10];
  struct ms_time create_time;
  struct ms_date create_date;
  unsigned first_cluster;
  long filsize;
};
/*  extended_entry -- directory structure for use with
**                    extended file search
*/
struct extended_entry {
  struct extended_header dir_hdr;
  struct entry body;
};
/*  boot - layout of beginning of DOS boot record */
struct boot {
  unsigned char jump[3];
  unsigned char oem_name[8];          /* OEM */
  unsigned bytes_per_sector;          /* BPS */
  unsigned char sectors_per_au;       /* SPC */
  unsigned reserved_sectors;          /* RS  */
  unsigned char number_of_fats;       /* CF  */
  unsigned number_of_entries;         /* D   */
  unsigned number_of_sectors;         /* TS  */
  unsigned char media_descriptor;     /* MD  */
  unsigned fat_size;                  /* SPF */
  unsigned sectors_per_track;         /* SPT */
  unsigned number_of_heads;           /* NH  */
  unsigned hidden_sectors;            /* HS  */
};
/*  dd_header -- layout of DOS device driver header */
struct dd_header {
  struct dd_header far *link; /* chain to next header     */
  int attributes;             /* device attributes        */
  int strategy;               /* strategy routine addr    */
  int interrupt;              /* interrupt routine addr   */
  char name[8];               /* device name field        */
};

/*  disk_table -- layout of table returned by fn 32 */
struct disk_table {
  char designator;            /* PD                       */
  char alt_designator;        /* As above; 0 if RAMdisk   */
  unsigned sector_size;       /* BPS                      */
  char cluster_size;          /* SPC - 1                  */
  char heads;                 /* NH  - 1                  */
  unsigned fat_start;         /* RS                       */
  char fat_copies;            /* CF                       */
  unsigned max_entries;       /* D                        */
  unsigned first_sector;      /* FUS                      */
  unsigned last_cluster;      /* TCC + 1                  */
  unsigned char fat_size;     /* SPF                      */
  unsigned dir_start;         /* FDS                      */
  struct dd_header far *ddh;  /* DDA                      */
  unsigned media_type;        /* MD                       */
  struct disk_table far *nxt; /* chain to next disk_table */
  unsigned subdir_cluster;    /* CWD cluster (DOS 2 only) */
  char subdirectory[64];      /* CWD         (DOS 2 only) */
};
