/* auto1.c -  Automatic benchmark controller  */
#include "stdio.h"
static char *pname = "LPT1" ;

int nblock = 8096 ;
char *inname , *outname ;
FILE *prtfile ;
FILE *fopen() ;

int float1() , funcall() ,  pscopy() , ccount() , gpfile() ;
int bgpfile() ;
int sieve() , rwfile() , siever() , penregs() ;
int explog() , sintan() ;
int dofib() ;
int imath() , lmath() ;

main(argc,argv)
 int argc ;
 char *argv[] ;
 {
   int t ;

	if( argc < 2 )
     { fprintf(stderr," *** need Compiler name \n");
       exit(2) ;
     }
	 
   prtfile = fopen(pname,"w") ;
   if( prtfile == NULL )
     { fprintf(stderr,"\n\n *** can't open <%s> *** \n",pname) ;
       exit(5) ;
     }

   printf(" Compiler = %s \n\n",argv[1] ) ;
   fprintf(prtfile,"\n Compiler = %s \n\n",argv[1] ) ;
	t = runit(float1,20,"float dot prod. ") ;
	if( t < 180 )
			runit(float1,400,"float dot prod. ") ;
	runit(funcall,20,"function calls ") ;
	runit(pscopy,20,"ptr. str. copy ") ;
	runit(ccount,20,"char count ") ;
	inname = "a:test.in" ; outname = "a:test.out" ;
	delfile() ;
	runit(gpfile,2,"getc/putc file copy a:->a:") ;
	inname = "c:test.in" ; outname = "c:test.out" ;
	delfile() ;
	runit(gpfile,2,"getc/putc copy c:->c:") ;

	runit(sieve,20,"sieve ") ;

	inname = "a:test.in" ; outname = "a:test.out" ;
	nblock = 1024 ;
	delfile() ;
	printf("\n Read/Write file Copy\n");
	fprintf(prtfile,"\n Read/Write file Copy\n");
	runit(rwfile,1,"   block= 1024   a:->a:") ;
	inname = "c:test.in" ; outname = "c:test.out" ;
	nblock = 1024 ;
	delfile() ;
	runit(rwfile,1,"   block= 1024   c:->c:") ;


	inname = "a:test.in" ; outname = "a:test.out" ;
	delfile() ;
	nblock = 8096 ;
	runit(rwfile,1,"   block= 8096   a:->a:") ;

	inname = "c:test.in" ; outname = "c:test.out" ;
	delfile() ;
	nblock = 8096 ;
	runit(rwfile,1,"   block= 8096   c:->c:") ;

	runit(siever,100,"sieve with reg. var. ") ;
	runit(penregs,100,"str copy & reg var ") ;
	runit(imath,20,"integer arithmetic ") ;
	runit(lmath,20,"long arithmetic ") ;
	t = runit(explog,10,"math - exp and log ") ;
	if( t < 180 )
	  	runit(explog,100,"math - exp and log ") ;
	t = runit(sintan,10,"math - sin and tan ") ;
	if( t < 180 )
		runit(sintan,100,"math - sin and tan ") ;
	runit(dofib,20,"fibernacci(15) ") ;

   fclose(prtfile) ;
 }


int runit(pfun,niter,benname)
 int (*pfun)() ;
 int niter ;
 char *benname ;
 {
	int t , i ;

   eltime() ;
   for( i=1 ; i <= niter ; i=i+1 )
      { (*pfun) () ; }
   t = eltime() ;
    printf(" %-30s (%4d Iter.) - %4d Ticks or %8.2f Seconds \n",
       benname, niter, t , ( (float) t) / 18.2 ) ;
    fprintf(prtfile,"\n %-30s (%4d Iter.) - %4d Ticks or %8.2f Seconds ",
       benname, niter, t , ( (float) t) / 18.2 ) ;
	 return(t) ;
 }

delfile()
 {
    unlink(outname) ;
 }

