HELLO2.PAS

UNIT Hello2;

{$IFDEF ver55}
  {$DEFINE TP}
{$ELSE}
  {$IFDEF ver10}
    {$DEFINE QP}
  {$ELSE}
    CRASH HERE -- neither Turbo nor Quick
  {$ENDIF}
{$ENDIF}
(**********************)
(**)    INTERFACE   (**)
(**********************)

USES Crt;
TYPE
  message = OBJECT
    words : String;
    {$IFDEF TP}CONSTRUCTOR {$ELSE} PROCEDURE {$ENDIF}
    Init(iS : String);
    PROCEDURE Say; {$IFDEF TP}virtual;{$ENDIF}
  END;

  placeMessage = OBJECT(message)
    X,Y : Byte;
    {$IFDEF TP}CONSTRUCTOR {$ELSE} PROCEDURE {$ENDIF}
    InitPM(iS : String; iX,iY : Byte);
    PROCEDURE Say; {$IFDEF TP}virtual;{$ELSE}override;{$ENDIF}
  END;

  colorMessage = OBJECT(placemessage)
    color, SaveColor : Byte;
    {$IFDEF TP}CONSTRUCTOR {$ELSE} PROCEDURE {$ENDIF}
    InitCM(iS : String; iX, iY, iColor : Byte);
    PROCEDURE Say; {$IFDEF TP}virtual;{$ELSE}override;{$ENDIF}
  END;

  MsPt = ^Message;
  PMpt = ^PlaceMessage;
  CMpt = ^ColorMessage;
  MsgList = ^MsgNode;
  MsgNode = RECORD
    data : MsPt;
    next : msgList;
  END;

  List = OBJECT
    Nodes : MsgList;
    {$IFDEF TP}CONSTRUCTOR {$ELSE} PROCEDURE {$ENDIF}
    Init;
    PROCEDURE Add(MP : MsPt);
    PROCEDURE Show;
  END;

(**********************)
(**) IMPLEMENTATION (**)
(**********************)

  {$IFDEF TP}CONSTRUCTOR {$ELSE} PROCEDURE {$ENDIF}
  Message.Init(iS : String);
  BEGIN  self.words := iS;  END;

  PROCEDURE Message.Say;
  BEGIN  Write(self.words);  END;

  {$IFDEF TP}CONSTRUCTOR {$ELSE} PROCEDURE {$ENDIF}
  PlaceMessage.InitPM(iS : String; iX, iY : Byte);
  BEGIN
    {$IFDEF TP} Message.Init(iS);
    {$ELSE}     self.Init(iS);
    {$ENDIF}
    self.X := iX;
    self.Y := iY;
  END;

  PROCEDURE PlaceMessage.Say;
  BEGIN
    GotoXY(self.X,self.Y);
    {$IFDEF TP} Message.say;
    {$ELSE}	Inherited self.say;
    {$ENDIF}
  END;

  {$IFDEF TP}CONSTRUCTOR {$ELSE} PROCEDURE {$ENDIF}
  ColorMessage.InitCM(iS : String; iX, iY, iColor : Byte);
  BEGIN
    {$IFDEF TP} PlaceMessage.InitPM(iS,iX,iY);
    {$ELSE}	self.InitPM(iS,iX,iY);
    {$ENDIF}
    self.color := iColor;
  END;

  PROCEDURE ColorMessage.Say;
  BEGIN
    self.SaveColor := TextAttr;
    TextAttr := self.color;
    {$IFDEF TP} PlaceMessage.Say;
    {$ELSE}	Inherited self.say;
    {$ENDIF}
    TextAttr := self.SaveColor;
  END;

  {$IFDEF TP}CONSTRUCTOR {$ELSE} PROCEDURE {$ENDIF}
  List.Init;
  BEGIN  self.Nodes := NIL; END;

  PROCEDURE List.Add(MP : MsPt);
  VAR P : msgList;
  BEGIN
    New(P);
    P^.data := MP;
    P^.next := self.nodes;
    self.nodes := P;
  END;

  PROCEDURE List.Show;
  VAR P : MsgList;
  BEGIN
    P := self.nodes;
    WHILE P <> NIL DO
      BEGIN
	P^.data^.say;
	P := P^.next;
      END;
  END;

END.


