/*  exp.c
 *  For MSC 4.0/5.0/QuickC: cl exp.c
 */
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define DOS_COMMAND_LINE 128
#define LPAREN '('
#define RPAREN ')'
#define PERIOD '.'
#define BLANK ' '

main(argc, argv)
int argc;
char **argv;
{
  int i, echo_only = FALSE;
  char oldcommandline[DOS_COMMAND_LINE], newcommandline[DOS_COMMAND_LINE];
  char *lparen, *rparen, *period, *first_arg, *last_arg, *nextdelim;
  
  if(argc < 2)                    /* check usage */
    print_usage();

    /* check for echo only argument, and if so, set flag, increment
      arg pointer, and decrement the arg count
 */
  if((argv[1][0] == '-' || argv[1][0] == '/') && toupper(argv[1][1]) == 'E')
  {
    echo_only = TRUE;
    argv++;
    argc--;
  }
    /* put all command-line arguments into one buffer */
  for( i = 1, oldcommandline[0] = NULL; i < argc; i++)
  {
    strcat(oldcommandline,argv[i]);
    strcat(oldcommandline," ");
  }
  lparen = strchr(oldcommandline, LPAREN);
  rparen = strchr(oldcommandline, RPAREN);
  period = strchr(oldcommandline, PERIOD);

    /* check syntax: if no parens or if parens reversed */
  if(!lparen || !rparen || (rparen < lparen))
    print_usage();

    /* check syntax: if period supplied and in middle */
  if(period && ((period < rparen) && (period > lparen)) )
    print_usage();

    /* set last_arg to the remainder of the command line after our
      expanded filenames/extensions
 */
  last_arg = (rparen+1);

    /* copy up to the first paren into the new command buffer */
  strncpy(newcommandline, oldcommandline, lparen-oldcommandline);
  newcommandline[lparen-oldcommandline] = NULL;

    /* set first_arg to where the first argument will start each time */
  first_arg = &newcommandline[strlen(newcommandline)];
  lparen++;                /* point to first expansion */

    /* main loop:
      pick off each filename/extension,
      copy it into the buffer,
      tack on additional arguments
      run the command.
 */
  while(TRUE)
  {
    *first_arg = NULL;
    nextdelim = strpbrk(lparen, ",)");      /* find the next , or ) */
    *nextdelim = NULL;              /* NULL terminate */
    strcat(first_arg, lparen);          /* add to the command */
    strcat(first_arg, last_arg);          /* add to the command */

    if(echo_only)
      printf("\nexp: %s",newcommandline);     /* echo the command */
    else if(system(newcommandline))         /* execute the command */
        printf("\nexp: error executing \"%s\"",newcommandline);

    lparen = nextdelim+1;             /* move to next arg */
    while(*lparen == BLANK)
      lparen++;
    if(lparen > rparen)
      break;
  }
  exit(0);
}

print_usage()
{
  printf("\nexp [-e] DOScommand (filename1,...,filenameN).ext");
  printf("\nexp [-e] DOScommand filename.(ext1,...,extN)");
  exit(1);
}

