PROGRAM dirtree;
{ DIRTREE.pas
  Directory tree display
  written by Bill Roohi, 1988
}
USES dos;

CONST nested = 10; {up to 10 nested levels}

VAR dirinfo   : searchrec;
  lastdir     : ARRAY[1..nested] OF STRING[12];
  level       : Integer;
  path, blank : STRING[150];
  ok          : Boolean;

BEGIN
  ok := True;                  {initialize      }
  level := 0;                  {start at level 0}
  FillChar(blank[1], 150, 32); {used for tabs   }
  blank[0] := #150;
  GetDir(0, path);             {get current path}
  ChDir('\');                  {root directory  }

  Findfirst('*.*', anyfile, dirinfo); {start search    }
  WHILE ok DO
    BEGIN
      WHILE (doserror = 0) AND
            ((dirinfo.attr <> 16) OR
             (dirinfo.name = '.') OR
             (dirinfo.name = '..')) DO
        Findnext(dirinfo);
      IF (level = 0) AND (doserror <> 0) THEN
        ok := False  { End of root - time to exit }
      ELSE
        IF (dirinfo.attr = 16) AND (doserror = 0) THEN
          BEGIN                                 {subdir found}
            WriteLn(Copy(blank, 1, level*4)+
                                dirinfo.name);  {display it  }
            Inc(level);                         {next level  }
            lastdir[level] := dirinfo.name;     {save subdir }
            ChDir(dirinfo.name);                {new subdir  }
            Findfirst('*.*', anyfile, dirinfo); {start search}
          END
        ELSE
          IF (level <> 0) AND (doserror <> 0) THEN
            BEGIN                                {end of subdir }
              ChDir('..');                       {previous level}
              Findfirst('*.*', anyfile, dirinfo);{start search  }
              WHILE (doserror = 0) AND
                   ((dirinfo.attr <> 16) OR
                    (dirinfo.name <> lastdir[level])) DO
                Findnext(dirinfo);               {look for match}
              Findnext(dirinfo);                 {skip past it  }
              Dec(level);                        {previous level}
            END;
    END; {WHILE ok}
  ChDir(path);                      {to original path}
END.
